/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueInt;
import org.eclipse.ptp.internal.debug.core.pdi.aif.ValueIntegral;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFValueInt
extends ValueIntegral
implements IAIFValueInt {
    private ByteBuffer byteBuffer;

    public AIFValueInt(IAIFTypeInt type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
    }

    @Override
    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        byte[] dst = new byte[this.getType().sizeof()];
        int i = 0;
        while (i < dst.length) {
            dst[i] = buffer.get();
            ++i;
        }
        this.byteBuffer = ByteBuffer.wrap(dst, 0, dst.length);
        this.setSize(this.getType().sizeof());
    }

    @Override
    public String getValueString() throws AIFException {
        if (this.isShort()) {
            return String.valueOf(this.shortValue());
        }
        if (this.isInt()) {
            return String.valueOf(this.intValue());
        }
        if (this.isLong()) {
            return String.valueOf(this.longValue());
        }
        return new String(this.byteValue());
    }

    @Override
    public boolean isLong() {
        return this.sizeof() == 8;
    }

    @Override
    public boolean isShort() {
        return this.sizeof() == 2;
    }

    @Override
    public boolean isInt() {
        return this.sizeof() == 4;
    }

    @Override
    public byte[] byteValue() throws AIFException {
        return this.byteBuffer.array();
    }

    @Override
    public long longValue() throws AIFException {
        try {
            long l = this.byteBuffer.getLong();
            return l;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return 0L;
        }
        finally {
            this.byteBuffer.rewind();
        }
    }

    @Override
    public short shortValue() throws AIFException {
        try {
            short s = this.byteBuffer.getShort();
            return s;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return 0;
        }
        finally {
            this.byteBuffer.rewind();
        }
    }

    @Override
    public int intValue() throws AIFException {
        try {
            int n = this.byteBuffer.getInt();
            return n;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return 0;
        }
        finally {
            this.byteBuffer.rewind();
        }
    }
}

