/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchElement;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchResult;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchViewPage;

public class RemoteSearchListContentProvider
implements IStructuredContentProvider,
IPDOMSearchContentProvider {
    private TableViewer viewer;
    private RemoteSearchResult result;
    private final RemoteSearchViewPage fPage;

    RemoteSearchListContentProvider(RemoteSearchViewPage page) {
        this.fPage = page;
    }

    public Object[] getElements(Object inputElement) {
        HashSet<String> uncoveredProjects = new HashSet<String>();
        RemoteSearchResult result = (RemoteSearchResult)((Object)inputElement);
        Object[] results = result.getElements();
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = 0;
        while (i < results.length) {
            if (results[i] instanceof RemoteSearchElement) {
                RemoteSearchElement searchElement = (RemoteSearchElement)results[i];
                String path = searchElement.getLocation().getFullPath();
                if (path != null) {
                    uncoveredProjects.add(new Path(path).segment(0));
                }
                if (this.fPage.getDisplayedMatchCount(searchElement) > 0) {
                    resultList.add(searchElement);
                }
            }
            ++i;
        }
        if (result.wasIndexerBusy()) {
            resultList.add(IPDOMSearchContentProvider.INCOMPLETE_RESULTS_NODE);
        }
        ICProject[] projects = result.getQuery().getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            ICProject project = projects[i2];
            boolean foundProject = uncoveredProjects.contains(project.getProject().getName());
            if (!foundProject) {
                if (project.isOpen()) {
                    if (!CCorePlugin.getIndexManager().isProjectIndexed(project)) {
                        resultList.add(this.createUnindexedProjectWarningElement(project));
                    }
                } else {
                    resultList.add(this.createClosedProjectWarningElement(project));
                }
            }
            ++i2;
        }
        return resultList.toArray();
    }

    private Status createUnindexedProjectWarningElement(ICProject project) {
        return new Status(2, "org.eclipse.cdt.ui", MessageFormat.format(CSearchMessages.PDOMSearchListContentProvider_IndexerNotEnabledMessageFormat, project.getProject().getName()));
    }

    private Status createClosedProjectWarningElement(ICProject project) {
        return new Status(2, "org.eclipse.cdt.ui", MessageFormat.format(CSearchMessages.PDOMSearchListContentProvider_ProjectClosedMessageFormat, project.getProject().getName()));
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
        this.result = (RemoteSearchResult)((Object)newInput);
        viewer.refresh();
    }

    public void elementsChanged(Object[] elements) {
        if (this.result == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (this.fPage.getDisplayedMatchCount(elements[i]) > 0) {
                if (this.viewer.testFindItem(elements[i]) != null) {
                    this.viewer.refresh(elements[i]);
                } else {
                    this.viewer.add(elements[i]);
                }
            } else {
                this.viewer.remove(elements[i]);
            }
            ++i;
        }
    }

    public void clear() {
        this.viewer.refresh();
    }
}

