/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.ptp.remotetools.utils.stream.IStreamListener;

public class ListenedOutputStream
extends OutputStream {
    private IStreamListener listener;

    public ListenedOutputStream(IStreamListener listener) {
        this.listener = listener;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes = new byte[len];
        System.arraycopy(b, off, bytes, 0, len);
        this.listener.newBytes(bytes, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.listener.newBytes(b, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.listener.newBytes(bytes, bytes.length);
    }
}

