/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSchConnectionAttributes {
    public static final String CONNECTIONS_KEY = "connections";
    public static final String ADDRESS_ATTR = "JSCH_ADDRESS_ATTR";
    public static final String USERNAME_ATTR = "JSCH_USERNAME_ATTR";
    public static final String PASSWORD_ATTR = "JSCH_PASSWORD_ATTR";
    public static final String PORT_ATTR = "JSCH_PORT_ATTR";
    public static final String IS_PASSWORD_ATTR = "JSCH_IS_PASSWORD_ATTR";
    public static final String PASSPHRASE_ATTR = "JSCH_PASSPHRASE_ATTR";
    public static final String KEYFILE_ATTR = "JSCH_KEYFILE_ATTR";
    public static final String TIMEOUT_ATTR = "JSCH_TIMEOUT_ATTR";
    public static final String USE_LOGIN_SHELL_ATTR = "JSCH_USE_LOGIN_SHELL_ATTR";
    private String fName;
    private String fNewName;
    private final Map<String, String> fAttributes = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> fSecureAttributes = Collections.synchronizedMap(new HashMap());

    public JSchConnectionAttributes(String name) {
        this.fName = name;
        this.load();
    }

    private void clearPreferences() {
        try {
            this.getPreferences().clear();
        }
        catch (BackingStoreException e) {
            Activator.log(e.getMessage());
        }
        this.getSecurePreferences().clear();
    }

    public JSchConnectionAttributes copy() {
        JSchConnectionAttributes copy = new JSchConnectionAttributes(this.fName);
        copy.getAttributes().putAll(this.fAttributes);
        copy.getSecureAttributes().putAll(this.fSecureAttributes);
        return copy;
    }

    private void flushPreferences() {
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e.getMessage());
        }
        try {
            this.getSecurePreferences().flush();
        }
        catch (IOException e) {
            Activator.log(e.getMessage());
        }
    }

    public String getAttribute(String key, String def) {
        if (this.fAttributes.containsKey(key)) {
            return this.fAttributes.get(key);
        }
        return def;
    }

    public Map<String, String> getAttributes() {
        return this.fAttributes;
    }

    public String getName() {
        if (this.fNewName == null) {
            return this.fName;
        }
        return this.fNewName;
    }

    private Preferences getPreferences() {
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode(Activator.getUniqueIdentifier());
        Preferences connections = root.node(CONNECTIONS_KEY);
        return connections.node(this.fName);
    }

    public String getSecureAttribute(String key, String def) {
        if (this.fSecureAttributes.containsKey(key)) {
            return this.fSecureAttributes.get(key);
        }
        return def;
    }

    public int getInt(String key, int def) {
        try {
            return Integer.parseInt(this.fAttributes.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public boolean getBoolean(String key, boolean def) {
        if (this.fAttributes.containsKey(key)) {
            return Boolean.parseBoolean(this.fAttributes.get(key));
        }
        return def;
    }

    public Map<String, String> getSecureAttributes() {
        return this.fSecureAttributes;
    }

    private ISecurePreferences getSecurePreferences() {
        ISecurePreferences secRoot = SecurePreferencesFactory.getDefault();
        ISecurePreferences secConnections = secRoot.node(CONNECTIONS_KEY);
        return secConnections.node(this.fName);
    }

    private void load() {
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode(Activator.getUniqueIdentifier());
        Preferences connections = root.node(CONNECTIONS_KEY);
        Preferences nodes = connections.node(this.fName);
        try {
            this.loadAttributes(nodes);
        }
        catch (BackingStoreException e) {
            Activator.log(e.getMessage());
        }
        ISecurePreferences secRoot = SecurePreferencesFactory.getDefault();
        ISecurePreferences secConnections = secRoot.node(CONNECTIONS_KEY);
        ISecurePreferences secNode = secConnections.node(this.fName);
        try {
            this.loadAuthAttributes(secNode);
        }
        catch (StorageException e) {
            Activator.log(e.getMessage());
        }
    }

    private void loadAttributes(Preferences node) throws BackingStoreException {
        this.fAttributes.clear();
        String[] stringArray = node.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.fAttributes.put(key, node.get(key, null));
            ++n2;
        }
    }

    private void loadAuthAttributes(ISecurePreferences node) throws StorageException {
        this.fSecureAttributes.clear();
        String[] stringArray = node.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.fSecureAttributes.put(key, node.get(key, null));
            ++n2;
        }
    }

    public void save() {
        this.clearPreferences();
        if (this.fNewName != null) {
            this.fName = this.fNewName;
            this.fNewName = null;
        }
        this.savePreferences();
        this.flushPreferences();
    }

    public void remove() {
        this.clearPreferences();
        this.flushPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePreferences() {
        Preferences node = this.getPreferences();
        Map<String, String> map = this.fAttributes;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.fAttributes.entrySet()) {
                node.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            ISecurePreferences secNode = this.getSecurePreferences();
            Map<String, String> map2 = this.fSecureAttributes;
            synchronized (map2) {
                for (Map.Entry<String, String> entry : this.fSecureAttributes.entrySet()) {
                    secNode.put(entry.getKey(), entry.getValue(), true);
                }
            }
        }
        catch (StorageException e) {
            Activator.log(e.getMessage());
        }
    }

    public void setAttribute(String key, String value) {
        this.fAttributes.put(key, value);
    }

    public void setName(String name) {
        this.fNewName = name;
    }

    public void setSecureAttribute(String key, String value) {
        this.fSecureAttributes.put(key, value);
    }
}

