/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.JSchFileSystem;
import org.eclipse.remote.internal.jsch.core.JschFileStore;

public class JSchFileManager
implements IRemoteFileManager {
    private final JSchConnection fConnection;

    public JSchFileManager(JSchConnection connection) {
        this.fConnection = connection;
    }

    public String getDirectorySeparator() {
        return "/";
    }

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = new Path(this.fConnection.getWorkingDirectory()).append((IPath)path);
        }
        return JschFileStore.getInstance(JSchFileSystem.getURIFor(this.fConnection.getName(), path.toString()));
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        try {
            return JSchFileSystem.getURIFor(this.fConnection.getName(), path.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }
}

