/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.RemoteDebugOptions;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.JSchProcess;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JSchProcessBuilder
extends AbstractRemoteProcessBuilder {
    private final JSchConnection fConnection;
    private final Map<String, String> fRemoteEnv = new HashMap<String, String>();
    private final Set<Character> charSet = new HashSet<Character>();
    private Map<String, String> fNewRemoteEnv = null;

    public JSchProcessBuilder(JSchConnection connection, List<String> command) {
        super(command);
        this.fConnection = connection;
        this.fRemoteEnv.putAll(this.fConnection.getEnv());
        String trustedChars = null;
        trustedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        trustedChars = String.valueOf(trustedChars) + "0123456789/._-";
        StringCharacterIterator it = new StringCharacterIterator(trustedChars);
        char c = it.first();
        while (c != '\uffff') {
            this.charSet.add(Character.valueOf(c));
            c = it.next();
        }
    }

    public JSchProcessBuilder(JSchConnection connection, String ... command) {
        this(connection, Arrays.asList(command));
    }

    public IFileStore directory() {
        IFileStore dir = super.directory();
        IRemoteFileManager fileMgr = this.fConnection.getFileManager();
        if (dir == null && fileMgr != null) {
            dir = fileMgr.getResource(this.fConnection.getWorkingDirectory());
            this.directory(dir);
        }
        return dir;
    }

    public Map<String, String> environment() {
        if (this.fNewRemoteEnv == null) {
            this.fNewRemoteEnv = new HashMap<String, String>();
            this.fNewRemoteEnv.putAll(this.fRemoteEnv);
        }
        return this.fNewRemoteEnv;
    }

    public int getSupportedFlags() {
        return 3;
    }

    public IRemoteProcess start(int flags) throws IOException {
        if (!this.fConnection.isOpen()) {
            throw new IOException(Messages.JSchProcessBuilder_Connection_is_not_open);
        }
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.charEscapify((String)cmdArgs.get(i), this.charSet);
            ++i;
        }
        ArrayList<String> env = new ArrayList<String>();
        boolean clearEnv = false;
        if (this.fNewRemoteEnv != null) {
            for (String string : this.fRemoteEnv.keySet()) {
                if (this.fNewRemoteEnv.get(string) != null) continue;
                clearEnv = true;
                break;
            }
            if (clearEnv) {
                for (Map.Entry entry : this.fNewRemoteEnv.entrySet()) {
                    env.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                }
            } else {
                for (Map.Entry entry : this.fNewRemoteEnv.entrySet()) {
                    String oldValue = this.fRemoteEnv.get(entry.getKey());
                    if (oldValue != null && oldValue.equals(entry.getValue())) continue;
                    env.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                }
            }
        }
        try {
            ChannelExec channelExec = this.fConnection.getExecChannel();
            String command = this.buildCommand(remoteCmd, env, clearEnv);
            channelExec.setCommand(command);
            channelExec.setPty((flags & 1) == 1);
            channelExec.setXForwarding((flags & 2) == 2);
            channelExec.connect();
            RemoteDebugOptions.trace((String)"/debug/commands", (String)("executing command: " + command), (String[])new String[0]);
            return new JSchProcess(channelExec, this.redirectErrorStream());
        }
        catch (RemoteConnectionException remoteConnectionException) {
            throw new IOException(remoteConnectionException.getMessage());
        }
        catch (JSchException jSchException) {
            throw new IOException(jSchException.getMessage());
        }
    }

    private String buildCommand(String cmd, List<String> environment, boolean clearEnv) {
        StringBuffer sb = new StringBuffer();
        if (this.directory() != null) {
            sb.append("cd " + this.charEscapify(this.directory().toURI().getPath(), this.charSet) + " && ");
        }
        if (clearEnv) {
            sb.append("env -i");
            for (String env : environment) {
                sb.append(" \"" + env + "\"");
            }
            sb.append(" ");
        } else {
            for (String env : environment) {
                sb.append("export \"" + env + "\"; ");
            }
        }
        sb.append(cmd);
        if (this.fConnection.useLoginShell()) {
            sb.insert(0, "/bin/bash -l -c '");
            sb.append("'");
        }
        return sb.toString();
    }

    private String charEscapify(String inputString, Set<Character> charSet) {
        if (inputString == null) {
            return null;
        }
        StringBuffer newString = new StringBuffer("");
        StringCharacterIterator it = new StringCharacterIterator(inputString);
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\'') {
                newString.append("'\\\\\\''");
            } else if (c > '\u007f' || charSet.contains(Character.valueOf(c))) {
                newString.append(c);
            } else {
                newString.append("\\" + c);
            }
            c = it.next();
        }
        inputString = newString.toString();
        return inputString;
    }
}

