/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.ui;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.net.PasswordAuthentication;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IUserAuthenticator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JSchUserAuthenticator
implements IUserAuthenticator {
    private UserInfoPrompter prompter;

    public JSchUserAuthenticator(IRemoteConnection conn) {
        try {
            this.prompter = new UserInfoPrompter(new JSch().getSession(conn.getUsername(), conn.getAddress()));
        }
        catch (JSchException jSchException) {}
    }

    public PasswordAuthentication prompt(String username, String message) {
        if (this.prompter.promptPassword(message)) {
            PasswordAuthentication auth = new PasswordAuthentication(username, this.prompter.getPassword().toCharArray());
            return auth;
        }
        return null;
    }

    public String[] prompt(String destination, String name, String message, String[] prompt, boolean[] echo) {
        return this.prompter.promptKeyboardInteractive(destination, name, message, prompt, echo);
    }

    public int prompt(final int promptType, final String title, final String message, int[] promptResponses, final int defaultResponseIndex) {
        final Display display = this.getDisplay();
        final int[] retval = new int[1];
        final String[] buttons = new String[promptResponses.length];
        int i = 0;
        while (i < promptResponses.length) {
            int prompt = promptResponses[i];
            switch (prompt) {
                case 0: {
                    buttons[i] = IDialogConstants.OK_LABEL;
                    break;
                }
                case 1: {
                    buttons[i] = IDialogConstants.CANCEL_LABEL;
                    break;
                }
                case 3: {
                    buttons[i] = IDialogConstants.NO_LABEL;
                    break;
                }
                case 2: {
                    buttons[i] = IDialogConstants.YES_LABEL;
                }
            }
            ++i;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(new Shell(display), title, null, message, promptType, buttons, defaultResponseIndex);
                retval[0] = dialog.open();
            }
        });
        return promptResponses[retval[0]];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

