/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.text.MessageFormat;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.SharedParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TreeTapsetParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.FuncparamNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.FunctionNodeData;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public final class FunctionParser
extends TreeTapsetParser {
    private static FunctionParser parser = null;
    private TreeNode functions;
    public static final String UNKNOWN_TYPE = "unknown";
    private static final String FUNC_REGEX = "(?s)(?<!\\w)function\\s+{0}(?:\\s*:\\s*(\\w+))?\\s*\\(([^)]+?)?\\)";
    private static final Pattern P_FUNCTION = Pattern.compile("function (?!_)(\\w+) \\(.*?\\)");
    private static final Pattern P_PARAM = Pattern.compile("(\\w+)(?:\\s*:\\s*(\\w+))?");
    private static final Pattern P_ALL_CAP = Pattern.compile("[A-Z_1-9]*");
    private static final Pattern P_RETURN = Pattern.compile("\\sreturn\\W");

    public static FunctionParser getInstance() {
        if (parser != null) {
            return parser;
        }
        parser = new FunctionParser();
        return parser;
    }

    private FunctionParser() {
        super("Function Parser");
    }

    @Override
    public synchronized TreeNode getTree() {
        return this.functions;
    }

    @Override
    public void dispose() {
        this.functions.dispose();
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean cancelled = this.runPass2Functions();
        this.functions.sortTree();
        this.fireUpdateEvent();
        return new Status(!cancelled ? 0 : 8, "org.eclipse.linuxtools.systemtap.ui.ide", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runPass2Functions() {
        String tapsetContents = SharedParser.getInstance().getTapsetContents();
        this.functions = new TreeNode(null, false);
        if (tapsetContents == null) {
            return true;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            block9: {
                Scanner st = new Scanner(tapsetContents);
                try {
                    String filename = null;
                    String scriptText = null;
                    SharedParser sparser = SharedParser.getInstance();
                }
                finally {
                    if (!st.hasNextLine()) break block9;
                }
            }
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void addFunctionFromScript(String functionName, String scriptText, String scriptFilename) {
        String regex = MessageFormat.format(FUNC_REGEX, functionName);
        Matcher mScript = Pattern.compile(regex).matcher(scriptText);
        if (mScript.find()) {
            String functionLine = mScript.group();
            String functionType = mScript.group(1);
            if (functionType == null && this.getNextBlockContents(scriptText, mScript.end(), P_RETURN)) {
                functionType = UNKNOWN_TYPE;
            }
            TreeDefinitionNode function = new TreeDefinitionNode((Object)new FunctionNodeData(functionLine, functionType), functionName, scriptFilename, true);
            this.functions.add((TreeNode)function);
            this.addParamsFromString(mScript.group(2), (TreeNode)function);
        }
    }

    private boolean getNextBlockContents(String scriptText, int start, Pattern p) {
        int bcount = 1;
        int end = start = scriptText.indexOf(123, start) + 1;
        while (end < scriptText.length()) {
            char c = scriptText.charAt(end);
            if (c == '{') {
                ++bcount;
            } else if (c == '}' && --bcount == 0) break;
            ++end;
        }
        return p.matcher(scriptText.substring(start, end)).find();
    }

    private void addParamsFromString(String params, TreeNode parentFunction) {
        if (params != null) {
            Matcher mParams = P_PARAM.matcher(params);
            while (mParams.find()) {
                parentFunction.add(new TreeNode((Object)new FuncparamNodeData(mParams.group(2)), mParams.group(1), false));
            }
        }
    }
}

