/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetParser;

public final class SharedParser
extends TapsetParser {
    static final String TAG_FILE = "# file";
    private static final String[] STAP_OPTIONS = new String[]{"-v", "-p1", "-e"};
    private static final String STAP_DUMMYPROBE = "probe begin{}";
    final Pattern filePattern = Pattern.compile("# file (/.*\\.stp)");
    private String tapsetContents = null;
    private static SharedParser parser = null;

    public static SharedParser getInstance() {
        if (parser != null) {
            return parser;
        }
        parser = new SharedParser();
        return parser;
    }

    private SharedParser() {
        super("Shared Parser");
    }

    synchronized void clearTapsetContents() {
        this.tapsetContents = null;
    }

    synchronized String getTapsetContents() {
        if (this.tapsetContents == null) {
            this.run(null);
        }
        return this.tapsetContents;
    }

    protected IStatus run(IProgressMonitor monitor) {
        int beginIndex;
        String contents = this.runStap(STAP_OPTIONS, STAP_DUMMYPROBE, false);
        if (contents == null) {
            return new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", Messages.SharedParser_NoOutput);
        }
        int firstTagIndex = contents.indexOf(TAG_FILE);
        if (firstTagIndex != -1 && (beginIndex = contents.indexOf(TAG_FILE, firstTagIndex + 1)) != -1) {
            this.tapsetContents = contents.substring(beginIndex);
        }
        return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
    }
}

