/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.PreferenceConstants;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.FunctionParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.ProbeParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.SharedParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TreeSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TreeTapsetParser;
import org.eclipse.linuxtools.man.parser.ManPage;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class TapsetLibrary {
    private static TreeNode functionTree = null;
    private static TreeNode probeTree = null;
    private static FunctionParser functionParser = FunctionParser.getInstance();
    private static ProbeParser probeParser = ProbeParser.getInstance();
    private static final IUpdateListener functionCompletionListener = new ParseCompletionListener(functionParser);
    private static final IUpdateListener probeCompletionListener = new ParseCompletionListener(probeParser);
    private static boolean initialized = false;
    private static HashMap<String, String> pages = new HashMap();
    private static final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("TapsetPreference") || property.equals(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toPrefKey()) || property.equals("RemoteProbes")) {
                TapsetLibrary.runStapParser();
            } else if (property.equals("UseStoredTreePreference")) {
                if (event.getNewValue().equals(false)) {
                    TreeSettings.deleteTrees();
                    TapsetLibrary.runStapParser();
                } else {
                    TreeSettings.setTrees(functionTree, probeTree);
                }
            }
        }
    };
    private static final IPropertyChangeListener credentialChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            TapsetLibrary.runStapParser();
        }
    };
    private static Job cacheFunctionManpages = new Job(Localization.getString("TapsetLibrary.0")){
        private boolean cancelled;

        protected IStatus run(IProgressMonitor monitor) {
            TreeNode nodes = TapsetLibrary.getFunctions();
            int i = 0;
            int n = nodes.getChildCount();
            while (i < n && !this.cancelled) {
                TapsetLibrary.getAndCacheDocumentation("function::" + nodes.getChildAt(i).toString());
                ++i;
            }
            return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
        }

        protected void canceling() {
            this.cancelled = true;
        }
    };
    private static Job cacheProbeManpages = new Job(Localization.getString("TapsetLibrary.1")){
        private boolean cancelled;

        protected IStatus run(IProgressMonitor monitor) {
            TreeNode[] treeNodeArray = TapsetLibrary.getProbeCategoryNodes();
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode nodes = treeNodeArray[n2];
                int i = 0;
                int n3 = nodes.getChildCount();
                while (i < n3 && !this.cancelled) {
                    TapsetLibrary.getAndCacheDocumentation("probe::" + nodes.getChildAt(i).toString());
                    ++i;
                }
                ++n2;
            }
            return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
        }

        protected void canceling() {
            this.cancelled = true;
        }
    };

    public static TreeNode getProbes() {
        return probeTree;
    }

    public static TreeNode getStaticProbes() {
        return probeTree == null ? null : probeTree.getChildByName(Messages.ProbeParser_staticProbes);
    }

    public static TreeNode getProbeAliases() {
        return probeTree == null ? null : probeTree.getChildByName(Messages.ProbeParser_aliasProbes);
    }

    public static TreeNode[] getProbeCategoryNodes() {
        return new TreeNode[]{TapsetLibrary.getStaticProbes(), TapsetLibrary.getProbeAliases()};
    }

    public static TreeNode getFunctions() {
        return functionTree;
    }

    public static synchronized String getAndCacheDocumentation(String element) {
        String doc = pages.get(element);
        if (doc == null) {
            doc = TapsetLibrary.getDocumentation(element);
            pages.put(element, doc);
        }
        return doc;
    }

    public static synchronized String getDocumentation(String element) {
        String documentation = pages.get(element);
        if (documentation == null) {
            String[] sections;
            if (element.matches("probe::.*::.*")) {
                String probe = element.split("::")[1];
                TapsetLibrary.getDocumentation("probe::" + probe);
                return pages.get(element);
            }
            documentation = new ManPage(element).getStrippedTextPage().toString();
            if (!documentation.startsWith("No manual entry for") && element.startsWith("probe::") && (sections = documentation.split("VALUES")).length > 1) {
                String variablesString = sections[1].split("CONTEXT|DESCRIPTION|SystemTap Tapset Reference")[0].trim();
                String[] variables = variablesString.split("\n");
                int i = 0;
                if (!variables[0].equals("None")) {
                    while (i < variables.length) {
                        String variableName = variables[i].trim();
                        StringBuilder variableDocumentation = new StringBuilder();
                        ++i;
                        while (i < variables.length && !variables[i].isEmpty()) {
                            variableDocumentation.append(variables[i].trim());
                            variableDocumentation.append("\n");
                            ++i;
                        }
                        pages.put(String.valueOf(element) + "::" + variableName, variableDocumentation.toString().trim());
                        ++i;
                    }
                }
            }
        }
        return documentation;
    }

    public static synchronized void init() {
        if (!initialized) {
            initialized = true;
            IPreferenceStore preferenceStore = IDEPlugin.getDefault().getPreferenceStore();
            preferenceStore.addPropertyChangeListener(propertyChangeListener);
            ConsoleLogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(credentialChangeListener);
            functionParser.addListener(functionCompletionListener);
            probeParser.addListener(probeCompletionListener);
            if (preferenceStore.getBoolean("UseStoredTreePreference") && TapsetLibrary.isTreeFileCurrent()) {
                TapsetLibrary.readTreeFile();
            } else {
                TapsetLibrary.runStapParser();
            }
        }
    }

    private static void runStapParser() {
        TapsetLibrary.stop();
        TapsetLibrary.clearTrees();
        SharedParser.getInstance().clearTapsetContents();
        functionParser.schedule();
        probeParser.schedule();
    }

    private static void clearTrees() {
        if (functionTree != null) {
            functionTree.dispose();
            functionTree = null;
        }
        if (probeTree != null) {
            probeTree.dispose();
            probeTree = null;
        }
    }

    private static void readTreeFile() {
        functionTree = TreeSettings.getFunctionTree();
        probeTree = TreeSettings.getProbeTree();
        cacheFunctionManpages.schedule();
        cacheProbeManpages.schedule();
    }

    private static boolean isTreeFileCurrent() {
        long treesDate = TreeSettings.getTreeFileDate();
        File f = TapsetLibrary.getTapsetLocation();
        if (f == null || !TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
            return false;
        }
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String[] tapsets = p.getString("TapsetPreference").split(File.pathSeparator);
        if (!tapsets[0].trim().isEmpty()) {
            int i = 0;
            while (i < tapsets.length) {
                f = new File(tapsets[i]);
                if (!f.exists() || f.lastModified() > treesDate || f.canRead() && !TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static File getTapsetLocation() {
        final IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        File f = TapsetLibrary.attemptToGetFileFrom(p.getString(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toPrefKey()));
        if (f != null) {
            return f;
        }
        f = TapsetLibrary.attemptToGetFileFrom(System.getenv(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toEnvKey()));
        if (f != null) {
            return f;
        }
        f = TapsetLibrary.attemptToGetFileFrom("/usr/share/systemtap/tapset");
        if (f != null) {
            return f;
        }
        f = TapsetLibrary.attemptToGetFileFrom("/usr/local/share/systemtap/tapset");
        if (f != null) {
            return f;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InputDialog i = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Localization.getString("TapsetBrowserView.TapsetLocation"), Localization.getString("TapsetBrowserView.WhereDefaultTapset"), null, null);
                i.open();
                String path = i.getValue();
                if (path != null) {
                    p.setValue(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toPrefKey(), i.getValue());
                }
            }
        });
        return null;
    }

    private static File attemptToGetFileFrom(String path) {
        if (path == null) {
            return null;
        }
        String trimmed = path.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        File f = new File(trimmed);
        return f.exists() ? f : null;
    }

    private static boolean checkIsCurrentFolder(long time, File folder) {
        File[] fs = folder.listFiles();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].lastModified() > time) {
                return false;
            }
            if (fs[i].isDirectory() && fs[i].canRead() && !TapsetLibrary.checkIsCurrentFolder(time, fs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForInitialization() {
        while (functionParser.getState() != 0) {
            try {
                FunctionParser functionParser = TapsetLibrary.functionParser;
                synchronized (functionParser) {
                    ((Object)((Object)TapsetLibrary.functionParser)).wait(5000L);
                }
            }
            catch (InterruptedException e) {
                break;
            }
        }
        while (probeParser.getState() != 0) {
            try {
                ProbeParser e = probeParser;
                synchronized (e) {
                    ((Object)((Object)probeParser)).wait(5000L);
                }
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public static void stop() {
        functionParser.cancel();
        cacheFunctionManpages.cancel();
        probeParser.cancel();
        cacheProbeManpages.cancel();
        try {
            functionParser.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            cacheFunctionManpages.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            probeParser.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            cacheProbeManpages.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class ParseCompletionListener
    implements IUpdateListener {
        TreeTapsetParser parser;

        public ParseCompletionListener(TreeTapsetParser parser) {
            this.parser = parser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleUpdateEvent() {
            if (!this.parser.isCancelRequested()) {
                if (((Object)((Object)this.parser)).equals((Object)functionParser)) {
                    functionTree = this.parser.getTree();
                    cacheFunctionManpages.schedule();
                } else {
                    probeTree = this.parser.getTree();
                    cacheProbeManpages.schedule();
                }
                if (IDEPlugin.getDefault().getPreferenceStore().getBoolean("UseStoredTreePreference")) {
                    TreeSettings.setTrees(functionTree, probeTree);
                }
            }
            TreeTapsetParser treeTapsetParser = this.parser;
            synchronized (treeTapsetParser) {
                ((Object)((Object)this.parser)).notifyAll();
            }
        }
    }
}

