/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.StringOutputStream;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.EnvironmentVariablesPreferencePage;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.linuxtools.systemtap.structures.process.SystemtapProcessFactory;
import org.eclipse.linuxtools.systemtap.structures.runnable.StringStreamGobbler;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class TapsetParser
extends Job {
    private static AtomicBoolean displayingError = new AtomicBoolean(false);
    private static AtomicBoolean displayingCredentialDialog = new AtomicBoolean(false);
    private ArrayList<IUpdateListener> listeners = new ArrayList();
    private boolean cancelRequested = false;

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    protected TapsetParser(String jobTitle) {
        super(jobTitle);
        this.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                TapsetParser.this.cancelRequested = false;
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
    }

    protected void canceling() {
        this.cancelRequested = true;
        this.getThread().interrupt();
    }

    public void addListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireUpdateEvent() {
        for (IUpdateListener listener : this.listeners) {
            listener.handleUpdateEvent();
        }
    }

    protected String runStap(String[] options, String probe, boolean getErrors) {
        int i;
        int size;
        String[] args = null;
        String[] tapsets = IDEPlugin.getDefault().getPreferenceStore().getString("TapsetPreference").split(File.pathSeparator);
        boolean noTapsets = tapsets[0].trim().isEmpty();
        boolean noOptions = options[0].trim().isEmpty();
        boolean remote = IDEPlugin.getDefault().getPreferenceStore().getBoolean("RemoteProbes");
        int n = size = probe != null ? 2 : 1;
        if (!noTapsets) {
            size += tapsets.length << 1;
        }
        if (!noOptions) {
            size += options.length;
        }
        args = new String[size];
        args[0] = "stap";
        if (probe != null) {
            String string = args[size - 1] = !remote ? probe : String.valueOf('\'') + probe + '\'';
        }
        if (!noTapsets) {
            i = 0;
            while (i < tapsets.length) {
                args[1 + 2 * i] = "-I";
                args[2 + 2 * i] = tapsets[i];
                ++i;
            }
        }
        if (!noOptions) {
            i = 0;
            int s = noTapsets ? 1 : 1 + tapsets.length * 2;
            while (i < options.length) {
                args[s + i] = options[i];
                ++i;
            }
        }
        try {
            if (!remote) {
                return this.runLocalStap(args, getErrors);
            }
            return this.runRemoteStapAttempt(args, getErrors);
        }
        catch (IOException e) {
            this.displayError(Messages.TapsetParser_ErrorRunningSystemtap, e.getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private String runLocalStap(String[] args, boolean getErrors) throws IOException, InterruptedException {
        Process process = RuntimeProcessFactory.getFactory().exec(args, EnvironmentVariablesPreferencePage.getEnvironmentVariables(), null);
        if (process == null) {
            this.displayError(Messages.TapsetParser_CannotRunStapTitle, Messages.TapsetParser_CannotRunStapMessage);
            return null;
        }
        StringStreamGobbler gobbler = new StringStreamGobbler(process.getInputStream());
        StringStreamGobbler egobbler = null;
        gobbler.start();
        if (getErrors) {
            egobbler = new StringStreamGobbler(process.getErrorStream());
            egobbler.start();
        }
        process.waitFor();
        gobbler.stop();
        if (egobbler == null) {
            return gobbler.getOutput().toString();
        }
        egobbler.stop();
        return egobbler.getOutput().toString();
    }

    private String runRemoteStapAttempt(String[] args, boolean getErrors) {
        int attemptsLeft = 3;
        while (true) {
            try {
                return this.runRemoteStap(args, getErrors);
            }
            catch (JSchException e) {
                if (e.getCause() instanceof ConnectException && --attemptsLeft != 0) continue;
                this.askIfEditCredentials();
                return null;
            }
            break;
        }
    }

    private String runRemoteStap(String[] args, boolean getErrors) throws JSchException {
        int port;
        String password;
        String host;
        StringOutputStream str = new StringOutputStream();
        StringOutputStream strErr = new StringOutputStream();
        IPreferenceStore p = ConsoleLogPlugin.getDefault().getPreferenceStore();
        String user = p.getString("scpuser");
        Channel channel = SystemtapProcessFactory.execRemoteAndWait((String[])args, (OutputStream)str, (OutputStream)strErr, (String)user, (String)(host = p.getString("host")), (String)(password = p.getString("scppassword")), (int)(port = p.getInt("port")), (String[])EnvironmentVariablesPreferencePage.getEnvironmentVariables());
        if (channel == null) {
            this.displayError(Messages.TapsetParser_CannotRunStapTitle, Messages.TapsetParser_CannotRunStapMessage);
        }
        return (!getErrors ? str : strErr).toString();
    }

    private void askIfEditCredentials() {
        if (displayingCredentialDialog.compareAndSet(false, true)) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageBox dialog = new MessageBox(shell, 196);
                    dialog.setText(Messages.TapsetParser_RemoteCredentialErrorTitle);
                    dialog.setMessage(Messages.TapsetParser_RemoteCredentialErrorMessage);
                    if (dialog.open() == 64) {
                        String pageID = "org.eclipse.linuxtools.systemtap.prefs.consoleLog";
                        PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageID, (String[])new String[]{pageID}, null).open();
                    }
                    displayingCredentialDialog.set(false);
                }
            });
        }
    }

    private void displayError(final String title, final String error) {
        if (displayingError.compareAndSet(false, true)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    MessageDialog.openWarning((Shell)window.getShell(), (String)title, (String)error);
                    displayingError.set(false);
                }
            });
        }
    }
}

