/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.BrowserViewAction;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public abstract class BrowserView
extends ViewPart {
    protected TreeViewer viewer;
    protected TreeNode tree;
    protected BrowserViewAction doubleClickAction;
    private CollapseAllHandler collapseHandler;
    protected IUpdateListener viewUpdater = new IUpdateListener(){

        public void handleUpdateEvent() {
            if (BrowserView.this.viewer != null) {
                BrowserView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BrowserView.this.refresh();
                    }
                });
            }
        }
    };

    protected abstract Image getEntryImage(TreeNode var1);

    public void createPartControl(Composite parent) {
        parent.getShell().setCursor(parent.getShell().getDisplay().getSystemCursor(1));
        PatternFilter filter = new PatternFilter();
        FilteredTree filteredTree = new FilteredTree(parent, 770, filter, true);
        this.viewer = filteredTree.getViewer();
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.collapseHandler = new CollapseAllHandler((AbstractTreeViewer)this.getViewer());
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseHandler);
    }

    protected void registerContextMenu(String menuName) {
        Control control = this.viewer.getControl();
        MenuManager manager = new MenuManager(menuName);
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        this.viewer.getControl().setMenu(menu);
        IWorkbenchPartSite partSite = this.getSite();
        partSite.registerContextMenu(manager, (ISelectionProvider)this.viewer);
        partSite.setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.collapseHandler != null) {
            this.collapseHandler.dispose();
            this.collapseHandler = null;
        }
        if (this.viewer != null) {
            if (this.doubleClickAction != null) {
                this.viewer.removeDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
            }
            this.viewer = null;
        }
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
            this.doubleClickAction = null;
        }
    }

    abstract void refresh();

    static class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object par) {
            TreeNode parent = (TreeNode)par;
            Object[] children = new Object[parent.getChildCount()];
            int i = 0;
            while (i < children.length) {
                children[i] = parent.getChildAt(i);
                ++i;
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).getChildCount() > 0;
        }
    }

    protected class ViewLabelProvider
    extends LabelProvider {
        protected ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            return BrowserView.this.getEntryImage((TreeNode)obj);
        }
    }
}

