/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public abstract class Declaration
implements IDeclaration {
    @Override
    public LexicalScope getPath(IDefinitionScope definitionScope, @NonNull String fieldName) {
        LexicalScope parentPath;
        if (definitionScope != null && (parentPath = definitionScope.getScopePath()) != null) {
            LexicalScope myScope = parentPath.getChild(fieldName);
            if (myScope == null) {
                myScope = new LexicalScope(parentPath, fieldName);
            }
            return myScope;
        }
        LexicalScope child = LexicalScope.ROOT.getChild(fieldName);
        if (child != null) {
            return child;
        }
        return new LexicalScope(LexicalScope.ROOT, fieldName);
    }

    protected final void alignRead(BitBuffer input) throws CTFReaderException {
        long mask = this.getAlignment() - 1L;
        long pos = input.position();
        if ((pos & mask) == 0L) {
            return;
        }
        pos = pos + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        input.position(pos);
    }
}

