/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;

public final class VariantDefinition
extends Definition
implements IDefinitionScope {
    private final Definition fDefinition;
    private final String fCurrentField;
    private final String fFieldName;

    public VariantDefinition(@NonNull VariantDeclaration declaration, IDefinitionScope definitionScope, String selectedField, @NonNull String fieldName, Definition fieldValue) {
        super(declaration, definitionScope, fieldName);
        this.fFieldName = fieldName;
        this.fCurrentField = selectedField;
        this.fDefinition = fieldValue;
    }

    @Override
    public VariantDeclaration getDeclaration() {
        return (VariantDeclaration)super.getDeclaration();
    }

    public String getCurrentFieldName() {
        return this.fCurrentField;
    }

    public Definition getCurrentField() {
        return this.fDefinition;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath == null) {
            return null;
        }
        if (lookupPath.equals(this.fFieldName)) {
            return this.fDefinition;
        }
        return this.getDefinitionScope().lookupDefinition(lookupPath);
    }

    public ArrayDefinition lookupArray(String name) {
        Definition def = this.lookupDefinition(name);
        return (ArrayDefinition)(def instanceof ArrayDefinition ? def : null);
    }

    public EnumDefinition lookupEnum(String name) {
        Definition def = this.lookupDefinition(name);
        return (EnumDefinition)(def instanceof EnumDefinition ? def : null);
    }

    public IntegerDefinition lookupInteger(String name) {
        Definition def = this.lookupDefinition(name);
        return (IntegerDefinition)(def instanceof IntegerDefinition ? def : null);
    }

    public SequenceDefinition lookupSequence(String name) {
        Definition def = this.lookupDefinition(name);
        return (SequenceDefinition)(def instanceof SequenceDefinition ? def : null);
    }

    public StringDefinition lookupString(String name) {
        Definition def = this.lookupDefinition(name);
        return (StringDefinition)(def instanceof StringDefinition ? def : null);
    }

    public StructDefinition lookupStruct(String name) {
        Definition def = this.lookupDefinition(name);
        return (StructDefinition)(def instanceof StructDefinition ? def : null);
    }

    public VariantDefinition lookupVariant(String name) {
        Definition def = this.lookupDefinition(name);
        return (VariantDefinition)(def instanceof VariantDefinition ? def : null);
    }

    @Override
    public String toString() {
        return "{ " + this.getCurrentFieldName() + " = " + this.getCurrentField() + " }";
    }
}

