/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInput;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

public class CTFStream {
    private Long fId = null;
    private StructDeclaration fPacketContextDecl = null;
    private StructDeclaration fEventHeaderDecl = null;
    private StructDeclaration fEventContextDecl = null;
    private CTFTrace fTrace = null;
    private Map<Long, IEventDeclaration> fEvents = new HashMap<Long, IEventDeclaration>();
    private final Set<CTFStreamInput> fInputs = new HashSet<CTFStreamInput>();

    public CTFStream(CTFTrace trace) {
        this.fTrace = trace;
    }

    public void setId(long id) {
        this.fId = id;
    }

    public Long getId() {
        return this.fId;
    }

    public boolean isIdSet() {
        return this.fId != null;
    }

    public boolean isEventHeaderSet() {
        return this.fEventHeaderDecl != null;
    }

    public boolean isEventContextSet() {
        return this.fEventContextDecl != null;
    }

    public boolean isPacketContextSet() {
        return this.fPacketContextDecl != null;
    }

    public void setEventHeader(StructDeclaration eventHeader) {
        this.fEventHeaderDecl = eventHeader;
    }

    public void setEventContext(StructDeclaration eventContext) {
        this.fEventContextDecl = eventContext;
    }

    public void setPacketContext(StructDeclaration packetContext) {
        this.fPacketContextDecl = packetContext;
    }

    public StructDeclaration getEventHeaderDecl() {
        return this.fEventHeaderDecl;
    }

    public StructDeclaration getEventContextDecl() {
        return this.fEventContextDecl;
    }

    public StructDeclaration getPacketContextDecl() {
        return this.fPacketContextDecl;
    }

    public Set<CTFStreamInput> getStreamInputs() {
        return this.fInputs;
    }

    public CTFTrace getTrace() {
        return this.fTrace;
    }

    public Map<Long, IEventDeclaration> getEvents() {
        return this.fEvents;
    }

    public void addEvent(IEventDeclaration event) throws ParseException {
        if (this.fEvents.get(null) != null) {
            throw new ParseException("Event without id with multiple events in a stream");
        }
        if (event.getId() == null && this.fEvents.size() != 0) {
            throw new ParseException("Event without id with multiple events in a stream");
        }
        if (this.fEvents.get(event.getId()) != null) {
            throw new ParseException("Event id already exists");
        }
        if (event.getId() == null) {
            this.fEvents.put(-2L, event);
        } else {
            this.fEvents.put(event.getId(), event);
        }
    }

    public void addInput(CTFStreamInput input) {
        this.fInputs.add(input);
    }

    public String toString() {
        return "Stream [id=" + this.fId + ", packetContextDecl=" + this.fPacketContextDecl + ", eventHeaderDecl=" + this.fEventHeaderDecl + ", eventContextDecl=" + this.fEventContextDecl + ", trace=" + this.fTrace + ", events=" + this.fEvents + ", inputs=" + this.fInputs + "]";
    }
}

