/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFResponse;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInput;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInputPacketReader;
import org.eclipse.linuxtools.ctf.core.trace.CTFTraceReader;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class CTFStreamInputReader
implements AutoCloseable {
    private final CTFStreamInput fStreamInput;
    private final CTFStreamInputPacketReader fPacketReader;
    private int fPacketIndex;
    private EventDefinition fCurrentEvent = null;
    private int fId;
    private CTFTraceReader fParent;
    private boolean fLive = false;

    public CTFStreamInputReader(CTFStreamInput streamInput) throws CTFReaderException {
        this.fStreamInput = streamInput;
        this.fPacketReader = new CTFStreamInputPacketReader(this);
        this.fPacketIndex = 0;
        this.goToNextPacket();
    }

    @Override
    public void close() {
        this.fPacketReader.close();
    }

    public EventDefinition getCurrentEvent() {
        return this.fCurrentEvent;
    }

    public ByteOrder getByteOrder() {
        return this.fStreamInput.getStream().getTrace().getByteOrder();
    }

    public int getName() {
        return this.fId;
    }

    public void setName(int name) {
        this.fId = name;
    }

    public int getCPU() {
        return this.fPacketReader.getCPU();
    }

    public String getFilename() {
        return this.fStreamInput.getFilename();
    }

    CTFStreamInput getStreamInput() {
        return this.fStreamInput;
    }

    public Iterable<IEventDeclaration> getEventDeclarations() {
        return ImmutableSet.copyOf(this.fStreamInput.getStream().getEvents().values());
    }

    public void setLive(boolean live) {
        this.fLive = live;
    }

    public boolean isLive() {
        return this.fLive;
    }

    public StructDeclaration getStreamEventContextDecl() {
        return this.getStreamInput().getStream().getEventContextDecl();
    }

    public CTFResponse readNextEvent() throws CTFReaderException {
        StreamInputPacketIndexEntry prevPacket;
        if (!this.fPacketReader.hasMoreEvents() && ((prevPacket = this.fPacketReader.getCurrentPacket()) != null || this.fLive)) {
            this.goToNextPacket();
        }
        if (this.fPacketReader.hasMoreEvents()) {
            this.setCurrentEvent(this.fPacketReader.readNextEvent());
            return CTFResponse.OK;
        }
        this.setCurrentEvent(null);
        return this.fLive ? CTFResponse.WAIT : CTFResponse.FINISH;
    }

    private void goToNextPacket() throws CTFReaderException {
        ++this.fPacketIndex;
        if (this.getPacketSize() >= this.fPacketIndex + 1) {
            this.fPacketReader.setCurrentPacket(this.getPacket());
        } else if (this.fStreamInput.addPacketHeaderIndex()) {
            this.fPacketIndex = this.getPacketSize() - 1;
            this.fPacketReader.setCurrentPacket(this.getPacket());
        } else {
            this.fPacketReader.setCurrentPacket(null);
        }
    }

    private int getPacketSize() {
        return this.fStreamInput.getIndex().getEntries().size();
    }

    public long seek(long timestamp) throws CTFReaderException {
        long offset = 0L;
        this.gotoPacket(timestamp);
        while (this.fPacketReader.getCurrentPacket() != null && this.fPacketReader.getCurrentPacket().getTimestampEnd() < timestamp) {
            try {
                this.fStreamInput.addPacketHeaderIndex();
                this.goToNextPacket();
            }
            catch (CTFReaderException cTFReaderException) {
                // empty catch block
            }
        }
        if (this.fPacketReader.getCurrentPacket() == null) {
            this.gotoPacket(timestamp);
        }
        this.readNextEvent();
        boolean done = this.getCurrentEvent() == null;
        while (!done && this.getCurrentEvent().getTimestamp() < timestamp) {
            this.readNextEvent();
            done = this.getCurrentEvent() == null;
            ++offset;
        }
        return offset;
    }

    private void gotoPacket(long timestamp) throws CTFReaderException {
        this.fPacketIndex = this.fStreamInput.getIndex().search(timestamp).previousIndex();
        this.goToNextPacket();
    }

    public void goToLastEvent() throws CTFReaderException {
        int len = this.fStreamInput.getIndex().getEntries().size();
        this.seek(0L);
        if (len == 0 || !this.fPacketReader.hasMoreEvents()) {
            return;
        }
        int pos = len - 1;
        while (pos > 0) {
            this.fPacketIndex = pos--;
            this.fPacketReader.setCurrentPacket(this.getPacket());
            if (this.fPacketReader.hasMoreEvents()) break;
        }
        EventDefinition prevEvent = null;
        while (this.fCurrentEvent != null) {
            prevEvent = this.fCurrentEvent;
            this.readNextEvent();
        }
        this.setCurrentEvent(prevEvent);
    }

    public CTFTraceReader getParent() {
        return this.fParent;
    }

    public void setParent(CTFTraceReader parent) {
        this.fParent = parent;
    }

    public void setCurrentEvent(EventDefinition currentEvent) {
        this.fCurrentEvent = currentEvent;
    }

    private int getPacketIndex() {
        return this.fPacketIndex;
    }

    private StreamInputPacketIndexEntry getPacket() {
        return this.fStreamInput.getIndex().getEntries().get(this.getPacketIndex());
    }

    public CTFStreamInputPacketReader getPacketReader() {
        return this.fPacketReader;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fId;
        result = 31 * result + (this.fStreamInput == null ? 0 : this.fStreamInput.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFStreamInputReader)) {
            return false;
        }
        CTFStreamInputReader other = (CTFStreamInputReader)obj;
        if (this.fId != other.fId) {
            return false;
        }
        return !(this.fStreamInput == null ? other.fStreamInput != null : !this.fStreamInput.equals(other.fStreamInput));
    }

    public String toString() {
        return String.valueOf(this.fId + 32) + this.fCurrentEvent.toString();
    }
}

