/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.configuration;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpUnitMask;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchPlugin;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.OprofileCounter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractEventConfigTab
extends AbstractLaunchConfigurationTab {
    protected Button defaultEventCheck;
    protected OprofileCounter[] counters = null;
    protected CounterSubTab[] counterSubTabs;
    private Composite top;

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        this.top = top;
    }

    private void createCounterTabs(Composite top) {
        this.counters = this.getOprofileCounters(null);
        TabItem[] counterTabs = new TabItem[this.counters.length];
        this.counterSubTabs = new CounterSubTab[1];
        TabFolder tabFolder = new TabFolder(top, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        if (i < this.counters.length) {
            CounterSubTab currentTab;
            Composite c = new Composite((Composite)tabFolder, 0);
            this.counterSubTabs[i] = currentTab = new CounterSubTab(c, this.counters[i]);
            counterTabs[i] = new TabItem(tabFolder, 0);
            counterTabs[i].setControl((Control)c);
            counterTabs[i].setText(OprofileLaunchMessages.getString("tab.event.counterTab.counterText"));
        }
        this.getTabFolderComposite();
    }

    private Composite getTabFolderComposite() {
        if (this.counterSubTabs.length == 0 || this.counterSubTabs[0] == null) {
            return null;
        }
        Composite c = this.counterSubTabs[0].getTabTopContainer();
        while (c != null && !(c instanceof TabFolder)) {
            c = c.getParent();
        }
        return c.getParent();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        int n;
        IProject previousProject = this.getOprofileProject();
        IProject project = this.getProject(config);
        this.setOprofileProject(project);
        this.updateOprofileInfo();
        String previousHost = null;
        if (previousProject != null && previousProject.getLocationURI() != null) {
            previousHost = previousProject.getLocationURI().getHost();
        }
        String host = project != null ? project.getLocationURI().getHost() : null;
        if (previousProject == null || previousHost != host || host == null || this.counters == null) {
            Control[] children;
            Control[] controlArray = children = this.top.getChildren();
            int n2 = children.length;
            n = 0;
            while (n < n2) {
                Control control = controlArray[n];
                control.dispose();
                ++n;
            }
            if (this.getOprofileTimerMode()) {
                Label timerModeLabel = new Label(this.top, 16384);
                timerModeLabel.setText(OprofileLaunchMessages.getString("tab.event.timermode.no.options"));
            } else {
                this.createVerticalSpacer(this.top, 1);
                this.defaultEventCheck = new Button(this.top, 32);
                this.defaultEventCheck.setText(OprofileLaunchMessages.getString("tab.event.defaultevent.button.text"));
                this.defaultEventCheck.setLayoutData((Object)new GridData());
                this.defaultEventCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        AbstractEventConfigTab.this.handleEnabledToggle();
                    }
                });
                this.createVerticalSpacer(this.top, 1);
                this.createCounterTabs(this.top);
            }
        }
        if (!this.getOprofileTimerMode()) {
            int i = 0;
            while (i < this.counters.length) {
                this.counters[i].loadConfiguration(config);
                ++i;
            }
            CounterSubTab[] counterSubTabArray = this.counterSubTabs;
            n = this.counterSubTabs.length;
            int n3 = 0;
            while (n3 < n) {
                CounterSubTab tab = counterSubTabArray[n3];
                tab.initializeTab(config);
                tab.createEventsFilter();
                ++n3;
            }
            try {
                boolean enabledState = config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", true);
                this.defaultEventCheck.setSelection(enabledState);
                this.setEnabledState(!enabledState);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        IProject project = this.getProject(config);
        this.setOprofileProject(project);
        if (this.getOprofileTimerMode() || this.counterSubTabs == null) {
            return true;
        }
        return this.validateEvents(config);
    }

    private boolean validateEvents(ILaunchConfiguration config) {
        int numEnabledEvents = 0;
        boolean valid = true;
        try {
            if (config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", false)) {
                numEnabledEvents = 1;
            } else {
                OprofileCounter[] counters = new OprofileCounter[this.getNumberOfOprofileCounters()];
                int i = 0;
                while (i < counters.length) {
                    counters[i] = this.getOprofileCounter(i);
                    counters[i].loadConfiguration(config);
                    CounterSubTab[] counterSubTabArray = this.counterSubTabs;
                    int n = this.counterSubTabs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int count;
                        CounterSubTab counterSubTab = counterSubTabArray[n2];
                        int nr = counterSubTab.counter.getNumber();
                        if (counterSubTab.enabledCheck.getSelection() && config.getAttribute(OprofileLaunchPlugin.attrNumberOfEvents(nr), 0) == 0) {
                            valid = false;
                        }
                        if ((count = counterSubTab.selectedEventList.getList().getItemCount()) == 0) {
                            valid = false;
                        }
                        if ("opcontrol".equals(Oprofile.OprofileProject.getProfilingBinary()) && count > counters.length) {
                            Object[] args = new Object[]{counters.length};
                            this.setErrorMessage(MessageFormat.format(OprofileLaunchMessages.getString("tab.event.opcontrol.validation.msg"), args));
                            valid = false;
                        }
                        ++n2;
                    }
                    if (counters[i].getEnabled()) {
                        ++numEnabledEvents;
                        counterSubTabArray = counters[i].getEvents();
                        n = counterSubTabArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            CounterSubTab event = counterSubTabArray[n2];
                            if (event == null) {
                                valid = false;
                                break;
                            }
                            int min = event.getMinCount();
                            if (counters[i].getCount() < min) {
                                Object[] args = new Object[]{min};
                                this.setErrorMessage(MessageFormat.format(OprofileLaunchMessages.getString("tab.event.counterSettings.count.too-small"), args));
                                valid = false;
                                break;
                            }
                            if (!this.checkEventSetupValidity(counters[i].getNumber(), event.getText(), event.getUnitMask().getMaskValue())) {
                                Object[] args = new Object[]{event.getText()};
                                this.setErrorMessage(MessageFormat.format(OprofileLaunchMessages.getString("tab.event.validation.msg"), args));
                                valid = false;
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return numEnabledEvents > 0 && valid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getOprofileTimerMode() || this.counterSubTabs == null) {
            config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", true);
        } else {
            config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", this.defaultEventCheck.getSelection());
            CounterSubTab[] counterSubTabArray = this.counterSubTabs;
            int n = this.counterSubTabs.length;
            int n2 = 0;
            while (n2 < n) {
                CounterSubTab cst = counterSubTabArray[n2];
                cst.performApply(config);
                ++n2;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        boolean useDefault = true;
        IProject project = this.getProject((ILaunchConfiguration)config);
        this.setOprofileProject(project);
        this.counters = this.getOprofileCounters((ILaunchConfiguration)config);
        int i = 0;
        while (i < this.counters.length) {
            this.counters[i].saveConfiguration(config);
            if (this.counters[i].getEnabled()) {
                useDefault = false;
            }
            ++i;
        }
        config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", useDefault);
    }

    public String getName() {
        return OprofileLaunchMessages.getString("tab.event.name");
    }

    public Image getImage() {
        return OprofileLaunchPlugin.getImageDescriptor("icons/event_tab.gif").createImage();
    }

    private void handleEnabledToggle() {
        this.setEnabledState(!this.defaultEventCheck.getSelection());
        this.updateLaunchConfigurationDialog();
    }

    private void setEnabledState(boolean state) {
        CounterSubTab[] counterSubTabArray = this.counterSubTabs;
        int n = this.counterSubTabs.length;
        int n2 = 0;
        while (n2 < n) {
            CounterSubTab cst = counterSubTabArray[n2];
            cst.setEnabledState(state);
            ++n2;
        }
    }

    protected abstract boolean checkEventSetupValidity(int var1, String var2, int var3);

    private IProject getProject(ILaunchConfiguration config) {
        String name = null;
        try {
            name = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException e) {
            return null;
        }
        if (name.isEmpty()) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public abstract OprofileCounter getOprofileCounter(int var1);

    protected abstract OprofileCounter[] getOprofileCounters(ILaunchConfiguration var1);

    protected abstract int getNumberOfOprofileCounters();

    protected abstract boolean getOprofileTimerMode();

    protected abstract IProject getOprofileProject();

    protected abstract void setOprofileProject(IProject var1);

    protected abstract void updateOprofileInfo();

    protected class CounterSubTab {
        private Button profileKernelCheck;
        private Button profileUserCheck;
        private Label countTextLabel;
        private Text countText;
        private Label eventDescLabel;
        private Text eventDescText;
        private UnitMaskViewer unitMaskViewer;
        private Text eventFilterText;
        private OprofileCounter counter;
        private ScrolledComposite scrolledTop;
        protected Composite tabTopContainer;
        protected Button enabledCheck;
        protected ListViewer eventList;
        protected Button add;
        protected Button addAll;
        protected Button remove;
        protected Button removeAll;
        protected Button customizeBtn;
        protected ListViewer selectedEventList;
        protected ScrolledComposite unitmaskScrollComposite;
        protected Composite unitMaskSubComposite;
        private static final int ADD = 1;
        private static final int ADD_ALL = 2;
        private static final int REMOVE = 3;
        private static final int REMOVE_ALL = 4;
        private static final int CUSTOMIZE = 5;
        private List<OpEvent> sourceList = new ArrayList<OpEvent>(0);
        private List<OpEvent> targetList = new ArrayList<OpEvent>(0);

        public Composite getTabTopContainer() {
            return this.tabTopContainer;
        }

        public void setTabTopContainer(Composite tabTopContainer) {
            this.tabTopContainer = tabTopContainer;
        }

        public CounterSubTab(Composite parent, OprofileCounter counter) {
            this.counter = counter;
            parent.setLayout((Layout)new GridLayout());
            ScrolledComposite scrolledContainer = new ScrolledComposite(parent, 768);
            scrolledContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            scrolledContainer.setLayout((Layout)layout);
            scrolledContainer.setExpandHorizontal(true);
            scrolledContainer.setExpandVertical(true);
            Composite tabTopContainer = new Composite((Composite)scrolledContainer, 0);
            scrolledContainer.setContent((Control)tabTopContainer);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            tabTopContainer.setLayout((Layout)layout);
            tabTopContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite topCellComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            topCellComp.setLayout((Layout)layout);
            topCellComp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            this.createTopCell(topCellComp);
            AbstractEventConfigTab.this.createVerticalSpacer(tabTopContainer, 2);
            Composite eventListComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            eventListComp.setLayout((Layout)layout);
            eventListComp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createLeftCell(eventListComp);
            this.scrolledTop = scrolledContainer;
            this.tabTopContainer = tabTopContainer;
            this.resizeScrollContainer();
        }

        private void createTopCell(Composite parent) {
            this.enabledCheck = new Button(parent, 32);
            this.enabledCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.enabled.button.text"));
            this.enabledCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this.counter.setEnabled(CounterSubTab.this.enabledCheck.getSelection());
                    CounterSubTab.this.internalSetEnabledState(CounterSubTab.this.counter.getEnabled());
                    AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.enabledCheck.setEnabled(false);
            this.eventDescLabel = new Label(parent, 0);
            this.eventDescLabel.setText(OprofileLaunchMessages.getString("tab.event.eventDescription.label.text"));
            this.eventDescLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.eventDescText = new Text(parent, 2060);
            this.eventDescText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        private void createLeftCell(Composite parent) {
            this.eventFilterText = new Text(parent, 2436);
            this.eventFilterText.setMessage(OprofileLaunchMessages.getString("tab.event.eventfilter.message"));
            GridData eventFilterLayout = new GridData();
            eventFilterLayout.horizontalAlignment = 4;
            eventFilterLayout.grabExcessHorizontalSpace = true;
            this.eventFilterText.setLayoutData((Object)eventFilterLayout);
            this.eventFilterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CounterSubTab.this.eventList.refresh(false);
                }
            });
            this.createRightCell(parent);
            int options = 2816;
            options = Oprofile.OprofileProject.getProfilingBinary().equals("operf") ? (options |= 2) : (options |= 4);
            this.eventList = new ListViewer(parent, options);
            GridData gdata = new GridData(4, 4, true, true);
            gdata.verticalSpan = 5;
            this.eventList.getList().setLayoutData((Object)gdata);
            this.eventList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    OpEvent e = (OpEvent)element;
                    return e.getText();
                }

                public Image getImage(Object element) {
                    return null;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }
            });
            this.eventList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    List list = (List)inputElement;
                    return list.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                }
            });
            ListviewerSorter sorter = new ListviewerSorter();
            this.eventList.setSorter((ViewerSorter)sorter);
            this.sourceList.addAll(Arrays.asList(this.counter.getValidEvents()));
            this.eventList.setInput(this.sourceList);
            this.eventList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent sce) {
                    CounterSubTab.this.handleEventListSelectionChange();
                }
            });
            HandleButtonClick listener = new HandleButtonClick();
            this.add = new Button(parent, 8);
            this.add.setLayoutData((Object)new GridData(4, 4, true, false));
            this.add.setText(OprofileLaunchMessages.getString("tab.event.addevent.button.text"));
            this.add.setData((Object)1);
            this.add.addListener(13, (Listener)listener);
            this.selectedEventList = new ListViewer(parent, options);
            this.selectedEventList.getList().setLayoutData((Object)gdata);
            this.selectedEventList.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public String getText(Object element) {
                    OpEvent e = (OpEvent)element;
                    return e.getText();
                }

                public Image getImage(Object element) {
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.selectedEventList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    List list = (List)inputElement;
                    return list.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                }
            });
            sorter = new ListviewerSorter();
            this.selectedEventList.setSorter((ViewerSorter)sorter);
            if (this.counter.getEvents().length != 0 && this.counter.getEvents()[0] != null) {
                this.targetList.addAll(Arrays.asList(this.counter.getEvents()));
            }
            this.selectedEventList.setInput(this.targetList);
            this.selectedEventList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent sce) {
                    CounterSubTab.this.handleListSelection(CounterSubTab.this.selectedEventList);
                    CounterSubTab.this.eventList.getList().deselectAll();
                    AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.addAll = new Button(parent, 8);
            this.addAll.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addAll.setText(OprofileLaunchMessages.getString("tab.event.addallevent.button.text"));
            this.addAll.setData((Object)2);
            this.addAll.addListener(13, (Listener)listener);
            this.remove = new Button(parent, 8);
            this.remove.setLayoutData((Object)new GridData(4, 4, true, false));
            this.remove.setText(OprofileLaunchMessages.getString("tab.event.removeevent.button.text"));
            this.remove.setData((Object)3);
            this.remove.addListener(13, (Listener)listener);
            this.removeAll = new Button(parent, 8);
            this.removeAll.setLayoutData((Object)new GridData(4, 4, true, false));
            this.removeAll.setText(OprofileLaunchMessages.getString("tab.event.removeallevent.button.text"));
            this.removeAll.setData((Object)4);
            this.removeAll.addListener(13, (Listener)listener);
            this.customizeBtn = new Button(parent, 8);
            this.customizeBtn.setLayoutData((Object)new GridData(4, 128, true, false));
            this.customizeBtn.setText(OprofileLaunchMessages.getString("tab.event.customizeevent.button.text"));
            this.customizeBtn.addListener(13, (Listener)listener);
            this.customizeBtn.setData((Object)5);
        }

        private void createRightCell(Composite parent) {
            this.profileKernelCheck = new Button(parent, 32);
            this.profileKernelCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.profileKernel.check.text"));
            this.profileKernelCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this.handleProfileKernelToggle();
                }
            });
            this.profileUserCheck = new Button(parent, 32);
            this.profileUserCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.profileUser.check.text"));
            this.profileUserCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this.handleProfileUserToggle();
                }
            });
        }

        private void createEventsFilter() {
            ViewerFilter eventFilter = new ViewerFilter(){

                public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                    Object[] filteredElements = super.filter(viewer, parent, elements);
                    CounterSubTab.this.handleEventListSelectionChange();
                    return filteredElements;
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    String[] filterTerms = CounterSubTab.this.eventFilterText.getText().trim().toLowerCase().split(" ");
                    String eventName = ((OpEvent)element).getText().toLowerCase();
                    String eventDescription = ((OpEvent)element).getTextDescription().toLowerCase();
                    boolean contains = true;
                    String[] stringArray = filterTerms;
                    int n = filterTerms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filterTerm = stringArray[n2];
                        if (contains) {
                            contains = eventName.contains(filterTerm) || eventDescription.contains(filterTerm);
                        }
                        ++n2;
                    }
                    return contains;
                }
            };
            if (this.eventList != null) {
                this.eventList.addFilter(eventFilter);
            }
        }

        public void initializeTab(ILaunchConfiguration config) {
            try {
                AbstractEventConfigTab.this.defaultEventCheck.setSelection(config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", true));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.setEnabledState(false);
            if (config != null) {
                this.counter.loadConfiguration(config);
            }
            boolean enabled = this.counter.getEnabled();
            this.enabledCheck.setSelection(enabled);
            if (this.counter.getEvents().length == 0 || this.counter.getEvents()[0] == null) {
                this.counter.setEvents(new OpEvent[]{this.counter.getValidEvents()[0]});
            }
            this.profileKernelCheck.setSelection(this.counter.getProfileKernel());
            this.profileUserCheck.setSelection(this.counter.getProfileUser());
            this.eventDescText.setText(this.counter.getEvents()[0].getTextDescription());
            ArrayList<OpEvent> tmp = new ArrayList<OpEvent>(Arrays.asList(this.counter.getEvents()));
            this.targetList.addAll(tmp);
            this.selectedEventList.add(tmp.toArray());
            this.selectedEventList.refresh();
            this.selectedEventList.setSelection((ISelection)new StructuredSelection(tmp.toArray()));
            this.sourceList.removeAll(tmp);
            this.eventList.remove(tmp.toArray());
            this.eventList.refresh();
        }

        public void performApply(ILaunchConfigurationWorkingCopy config) {
            this.counter.saveConfiguration(config);
        }

        public void setEnabledState(boolean state) {
            this.enabledCheck.setEnabled(state);
            if (state) {
                this.internalSetEnabledState(this.counter.getEnabled());
            } else {
                this.internalSetEnabledState(false);
            }
        }

        private void internalSetEnabledState(boolean state) {
            this.profileKernelCheck.setEnabled(state);
            this.profileUserCheck.setEnabled(state);
            this.eventDescText.setEnabled(state);
            this.eventList.getList().setEnabled(state);
            this.selectedEventList.getList().setEnabled(state);
            this.eventFilterText.setEnabled(state);
            this.add.setEnabled(state);
            this.addAll.setEnabled(state);
            this.remove.setEnabled(state);
            this.removeAll.setEnabled(state);
            this.customizeBtn.setEnabled(state);
        }

        private void handleEventListSelectionChange() {
            this.handleListSelection(this.eventList);
            int[] indices = this.eventList.getList().getSelectionIndices();
            if (indices.length != 0) {
                this.customizeBtn.setEnabled(true);
                this.selectedEventList.getList().deselectAll();
            }
            AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void handleListSelection(ListViewer eventList) {
            AbstractEventConfigTab.this.setErrorMessage(null);
            int[] indices = eventList.getList().getSelectionIndices();
            if (indices.length != 0) {
                ArrayList<OpEvent> tmp = new ArrayList<OpEvent>();
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    OpEvent event = (OpEvent)eventList.getElementAt(index);
                    tmp.add(event);
                    this.eventDescText.setText(event.getTextDescription());
                    ++n2;
                }
                int min = Integer.MIN_VALUE;
                for (OpEvent ev : tmp) {
                    if (ev.getMinCount() <= min) continue;
                    min = ev.getMinCount();
                }
                if (this.counter.getEvents().length == 0 || this.counter.getEvents()[0] == null) {
                    this.counter.setEvents(new OpEvent[]{this.counter.getValidEvents()[0]});
                }
                if (this.counter.getCount() < min && !AbstractEventConfigTab.this.defaultEventCheck.getSelection()) {
                    AbstractEventConfigTab.this.setErrorMessage(this.getMinCountErrorMessage(min));
                }
            } else {
                this.eventDescText.setText("");
            }
        }

        private void handleProfileUserToggle() {
            this.counter.setProfileUser(this.profileUserCheck.getSelection());
            AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void handleProfileKernelToggle() {
            this.counter.setProfileKernel(this.profileKernelCheck.getSelection());
            AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void handleCountTextModify() {
            String errorMessage = null;
            try {
                try {
                    int count = Integer.parseInt(this.countText.getText());
                    this.counter.setCount(count);
                    int min = Integer.MIN_VALUE;
                    OpEvent[] opEventArray = this.counter.getEvents();
                    int n = opEventArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OpEvent event = opEventArray[n2];
                        if (event != null && event.getMinCount() > min) {
                            min = event.getMinCount();
                        }
                        ++n2;
                    }
                    if (count < min && !AbstractEventConfigTab.this.defaultEventCheck.getSelection()) {
                        errorMessage = this.getMinCountErrorMessage(min);
                    }
                }
                catch (NumberFormatException e) {
                    errorMessage = OprofileLaunchMessages.getString("tab.event.counterSettings.count.invalid");
                    this.counter.setCount(-1);
                    AbstractEventConfigTab.this.setErrorMessage(errorMessage);
                    AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
                }
            }
            finally {
                AbstractEventConfigTab.this.setErrorMessage(errorMessage);
                AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
            }
        }

        private String getMinCountErrorMessage(int min) {
            String msg = OprofileLaunchMessages.getString("tab.event.counterSettings.count.too-small");
            Object[] args = new Object[]{min};
            return MessageFormat.format(msg, args);
        }

        private void resizeScrollContainer() {
            this.scrolledTop.setMinSize(this.tabTopContainer.computeSize(-1, -1));
        }

        private void createUnitMaskComponents(Composite parent) {
            this.countTextLabel = new Label(parent, 0);
            this.countTextLabel.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.count.label.text"));
            this.countText = new Text(parent, 2052);
            this.countText.setText(Integer.toString(this.counter.getCount()));
            this.countText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.countText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent me) {
                    CounterSubTab.this.handleCountTextModify();
                }
            });
            Composite unitMaskComp = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            unitMaskComp.setLayout((Layout)layout);
            unitMaskComp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.unitMaskViewer = new UnitMaskViewer(unitMaskComp);
        }

        private void resizeUnitMaskContainer() {
            this.unitmaskScrollComposite.setMinSize(this.unitMaskSubComposite.computeSize(-1, -1));
        }

        protected class HandleButtonClick
        implements Listener {
            protected HandleButtonClick() {
            }

            public void handleEvent(Event event) {
                int btn_value = (Integer)event.widget.getData();
                switch (btn_value) {
                    case 1: {
                        this.addButtonClicked();
                        AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
                        break;
                    }
                    case 2: {
                        this.addAllButtonClicked();
                        AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
                        break;
                    }
                    case 3: {
                        this.removeButtonClicked();
                        AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
                        break;
                    }
                    case 4: {
                        this.removeAllButtonClicked();
                        AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
                        break;
                    }
                    case 5: {
                        this.customizeButtonClicked();
                        break;
                    }
                }
            }

            private void addButtonClicked() {
                int[] indices = CounterSubTab.this.eventList.getList().getSelectionIndices();
                if (indices.length != 0) {
                    ArrayList<OpEvent> tmp = new ArrayList<OpEvent>();
                    int[] nArray = indices;
                    int n = indices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        OpEvent event = (OpEvent)CounterSubTab.this.eventList.getElementAt(index);
                        tmp.add(event);
                        ++n2;
                    }
                    CounterSubTab.this.targetList.addAll(tmp);
                    CounterSubTab.this.selectedEventList.add(tmp.toArray());
                    CounterSubTab.this.sourceList.removeAll(tmp);
                    CounterSubTab.this.eventList.remove(tmp.toArray());
                    int count = CounterSubTab.this.selectedEventList.getList().getItemCount();
                    tmp = new ArrayList();
                    int i = 0;
                    while (i < count) {
                        OpEvent event = (OpEvent)CounterSubTab.this.selectedEventList.getElementAt(i);
                        tmp.add(event);
                        ++i;
                    }
                    if (!tmp.isEmpty()) {
                        CounterSubTab.this.counter.setEvents(tmp.toArray(new OpEvent[0]));
                    }
                    CounterSubTab.this.eventList.refresh();
                    CounterSubTab.this.selectedEventList.refresh();
                }
            }

            private void addAllButtonClicked() {
                OpEvent event;
                int count = CounterSubTab.this.eventList.getList().getItemCount();
                ArrayList<OpEvent> tmp = new ArrayList<OpEvent>();
                int i = 0;
                while (i < count) {
                    event = (OpEvent)CounterSubTab.this.eventList.getElementAt(i);
                    tmp.add(event);
                    ++i;
                }
                CounterSubTab.this.targetList.addAll(tmp);
                CounterSubTab.this.selectedEventList.add(tmp.toArray());
                CounterSubTab.this.eventList.remove(tmp.toArray());
                CounterSubTab.this.sourceList.removeAll(tmp);
                count = CounterSubTab.this.selectedEventList.getList().getItemCount();
                tmp = new ArrayList();
                i = 0;
                while (i < count) {
                    event = (OpEvent)CounterSubTab.this.selectedEventList.getElementAt(i);
                    tmp.add(event);
                    ++i;
                }
                if (!tmp.isEmpty()) {
                    CounterSubTab.this.counter.setEvents(tmp.toArray(new OpEvent[0]));
                }
                CounterSubTab.this.eventList.refresh();
                CounterSubTab.this.selectedEventList.refresh();
            }

            private void removeButtonClicked() {
                int[] indices = CounterSubTab.this.selectedEventList.getList().getSelectionIndices();
                if (indices.length != 0) {
                    ArrayList<OpEvent> tmp = new ArrayList<OpEvent>();
                    int[] nArray = indices;
                    int n = indices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        OpEvent event = (OpEvent)CounterSubTab.this.selectedEventList.getElementAt(index);
                        tmp.add(event);
                        ++n2;
                    }
                    CounterSubTab.this.sourceList.addAll(tmp);
                    CounterSubTab.this.eventList.add(tmp.toArray());
                    CounterSubTab.this.targetList.removeAll(tmp);
                    CounterSubTab.this.selectedEventList.remove(tmp.toArray());
                    int count = CounterSubTab.this.selectedEventList.getList().getItemCount();
                    tmp = new ArrayList();
                    int i = 0;
                    while (i < count) {
                        OpEvent event = (OpEvent)CounterSubTab.this.selectedEventList.getElementAt(i);
                        tmp.add(event);
                        ++i;
                    }
                    if (!tmp.isEmpty()) {
                        CounterSubTab.this.counter.setEvents(tmp.toArray(new OpEvent[0]));
                    } else {
                        CounterSubTab.this.counter.setEvents(new OpEvent[]{CounterSubTab.this.counter.getValidEvents()[0]});
                    }
                    CounterSubTab.this.eventList.refresh();
                    CounterSubTab.this.selectedEventList.refresh();
                }
            }

            private void removeAllButtonClicked() {
                int count = CounterSubTab.this.selectedEventList.getList().getItemCount();
                ArrayList<OpEvent> tmp = new ArrayList<OpEvent>();
                int i = 0;
                while (i < count) {
                    OpEvent event = (OpEvent)CounterSubTab.this.selectedEventList.getElementAt(i);
                    tmp.add(event);
                    ++i;
                }
                if (!tmp.isEmpty()) {
                    CounterSubTab.this.sourceList.addAll(tmp);
                    CounterSubTab.this.eventList.add(tmp.toArray());
                    CounterSubTab.this.selectedEventList.remove(tmp.toArray());
                    CounterSubTab.this.targetList.removeAll(tmp);
                }
                CounterSubTab.this.counter.setEvents(new OpEvent[]{CounterSubTab.this.counter.getValidEvents()[0]});
                CounterSubTab.this.eventList.refresh();
                CounterSubTab.this.selectedEventList.refresh();
            }

            private void customizeButtonClicked() {
                UnitMaskDialog d = null;
                if (CounterSubTab.this.eventList.getList().getSelectionIndex() != -1) {
                    d = new UnitMaskDialog(Display.getCurrent().getActiveShell(), (OpEvent)CounterSubTab.this.eventList.getElementAt(CounterSubTab.this.eventList.getList().getSelectionIndex()));
                } else if (CounterSubTab.this.selectedEventList.getList().getSelectionIndex() != -1) {
                    d = new UnitMaskDialog(Display.getCurrent().getActiveShell(), (OpEvent)CounterSubTab.this.selectedEventList.getElementAt(CounterSubTab.this.selectedEventList.getList().getSelectionIndex()));
                }
                if (d != null) {
                    d.open();
                }
            }
        }

        protected class UnitMaskDialog
        extends Dialog {
            private OpEvent event;

            public UnitMaskDialog(IShellProvider parentShell) {
                super(parentShell);
            }

            public UnitMaskDialog(Shell parentShell, OpEvent event) {
                super(parentShell);
                this.event = event;
            }

            protected Control createDialogArea(Composite parent) {
                Composite child = (Composite)super.createDialogArea(parent);
                ScrolledComposite scrolledContainer = new ScrolledComposite(child, 768);
                scrolledContainer.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                scrolledContainer.setLayout((Layout)layout);
                scrolledContainer.setExpandHorizontal(true);
                scrolledContainer.setExpandVertical(true);
                Composite unitMaskSubComposite = new Composite((Composite)scrolledContainer, 0);
                unitMaskSubComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                layout = new GridLayout();
                layout.numColumns = 2;
                unitMaskSubComposite.setLayout((Layout)layout);
                CounterSubTab.this.createUnitMaskComponents(unitMaskSubComposite);
                scrolledContainer.setContent((Control)unitMaskSubComposite);
                CounterSubTab.this.unitmaskScrollComposite = scrolledContainer;
                CounterSubTab.this.unitMaskSubComposite = unitMaskSubComposite;
                CounterSubTab.this.unitMaskViewer.displayEvent(this.event);
                return child;
            }

            protected boolean isResizable() {
                return true;
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(this.event.getText());
                newShell.setSize(400, 400);
            }
        }

        protected class UnitMaskViewer {
            private Label unitMaskLabel;
            private Composite top;
            private Composite maskListComp;
            private Button[] unitMaskButtons;

            public UnitMaskViewer(Composite parent) {
                this.unitMaskLabel = new Label(parent, 0);
                this.unitMaskLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                this.unitMaskLabel.setText(OprofileLaunchMessages.getString("unitmaskViewer.label.text"));
                this.unitMaskLabel.setVisible(true);
                Composite top = new Composite(parent, 0);
                top.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                top.setLayout((Layout)layout);
                this.top = top;
                this.maskListComp = null;
                this.unitMaskButtons = null;
            }

            private void handleToggle(Button maskButton, int index) {
                OpUnitMask mask = CounterSubTab.this.counter.getUnitMask();
                if (mask != null) {
                    if (maskButton.getSelection()) {
                        mask.setMaskFromIndex(index);
                    } else {
                        mask.unSetMaskFromIndex(index);
                    }
                }
                AbstractEventConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void displayEvent(OpEvent oe) {
                if (this.maskListComp != null) {
                    this.maskListComp.dispose();
                }
                if (oe == null) {
                    return;
                }
                OpUnitMask mask = oe.getUnitMask();
                int totalMasks = mask.getNumMasks();
                Composite newMaskComp = new Composite(this.top, 0);
                newMaskComp.setLayout((Layout)new GridLayout());
                newMaskComp.setLayoutData((Object)new GridData(16384, 4, false, true));
                this.maskListComp = newMaskComp;
                mask.setDefaultMaskValue();
                ArrayList<Button> maskButtons = new ArrayList<Button>();
                int i = 0;
                while (i < totalMasks) {
                    Button maskButton;
                    if (mask.getType() == -1) {
                        OprofileCorePlugin.showErrorDialog((String)"opxmlParse", null);
                        return;
                    }
                    if (mask.getType() == 1) {
                        maskButton = new Button(newMaskComp, 16);
                        maskButton.setEnabled(false);
                        maskButton.setText(mask.getText(i));
                        maskButton.setSelection(true);
                    } else {
                        final int maskButtonIndex = i;
                        boolean selected = mask.isMaskSetFromIndex(maskButtonIndex);
                        int buttonType = mask.getType() == 2 ? 16 : 32;
                        maskButton = new Button(newMaskComp, buttonType);
                        maskButton.setEnabled(true);
                        maskButton.setText(mask.getText(i));
                        maskButton.setSelection(selected);
                        maskButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent se) {
                                UnitMaskViewer.this.handleToggle((Button)se.getSource(), maskButtonIndex);
                            }
                        });
                        maskButtons.add(maskButton);
                    }
                    ++i;
                }
                this.unitMaskButtons = new Button[maskButtons.size()];
                maskButtons.toArray(this.unitMaskButtons);
                CounterSubTab.this.resizeUnitMaskContainer();
            }

            public void setEnabled(boolean enabled) {
                if (this.unitMaskButtons != null) {
                    Button[] buttonArray = this.unitMaskButtons;
                    int n = this.unitMaskButtons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button b = buttonArray[n2];
                        if (!b.isDisposed()) {
                            b.setEnabled(enabled);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    protected class ListviewerSorter
    extends ViewerSorter {
        protected ListviewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            OpEvent op1 = (OpEvent)e1;
            OpEvent op2 = (OpEvent)e2;
            String op1txt = op1.getText();
            String op2txt = op2.getText();
            if (op1txt != null && op2txt != null && op1txt.trim().length() != 0 && op2txt.trim().length() != 0) {
                return this.collator.compare(op1txt, op2txt);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

