/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.statesystem.core.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.HTNode;

class HT_IO {
    private final HTConfig fConfig;
    private final FileInputStream fis;
    private final FileOutputStream fos;
    private final FileChannel fcIn;
    private final FileChannel fcOut;
    private final int CACHE_SIZE = 256;
    private final HTNode[] fNodeCache = new HTNode[256];

    public HT_IO(HTConfig config, boolean newFile) throws IOException {
        this.fConfig = config;
        File historyTreeFile = config.getStateFile();
        if (newFile) {
            boolean success1 = true;
            if (historyTreeFile.exists()) {
                success1 = historyTreeFile.delete();
            }
            boolean success2 = historyTreeFile.createNewFile();
            if (!success1 || !success2) {
                throw new IOException("Cannot create new file at " + historyTreeFile.getName());
            }
            this.fis = new FileInputStream(historyTreeFile);
            this.fos = new FileOutputStream(historyTreeFile, false);
        } else {
            this.fis = new FileInputStream(historyTreeFile);
            this.fos = new FileOutputStream(historyTreeFile, true);
        }
        this.fcIn = this.fis.getChannel();
        this.fcOut = this.fos.getChannel();
    }

    public synchronized HTNode readNode(int seqNumber) throws ClosedChannelException {
        int offset = seqNumber & 0xFF;
        HTNode readNode = this.fNodeCache[offset];
        if (readNode != null && readNode.getSequenceNumber() == seqNumber) {
            return readNode;
        }
        try {
            this.seekFCToNodePos(this.fcIn, seqNumber);
            this.fNodeCache[offset] = readNode = HTNode.readNode(this.fConfig, this.fcIn);
            return readNode;
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void writeNode(HTNode node) {
        try {
            int seqNumber = node.getSequenceNumber();
            int offset = seqNumber & 0xFF;
            this.fNodeCache[offset] = node;
            this.seekFCToNodePos(this.fcOut, seqNumber);
            node.writeSelf(this.fcOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileChannel getFcOut() {
        return this.fcOut;
    }

    public FileInputStream supplyATReader(int nodeOffset) {
        try {
            this.seekFCToNodePos(this.fcIn, nodeOffset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.fis;
    }

    public synchronized void closeFile() {
        try {
            this.fis.close();
            this.fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void deleteFile() {
        this.closeFile();
        File historyTreeFile = this.fConfig.getStateFile();
        historyTreeFile.delete();
    }

    private void seekFCToNodePos(FileChannel fc, int seqNumber) throws IOException {
        fc.position(4096L + (long)seqNumber * (long)this.fConfig.getBlockSize());
    }
}

