/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.UserInputString;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class TileLoopRefactoring
extends FortranEditorRefactoring {
    private ASTProperLoopConstructNode doLoop;
    private ASTProperLoopConstructNode secondDoLoop;
    private String newFirstIndexVar;
    private String newSecondIndexVar;
    private int tilingSize;
    private int tilingOffset;
    private boolean hasLoopDependency;

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.doLoop = TileLoopRefactoring.getLoopNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (this.doLoop == null) {
            this.fail(Messages.ReverseLoopRefactoring_SelectDoLoop);
        }
        this.secondDoLoop = this.findSecondDoLoop(this.doLoop);
        if (this.secondDoLoop == null) {
            this.fail(Messages.ReverseLoopRefactoring_SelectDoLoop);
        }
        if (this.findNumberOfLoops() != 1) {
            this.fail(Messages.TileLoopRefactoring_SelectLoopWithOnlyOneNestedLoop);
        }
        this.newFirstIndexVar = this.findNewIndexVariableName(this.doLoop, this.doLoop.getIndexVariable().getText());
        this.newSecondIndexVar = this.findNewIndexVariableName(this.secondDoLoop, this.secondDoLoop.getIndexVariable().getText());
        if (this.newFirstIndexVar == null || this.newSecondIndexVar == null) {
            this.fail(Messages.TileLoopRefactoring_UnableToCreateNewIndex);
        }
        try {
            if (this.doLoop.getStepInt() != 1 || this.secondDoLoop.getStepInt() != 1) {
                this.fail(Messages.TileLoopRefactoring_CantTileLoopsWithStep);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Messages.TileLoopRefactoring_CantTileLoopsWithStep);
        }
    }

    private ASTProperLoopConstructNode findSecondDoLoop(ASTProperLoopConstructNode firstLoop) {
        IASTListNode<IExecutionPartConstruct> firstBody = firstLoop.getBody();
        return firstBody.findFirst(ASTProperLoopConstructNode.class);
    }

    private String findNewIndexVariableName(ASTProperLoopConstructNode nodeInScope, String indexVar) {
        String newIndexVar = indexVar;
        int i = 1;
        while (i <= 10) {
            boolean canUse = true;
            ScopingNode scope = ScopingNode.getLocalScope(nodeInScope);
            List<Definition> defList = scope.getAllDefinitions();
            for (Definition d : defList) {
                if (d == null || !d.getCanonicalizedName().equals(newIndexVar.toLowerCase())) continue;
                newIndexVar = String.valueOf(indexVar) + Integer.toString(i);
                canUse = false;
            }
            if (canUse) {
                return newIndexVar;
            }
            ++i;
        }
        return null;
    }

    private int findNumberOfLoops() {
        int loopCount = 0;
        IASTListNode<IExecutionPartConstruct> doLoopBody = this.doLoop.getBody();
        int i = 0;
        while (i < doLoopBody.size()) {
            if (doLoopBody.get(i) instanceof ASTProperLoopConstructNode) {
                ++loopCount;
            }
            ++i;
        }
        return loopCount;
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        if (this.tilingSize <= 0) {
            this.fail(Messages.TileLoopRefactoring_InvalidTileSize);
        }
        if (this.tilingOffset < 0) {
            this.fail(Messages.TileLoopRefactoring_InvalidTilingOffset);
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ScopingNode scope = ScopingNode.getLocalScope(this.doLoop);
        this.hasLoopDependency = false;
        this.findIndexVariableInHeader(this.secondDoLoop.getLoopHeader(), this.doLoop.getIndexVariable().getText());
        this.declareNewLoopVariables(scope);
        this.loopTilingTransformation();
        Reindenter.reindent(scope.getBody(), this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void findIndexVariableInHeader(IASTNode node, final String indexVariable) {
        node.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT && token.getText().equalsIgnoreCase(indexVariable)) {
                    TileLoopRefactoring.this.hasLoopDependency = true;
                }
            }
        });
    }

    private ASTProperLoopConstructNode loopTilingTransformation() {
        ASTProperLoopConstructNode firstElementLoop = this.constructNewElementLoop(this.doLoop, this.newFirstIndexVar);
        ASTProperLoopConstructNode firstTileLoop = this.createNewTileLoop(this.doLoop, this.newFirstIndexVar);
        ASTProperLoopConstructNode secondElementLoop = this.constructNewElementLoop(this.secondDoLoop, this.newSecondIndexVar);
        ASTProperLoopConstructNode secondTileLoop = this.createNewTileLoop(this.secondDoLoop, this.newSecondIndexVar);
        if (this.hasLoopDependency) {
            this.replaceBound(secondTileLoop.getLowerBoundIExpr(), this.doLoop.getLowerBoundIExpr().toString(), firstTileLoop.getIndexVariable().getText(), true);
            this.replaceBound(secondTileLoop.getUpperBoundIExpr(), this.doLoop.getUpperBoundIExpr().toString(), firstTileLoop.getIndexVariable().getText(), false);
        }
        IASTListNode<IExecutionPartConstruct> body = secondElementLoop.getBody();
        body.add(this.secondDoLoop.getBody());
        body = firstElementLoop.getBody();
        body.add(secondElementLoop);
        body = secondTileLoop.getBody();
        body.add(firstElementLoop);
        body = firstTileLoop.getBody();
        body.add(secondTileLoop);
        this.doLoop.replaceWith(firstTileLoop);
        return firstTileLoop;
    }

    private void replaceBound(IExpr expr, String replace1, String replace2, boolean isLb) {
        if (!(expr instanceof ASTIntConstNode)) {
            IExpr dummyBound = (IExpr)expr.clone();
            IExpr dummyBound2 = (IExpr)expr.clone();
            this.replaceFirstLoopIndexVariable(dummyBound, this.doLoop.getIndexVariable().getText(), replace1);
            this.replaceFirstLoopIndexVariable(dummyBound2, this.doLoop.getIndexVariable().getText(), replace2);
            if (!dummyBound.toString().equals(dummyBound2.toString())) {
                String replacementBound = isLb ? String.format("max(%s,%s)", dummyBound.toString(), dummyBound2.toString()) : String.format("min(%s,%s)", dummyBound.toString(), dummyBound2.toString());
                expr.replaceWith(replacementBound);
            }
        }
    }

    private void replaceFirstLoopIndexVariable(IASTNode node, final String indexVar, final String replacement) {
        node.accept(new ASTVisitor(){

            @Override
            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT && token.getText().equalsIgnoreCase(indexVar)) {
                    token.replaceWith(replacement);
                }
            }
        });
    }

    private void declareNewLoopVariables(ScopingNode scope) {
        IASTListNode<? extends IASTNode> scopeBody = scope.getOrCreateBody();
        String declarationString = "integer :: " + this.newFirstIndexVar + ", " + this.newSecondIndexVar;
        int insertionIndex = TileLoopRefactoring.findIndexToInsertTypeDeclaration(scopeBody);
        scopeBody.add(insertionIndex, TileLoopRefactoring.parseLiteralStatement(declarationString));
    }

    private ASTProperLoopConstructNode createNewTileLoop(ASTProperLoopConstructNode inputLoop, String newIndexVar) {
        String newLb = this.getNewBoundsString(inputLoop.getLowerBoundIExpr());
        String newUb = this.getNewBoundsString(inputLoop.getUpperBoundIExpr());
        String loopHeader = String.format("do %s=%s,%s,%s\nend do\n", newIndexVar, newLb, newUb, this.tilingSize);
        return TileLoopRefactoring.parseLiteralDoLoop(loopHeader);
    }

    private String getNewBoundsString(IExpr expr) {
        if (expr instanceof ASTIntConstNode) {
            int loopBoundInt = Integer.parseInt(expr.toString().trim());
            int newBound = (int)Math.floor((double)(loopBoundInt - this.tilingOffset) / (double)this.tilingSize);
            newBound = newBound * this.tilingSize + this.tilingOffset;
            return Integer.toString(newBound);
        }
        return String.format("floor(real(%s-%s)/%s)*%s+%s", expr.toString(), Integer.toString(this.tilingOffset), Integer.toString(this.tilingSize), Integer.toString(this.tilingSize), Integer.toString(this.tilingOffset));
    }

    private ASTProperLoopConstructNode constructNewElementLoop(ASTProperLoopConstructNode inputLoop, String newIndexVar) {
        String elementLoopLb = String.format("max(%s,%s)", inputLoop.getLowerBoundIExpr().toString(), newIndexVar);
        String elementLoopUb = String.format("min(%s,%s+%s)", inputLoop.getUpperBoundIExpr().toString(), newIndexVar, this.tilingSize - 1);
        String elementLoopFull = String.format("do %s=%s,%s\n end do\n", inputLoop.getIndexVariable().getText(), elementLoopLb, elementLoopUb);
        ASTProperLoopConstructNode newNode = TileLoopRefactoring.parseLiteralDoLoop(elementLoopFull);
        return newNode;
    }

    @UserInputString(label="Enter tile size ", defaultValueMethod="getSuggestedTilingSize")
    public void setLoopTilingStepNumber(String input) {
        this.tilingSize = Integer.parseInt(input.trim());
    }

    public String getSuggestedTilingSize() {
        return "1";
    }

    @UserInputString(label="Enter tile offset ", defaultValueMethod="getSuggestedTilingOffset")
    public void setLoopTilingOffsetNumber(String input) {
        this.tilingOffset = Integer.parseInt(input.trim());
    }

    public String getSuggestedTilingOffset() {
        return "1";
    }

    @Override
    public String getName() {
        return Messages.TileLoopRefactoring_LoopTilingName;
    }
}

