/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.actions;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.ui.handlers.HandlerUtil;

public class SpecfileEditorToggleCommentActionDelegate
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SpecfileEditor editor = (SpecfileEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IDocument document = (IDocument)editor.getAdapter(IDocument.class);
        ISelection currentSelection = editor.getSpecfileSourceViewer().getSelection();
        if (currentSelection instanceof ITextSelection) {
            ITextSelection selection = (ITextSelection)currentSelection;
            String selectedContent = "";
            try {
                int begin = document.getLineOffset(selection.getStartLine());
                StringBuilder sb = new StringBuilder(document.get().substring(0, begin));
                String content = document.get().substring(begin, selection.getOffset() + selection.getLength());
                selectedContent = this.linesContentCommentChar(content) ? (selection.getStartLine() == selection.getEndLine() ? "#" + content : "#" + content.replaceAll("\n", "\n#")) : content.replaceFirst("#", "").replaceAll("\n#", "\n");
                sb.append(selectedContent);
                sb.append(document.get().substring(selection.getOffset() + selection.getLength(), document.get().length()));
                document.set(sb.toString());
                editor.setHighlightRange(selection.getOffset(), selection.getLength(), true);
            }
            catch (BadLocationException e) {
                SpecfileLog.logError(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean linesContentCommentChar(String content) {
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        boolean ret = false;
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return ret;
                }
                if (!line.startsWith("#")) return true;
                ret = false;
            }
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
            return false;
        }
    }
}

