/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisRequirementProvider;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisRequirement;

public final class TmfAnalysisRequirementHelper {
    private TmfAnalysisRequirementHelper() {
    }

    public static Set<String> getRequirementValues(IAnalysisRequirementProvider provider, String type) {
        HashSet<String> values = new HashSet<String>();
        for (TmfAnalysisRequirement requirement : provider.getAnalysisRequirements()) {
            if (!requirement.getType().equalsIgnoreCase(type)) continue;
            values.addAll(requirement.getValues());
        }
        return values;
    }

    public static Set<String> getRequirementValues(IAnalysisRequirementProvider provider, String type, TmfAnalysisRequirement.ValuePriorityLevel level) {
        HashSet<String> values = new HashSet<String>();
        for (TmfAnalysisRequirement requirement : provider.getAnalysisRequirements()) {
            if (!requirement.getType().equalsIgnoreCase(type)) continue;
            for (String value : requirement.getValues()) {
                if (requirement.getValueLevel(value) != level) continue;
                values.add(value);
            }
        }
        return values;
    }

    public static SetMultimap<String, String> getRequirementValuesMap(Iterable<IAnalysisRequirementProvider> providers) {
        HashMultimap valuesByType = HashMultimap.create();
        for (IAnalysisRequirementProvider provider : providers) {
            for (TmfAnalysisRequirement requirement : provider.getAnalysisRequirements()) {
                valuesByType.putAll((Object)requirement.getType(), requirement.getValues());
            }
        }
        return valuesByType;
    }

    public static SetMultimap<String, String> getRequirementValuesMap(Iterable<IAnalysisRequirementProvider> providers, TmfAnalysisRequirement.ValuePriorityLevel level) {
        HashMultimap valuesByType = HashMultimap.create();
        for (IAnalysisRequirementProvider provider : providers) {
            for (TmfAnalysisRequirement requirement : provider.getAnalysisRequirements()) {
                for (String value : requirement.getValues()) {
                    if (requirement.getValueLevel(value) != level) continue;
                    valuesByType.put((Object)requirement.getType(), (Object)value);
                }
            }
        }
        return valuesByType;
    }
}

