/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.views.Messages;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphing.ui.GraphDisplaySet;
import org.eclipse.linuxtools.systemtap.structures.listeners.ITabListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;

public class GraphSelectorEditor
extends EditorPart {
    private CTabFolder scriptFolder;
    private List<GraphDisplaySet> displaySets = new ArrayList<GraphDisplaySet>();
    private List<ITabListener> tabListeners = new ArrayList<ITabListener>();
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphing.ui.views.GraphSelectorEditor";

    public void createScriptSets(String scriptName, List<String> titles, List<IFilteredDataSet> dataSets) {
        CTabItem item = null;
        int i = 0;
        int n = titles.size();
        while (i < n) {
            item = new CTabItem(this.scriptFolder, 64);
            item.setText(titles.get(i));
            Composite parent = new Composite((Composite)this.scriptFolder, 0);
            final GraphDisplaySet gds = new GraphDisplaySet(parent, dataSets.get(i));
            this.displaySets.add(gds);
            item.setControl((Control)parent);
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    gds.dispose();
                }
            });
            ++i;
        }
        this.scriptFolder.setSelection(item);
        this.fireTabOpenEvent();
        this.setPartName(NLS.bind((String)Messages.GraphSelectorEditor_graphsEditorTitle, (Object)scriptName.substring(scriptName.lastIndexOf(47) + 1)));
    }

    public void createPartControl(Composite parent) {
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 0);
        data2.top = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        Composite cmpGraph = new Composite(parent, 0);
        cmpGraph.setLayoutData((Object)data2);
        cmpGraph.setLayout((Layout)new FormLayout());
        this.scriptFolder = new CTabFolder(cmpGraph, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.scriptFolder.setLayoutData((Object)data);
        this.scriptFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphSelectorEditor.this.fireTabChangedEvent();
            }
        });
        this.scriptFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent e) {
                GraphSelectorEditor.this.displaySets.remove(GraphSelectorEditor.this.scriptFolder.indexOf((CTabItem)e.item));
                GraphSelectorEditor.this.fireTabCloseEvent();
            }
        });
    }

    public GraphDisplaySet getActiveDisplaySet() {
        return this.getDisplaySet(this.scriptFolder.getSelectionIndex());
    }

    public String getActiveTitle() {
        return this.scriptFolder.getSelection().getText();
    }

    public GraphDisplaySet getDisplaySet(int index) {
        if (index >= 0 && index < this.displaySets.size()) {
            return this.displaySets.get(index);
        }
        return null;
    }

    public void setFocus() {
    }

    public void addTabListener(ITabListener listener) {
        this.tabListeners.add(listener);
    }

    public void removeTabListener(ITabListener listener) {
        this.tabListeners.remove(listener);
    }

    private void fireTabCloseEvent() {
        for (ITabListener tabListener : this.tabListeners) {
            tabListener.tabClosed();
        }
    }

    private void fireTabOpenEvent() {
        for (ITabListener tabListener : this.tabListeners) {
            tabListener.tabOpened();
        }
    }

    private void fireTabChangedEvent() {
        for (ITabListener tabListener : this.tabListeners) {
            tabListener.tabChanged();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.scriptFolder != null && !this.scriptFolder.isDisposed()) {
            this.scriptFolder.dispose();
        }
        this.scriptFolder = null;
        if (this.tabListeners != null) {
            this.tabListeners.clear();
        }
        this.tabListeners = null;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

