/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view.annotatedsource;

import java.net.URI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.binutils.link2source.STLink2SourceSupport;
import org.eclipse.linuxtools.internal.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.Messages;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.STAnnotatedSourceNotFoundEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class OpenSourceFileAction {
    private OpenSourceFileAction() {
    }

    private static IFileStore getFileStore(IProject project, IPath path) {
        IEditorInput input = STLink2SourceSupport.getEditorInput((IPath)path, (IProject)project);
        if (input instanceof IURIEditorInput) {
            IURIEditorInput editorInput = (IURIEditorInput)input;
            URI uri = editorInput.getURI();
            try {
                return EFS.getStore((URI)uri);
            }
            catch (CoreException e) {
                return null;
            }
        }
        return null;
    }

    public static void openAnnotatedSourceFile(IProject project, IFile binary, SourceFile sourceFile, int lineNumber) {
        if (sourceFile == null) {
            return;
        }
        String pathName = sourceFile.getName();
        if (pathName == null) {
            return;
        }
        Path path = new Path(pathName);
        OpenSourceFileAction.openAnnotatedSourceFile(project, binary, sourceFile, (IPath)path, lineNumber);
    }

    public static void openAnnotatedSourceFile(IProject project, IFile binary, SourceFile sourceFile, IPath realLocation, int lineNumber) {
        block10: {
            IWorkbenchPage page = CUIPlugin.getActivePage();
            if (page != null) {
                IFileStore fs = OpenSourceFileAction.getFileStore(project, realLocation);
                if (fs == null && !realLocation.isAbsolute() && binary != null) {
                    IPath p = binary.getProjectRelativePath().removeLastSegments(1);
                    fs = OpenSourceFileAction.getFileStore(project, p.append(realLocation));
                }
                if (fs == null) {
                    try {
                        page.openEditor((IEditorInput)new STAnnotatedSourceNotFoundEditorInput(project, sourceFile, realLocation, lineNumber), "org.eclipse.linuxtools.gcov.view.annotatedsource.STAnnotatedSourceNotFoundEditor", true);
                    }
                    catch (PartInitException e) {
                        Status s = new Status(4, "org.eclipse.linuxtools.gcov.core", 4, Messages.OpenSourceFileAction_open_error, (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)s);
                    }
                } else {
                    try {
                        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fs);
                        if (lineNumber <= 0 || !(editor instanceof ITextEditor)) break block10;
                        IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
                        IDocument document = provider.getDocument((Object)editor.getEditorInput());
                        try {
                            int start = document.getLineOffset(lineNumber - 1);
                            ((ITextEditor)editor).selectAndReveal(start, 0);
                        }
                        catch (BadLocationException start) {
                            // empty catch block
                        }
                        IWorkbenchPage p = editor.getSite().getPage();
                        p.activate((IWorkbenchPart)editor);
                    }
                    catch (PartInitException e) {
                        Status s = new Status(4, "org.eclipse.linuxtools.gcov.core", 4, Messages.OpenSourceFileAction_open_error, (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)s);
                    }
                }
            }
        }
    }
}

