/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ctf.core;

import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;
import org.eclipse.linuxtools.tmf.ctf.core.CtfIterator;
import org.eclipse.linuxtools.tmf.ctf.core.CtfIteratorManager;
import org.eclipse.linuxtools.tmf.ctf.core.CtfLocation;
import org.eclipse.linuxtools.tmf.ctf.core.CtfLocationInfo;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

public class CtfTmfContext
implements ITmfContext {
    private CtfLocation fCurLocation;
    private long fCurRank;
    private final CtfTmfTrace fTrace;

    public CtfTmfContext(CtfTmfTrace ctfTmfTrace) {
        this.fTrace = ctfTmfTrace;
        this.fCurLocation = new CtfLocation(new CtfLocationInfo(0L, 0L));
    }

    public long getRank() {
        return this.fCurRank;
    }

    public synchronized ITmfLocation getLocation() {
        return this.fCurLocation;
    }

    public boolean hasValidRank() {
        return this.fCurRank != CtfLocation.INVALID_LOCATION.getTimestamp();
    }

    public synchronized void setLocation(ITmfLocation location) {
        this.fCurLocation = (CtfLocation)location;
        if (this.fCurLocation != null) {
            this.getIterator().seek(this.fCurLocation.getLocationInfo());
        }
    }

    public void setRank(long rank) {
        this.fCurRank = rank;
    }

    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.fCurRank;
        }
    }

    public CtfTmfTrace getTrace() {
        return this.fTrace;
    }

    public synchronized CtfTmfEvent getCurrentEvent() {
        return this.getIterator().getCurrentEvent();
    }

    public synchronized boolean advance() {
        CtfLocationInfo curLocationData = this.fCurLocation.getLocationInfo();
        CtfIterator iterator = this.getIterator();
        boolean retVal = iterator.advance();
        CtfTmfEvent currentEvent = iterator.getCurrentEvent();
        if (currentEvent != null) {
            long timestampValue = iterator.getCurrentTimestamp();
            this.fCurLocation = curLocationData.getTimestamp() == timestampValue ? new CtfLocation(timestampValue, curLocationData.getIndex() + 1L) : new CtfLocation(timestampValue, 0L);
        } else {
            this.fCurLocation = new CtfLocation(CtfLocation.INVALID_LOCATION);
        }
        return retVal;
    }

    public void dispose() {
        CtfIteratorManager.removeIterator(this.fTrace, this);
    }

    public synchronized boolean seek(long timestamp) {
        this.fCurLocation = new CtfLocation(timestamp, 0L);
        return this.getIterator().seek(timestamp);
    }

    public synchronized boolean seek(CtfLocationInfo location) {
        this.fCurLocation = new CtfLocation(location);
        return this.getIterator().seek(location);
    }

    public CtfTmfContext clone() {
        CtfTmfContext ret = null;
        try {
            ret = (CtfTmfContext)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ret;
    }

    private CtfIterator getIterator() {
        return CtfIteratorManager.getIterator(this.fTrace, this);
    }
}

