/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.logging;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.linuxtools.internal.lttng2.control.ui.Activator;

public final class ControlCommandLogger {
    private static BufferedWriter fTraceLog = null;

    private ControlCommandLogger() {
    }

    public static void init(String filename, boolean append) {
        if (fTraceLog != null) {
            ControlCommandLogger.close();
        }
        fTraceLog = ControlCommandLogger.openLogFile(filename, append);
    }

    public static void close() {
        if (fTraceLog == null) {
            return;
        }
        try {
            fTraceLog.close();
            fTraceLog = null;
        }
        catch (IOException e) {
            Activator.getDefault().logWarning("Can't close log file of the trace control", e);
        }
    }

    public static void log(String msg) {
        long currentTime = System.currentTimeMillis();
        StringBuilder message = new StringBuilder("[");
        message.append(currentTime / 1000L);
        message.append(".");
        message.append(String.format("%1$03d", currentTime % 1000L));
        message.append("] ");
        message.append(msg);
        if (fTraceLog != null) {
            try {
                fTraceLog.write(message.toString());
                fTraceLog.newLine();
                fTraceLog.flush();
            }
            catch (IOException e) {
                Activator.getDefault().logError("Can't log message in log file of the tracer control", e);
            }
        }
    }

    private static BufferedWriter openLogFile(String filename, boolean append) {
        BufferedWriter outfile = null;
        try {
            outfile = new BufferedWriter(new FileWriter(filename, append));
        }
        catch (IOException e) {
            Activator.getDefault().logError("Can't open log file for logging of tracer control commands: " + filename, e);
        }
        return outfile;
    }
}

