/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceProbeEventComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.property.TraceEventPropertySource;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TraceProbeEventPropertySource
extends TraceEventPropertySource {
    public static final String TRACE_EVENT_PROBE_ADDRESS_PROPERTY_ID = "trace.event.probe.address";
    public static final String TRACE_EVENT_PROBE_OFFSET_PROPERTY_ID = "trace.event.probe.offset";
    public static final String TRACE_EVENT_PROBE_SYMBOL_PROPERTY_ID = "trace.event.probe.symbol";
    public static final String TRACE_EVENT_PROBE_ADDRESS_PROPERTY_NAME = Messages.TraceControl_ProbeAddressPropertyName;
    public static final String TRACE_EVENT_PROBE_OFFSET_PROPERTY_NAME = Messages.TraceControl_ProbeOffsetPropertyName;
    public static final String TRACE_EVENT_PROBE_SYMBOL_PROPERTY_NAME = Messages.TraceControl_ProbeSymbolPropertyName;

    public TraceProbeEventPropertySource(TraceEventComponent component) {
        super(component);
        if (component.getClass() != TraceProbeEventComponent.class) {
            throw new IllegalArgumentException("Invalid type passed. Only class of type TraceProbeEventComponent allowed:\n" + component.getClass());
        }
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] superProperties = super.getPropertyDescriptors();
        List<IPropertyDescriptor> superList = Arrays.asList(superProperties);
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(superList);
        if (this.fEvent instanceof TraceProbeEventComponent) {
            TraceProbeEventComponent event = (TraceProbeEventComponent)this.fEvent;
            if (event.getAddress() != null) {
                list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_PROBE_ADDRESS_PROPERTY_ID, TRACE_EVENT_PROBE_ADDRESS_PROPERTY_NAME));
            }
            if (event.getOffset() != null) {
                list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_PROBE_OFFSET_PROPERTY_ID, TRACE_EVENT_PROBE_OFFSET_PROPERTY_NAME));
            }
            if (event.getSymbol() != null) {
                list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_PROBE_SYMBOL_PROPERTY_ID, TRACE_EVENT_PROBE_SYMBOL_PROPERTY_NAME));
            }
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TRACE_EVENT_PROBE_ADDRESS_PROPERTY_ID.equals(id)) {
            return ((TraceProbeEventComponent)this.fEvent).getAddress();
        }
        if (TRACE_EVENT_PROBE_OFFSET_PROPERTY_ID.equals(id)) {
            return ((TraceProbeEventComponent)this.fEvent).getOffset();
        }
        if (TRACE_EVENT_PROBE_SYMBOL_PROPERTY_ID.equals(id)) {
            return ((TraceProbeEventComponent)this.fEvent).getSymbol();
        }
        return super.getPropertyValue(id);
    }
}

