/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.service;

import java.util.regex.Matcher;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.logging.ControlCommandLogger;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.preferences.ControlPreferences;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandResult;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.service.LTTngControlServiceConstants;

public class LTTngControlServiceFactory {
    private static LTTngControlServiceFactory fInstance = null;

    private LTTngControlServiceFactory() {
    }

    public static synchronized LTTngControlServiceFactory getInstance() {
        if (fInstance == null) {
            fInstance = new LTTngControlServiceFactory();
        }
        return fInstance;
    }

    public ILttngControlService getLttngControlService(ICommandShell shell) throws ExecutionException {
        String command = "lttng version ";
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(command);
        }
        ICommandResult result = null;
        try {
            result = shell.executeCommand(command, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_GettingVersionError) + ": " + (Object)((Object)e));
        }
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(LTTngControlService.formatOutput(result));
        }
        if (result != null && result.getResult() == 0 && result.getOutput().length >= 1) {
            int index = 0;
            while (index < result.getOutput().length) {
                String line = result.getOutput()[index];
                Matcher versionMatcher = LTTngControlServiceConstants.VERSION_PATTERN.matcher(line);
                if (versionMatcher.matches()) {
                    String version = versionMatcher.group(1).trim();
                    Matcher matcher = LTTngControlServiceConstants.VERSION_2_PATTERN.matcher(version);
                    if (matcher.matches()) {
                        LTTngControlService service = new LTTngControlService(shell);
                        service.setVersion(version);
                        return service;
                    }
                    throw new ExecutionException(String.valueOf(Messages.TraceControl_UnsupportedVersionError) + ": " + version);
                }
                ++index;
            }
        }
        throw new ExecutionException(Messages.TraceControl_GettingVersionError);
    }
}

