/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteFolderHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        MessageBox confirmOperation = new MessageBox(shell, 292);
        confirmOperation.setText(Messages.DeleteDialog_Title);
        confirmOperation.setMessage(Messages.DeleteFolderHandler_Message);
        if (confirmOperation.open() != 32) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        final Iterator iterator = ((IStructuredSelection)selection).iterator();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 1000);
                while (iterator.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Object element = iterator.next();
                    if (!(element instanceof TmfTraceFolder)) continue;
                    final TmfTraceFolder folder = (TmfTraceFolder)element;
                    IFolder resource = folder.getResource();
                    try {
                        for (TmfTraceElement traceElement : folder.getTraces()) {
                            traceElement.delete(null);
                        }
                        resource.delete(true, monitor);
                    }
                    catch (CoreException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                                mb.setText(String.valueOf(Messages.DeleteFolderHandler_Error) + ' ' + folder.getName());
                                mb.setMessage(e.getMessage());
                                mb.open();
                            }
                        });
                        Activator.getDefault().logError("Error deleting folder: " + folder.getName(), e);
                    }
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)e.toString(), (String)e.getTargetException().toString());
            return null;
        }
        return null;
    }
}

