/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class TmfEditorLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file != null) {
            try {
                String traceTypeId = file.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (traceTypeId == null) {
                    return StructuredSelection.EMPTY;
                }
                TmfProjectElement project = TmfProjectRegistry.getProject(file.getProject(), true);
                if (traceTypeId.equals(TmfExperiment.class.getCanonicalName())) {
                    for (TmfExperimentElement experimentElement : project.getExperimentsFolder().getExperiments()) {
                        if (!experimentElement.getResource().equals((Object)file.getParent())) continue;
                        return new StructuredSelection((Object)experimentElement);
                    }
                } else if (traceTypeId.equals(TmfTrace.class.getCanonicalName())) {
                    for (TmfTraceElement traceElement : project.getTracesFolder().getTraces()) {
                        if (!traceElement.getResource().equals((Object)file.getParent())) continue;
                        return new StructuredSelection((Object)traceElement);
                    }
                } else {
                    for (TmfTraceElement traceElement : project.getTracesFolder().getTraces()) {
                        if (!traceElement.getResource().equals((Object)file)) continue;
                        return new StructuredSelection((Object)traceElement);
                    }
                }
            }
            catch (CoreException e) {
                return StructuredSelection.EMPTY;
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        IFile file = null;
        if (aSelection.getFirstElement() instanceof TmfTraceElement) {
            TmfTraceElement traceElement = (TmfTraceElement)aSelection.getFirstElement();
            traceElement = traceElement.getElementUnderTraceFolder();
            file = traceElement.getBookmarksFile();
        } else if (aSelection.getFirstElement() instanceof TmfExperimentElement) {
            TmfExperimentElement experimentElement = (TmfExperimentElement)aSelection.getFirstElement();
            file = experimentElement.getBookmarksFile();
        }
        if (file != null) {
            FileEditorInput tmpInput = new FileEditorInput(file);
            IEditorPart localEditor = aPage.findEditor((IEditorInput)tmpInput);
            if (localEditor != null) {
                aPage.bringToTop((IWorkbenchPart)localEditor);
            } else {
                IEditorReference[] refs;
                IEditorReference[] iEditorReferenceArray = refs = aPage.getEditorReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    try {
                        if (editorReference.getEditorInput().equals(tmpInput) && (localEditor = editorReference.getEditor(true)) != null) {
                            aPage.bringToTop((IWorkbenchPart)localEditor);
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
    }
}

