/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statesystem;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.statesystem.Messages;
import org.eclipse.linuxtools.tmf.ui.views.statesystem.TmfStateSystemViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public class TmfStateSystemExplorer
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.ssview";
    private static final Image FILTER_IMAGE = Activator.getDefault().getImageFromPath(String.valueOf(File.separator) + "icons" + File.separator + "elcl16" + File.separator + "filter_items.gif");
    private TmfStateSystemViewer fViewer;

    public TmfStateSystemExplorer() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TmfStateSystemViewer(parent);
        this.fillToolBar();
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.fViewer.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    private void fillToolBar() {
        FilterAction fFilterAction = new FilterAction();
        fFilterAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)FILTER_IMAGE));
        fFilterAction.setToolTipText(Messages.FilterButton);
        fFilterAction.setChecked(false);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)fFilterAction);
    }

    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fViewer != null) {
            this.fViewer.dispose();
        }
    }

    private class FilterAction
    extends Action {
        private FilterAction() {
        }

        public void run() {
            TmfStateSystemExplorer.this.fViewer.changeFilterStatus();
        }
    }
}

