/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphColorListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider2;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTreeExpansionEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphBaseControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphSelection;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class TimeGraphControl
extends TimeGraphBaseControl
implements FocusListener,
KeyListener,
MouseMoveListener,
MouseListener,
MouseWheelListener,
ControlListener,
SelectionListener,
MouseTrackListener,
TraverseListener,
ISelectionProvider,
MenuDetectListener,
ITmfTimeGraphDrawingHelper,
ITimeGraphColorListener {
    public static final int H_SCROLLBAR_MAX = 0x7FFFFFFE;
    private static final int DRAG_NONE = 0;
    private static final int DRAG_TRACE_ITEM = 1;
    private static final int DRAG_SPLIT_LINE = 2;
    private static final int DRAG_ZOOM = 3;
    private static final int DRAG_SELECTION = 4;
    private static final int CUSTOM_ITEM_HEIGHT = -1;
    private static final double ZOOM_FACTOR = 1.5;
    private static final double ZOOM_IN_FACTOR = 0.8;
    private static final double ZOOM_OUT_FACTOR = 1.25;
    private static final int SNAP_WIDTH = 2;
    private static final int NO_STATUS = -1;
    private LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Color[] fEventColorMap = null;
    private ITimeDataProvider fTimeProvider;
    private IStatusLineManager fStatusLineManager = null;
    private TimeGraphScale fTimeGraphScale = null;
    private boolean fIsInFocus = false;
    private boolean fMouseOverSplitLine = false;
    private int fGlobalItemHeight = -1;
    private int fMinimumItemWidth = 0;
    private int fTopIndex = 0;
    private int fDragState = 0;
    private int fDragButton;
    private int fDragX0 = 0;
    private int fDragX = 0;
    private long fDragTime0 = 0L;
    private int fIdealNameSpace = 0;
    private long fTime0bak;
    private long fTime1bak;
    private ITimeGraphPresentationProvider fTimeGraphProvider = null;
    private ItemData fItemData = null;
    private List<SelectionListener> fSelectionListeners;
    private final List<ISelectionChangedListener> fSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final List<ITimeGraphTreeListener> fTreeListeners = new ArrayList<ITimeGraphTreeListener>();
    private final List<MenuDetectListener> fTimeGraphEntryMenuListeners = new ArrayList<MenuDetectListener>();
    private final List<MenuDetectListener> fTimeEventMenuListeners = new ArrayList<MenuDetectListener>();
    private final Cursor fDragCursor = Display.getDefault().getSystemCursor(21);
    private final Cursor fResizeCursor = Display.getDefault().getSystemCursor(19);
    private final Cursor fWaitCursor = Display.getDefault().getSystemCursor(1);
    private final Cursor fZoomCursor = Display.getDefault().getSystemCursor(9);
    private final List<ViewerFilter> fFilters = new ArrayList<ViewerFilter>();
    private MenuDetectEvent fPendingMenuDetectEvent = null;
    private boolean fHideArrows = false;
    private int fBorderWidth = 0;
    private int fHeaderHeight = 0;
    private Listener fMouseScrollFilterListener;
    private MouseScrollNotifier fMouseScrollNotifier;
    private final Object fMouseScrollNotifierLock = new Object();

    public TimeGraphControl(Composite parent, TimeGraphColorScheme colors) {
        super(parent, colors, 537133312);
        this.fItemData = new ItemData();
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addMouseWheelListener(this);
        this.addTraverseListener(this);
        this.addKeyListener(this);
        this.addControlListener(this);
        this.addMenuDetectListener(this);
        ScrollBar scrollHor = this.getHorizontalBar();
        if (scrollHor != null) {
            scrollHor.addSelectionListener((SelectionListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        this.fResourceManager.dispose();
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphProvider = timeGraphProvider;
        if (timeGraphProvider instanceof ITimeGraphPresentationProvider2) {
            ((ITimeGraphPresentationProvider2)timeGraphProvider).setDrawingHelper(this);
            ((ITimeGraphPresentationProvider2)timeGraphProvider).addColorListener(this);
        }
        StateItem[] stateItems = this.fTimeGraphProvider.getStateTable();
        this.colorSettingsChanged(stateItems);
    }

    public ITimeGraphPresentationProvider getTimeGraphProvider() {
        return this.fTimeGraphProvider;
    }

    public Color[] getEventColorMap() {
        return this.fEventColorMap;
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this.fTimeProvider = timeProvider;
        this.adjustScrolls();
        this.redraw();
    }

    public void setStatusLineManager(IStatusLineManager statusLineManager) {
        if (this.fStatusLineManager != null && statusLineManager == null) {
            this.fStatusLineManager.setMessage("");
        }
        this.fStatusLineManager = statusLineManager;
    }

    public void setTimeGraphScale(TimeGraphScale timeGraphScale) {
        this.fTimeGraphScale = timeGraphScale;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.fSelectionListeners == null) {
            this.fSelectionListeners = new ArrayList<SelectionListener>();
        }
        this.fSelectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.fSelectionListeners != null) {
            this.fSelectionListeners.remove(listener);
        }
    }

    public void fireSelectionChanged() {
        if (this.fSelectionListeners != null) {
            for (SelectionListener listener : this.fSelectionListeners) {
                listener.widgetSelected(null);
            }
        }
    }

    public void fireDefaultSelection() {
        if (this.fSelectionListeners != null) {
            for (SelectionListener listener : this.fSelectionListeners) {
                listener.widgetDefaultSelected(null);
            }
        }
    }

    public ITimeGraphEntry[] getTraces() {
        return this.fItemData.getEntries();
    }

    public boolean[] getTraceFilter() {
        return this.fItemData.getEntryFilter();
    }

    public void refreshData() {
        this.fItemData.refreshData();
        this.adjustScrolls();
        this.redraw();
    }

    public void refreshData(ITimeGraphEntry[] traces) {
        this.fItemData.refreshData(traces);
        this.adjustScrolls();
        this.redraw();
    }

    public void refreshArrows(List<ILinkEvent> events) {
        this.fItemData.refreshArrows(events);
    }

    public void adjustScrolls() {
        if (this.fTimeProvider == null) {
            this.getHorizontalBar().setValues(0, 1, 1, 1, 1, 1);
            return;
        }
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        long timeMin = this.fTimeProvider.getMinTime();
        long timeMax = this.fTimeProvider.getMaxTime();
        long delta = timeMax - timeMin;
        int timePos = 0;
        int thumb = 0x7FFFFFFE;
        if (delta != 0L) {
            thumb = Math.max(1, (int)(2.147483646E9 * ((double)(time1 - time0) / (double)delta)));
            timePos = (int)(2.147483646E9 * ((double)(time0 - timeMin) / (double)delta));
        }
        this.getHorizontalBar().setValues(timePos, 0, 0x7FFFFFFE, thumb, Math.max(1, thumb / 2), Math.max(2, thumb));
    }

    boolean ensureVisibleItem(int idx, boolean redraw) {
        boolean changed = false;
        int index = idx;
        if (index < 0) {
            index = 0;
            while (index < this.fItemData.fExpandedItems.length) {
                if (this.fItemData.fExpandedItems[index].fSelected) break;
                ++index;
            }
        }
        if (index >= this.fItemData.fExpandedItems.length) {
            return changed;
        }
        if (index < this.fTopIndex) {
            this.setTopIndex(index);
            if (redraw) {
                this.redraw();
            }
            changed = true;
        } else {
            int page = this.countPerPage();
            if (index >= this.fTopIndex + page) {
                this.setTopIndex(index - page + 1);
                if (redraw) {
                    this.redraw();
                }
                changed = true;
            }
        }
        return changed;
    }

    public void setTopIndex(int idx) {
        int index = Math.min(idx, this.fItemData.fExpandedItems.length - this.countPerPage());
        this.fTopIndex = index = Math.max(0, index);
        this.redraw();
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        Item item = this.fItemData.findItem(entry);
        if (item != null && item.fExpanded != expanded) {
            item.fExpanded = expanded;
            this.fItemData.updateExpandedItems();
            this.redraw();
        }
    }

    public void collapseAll() {
        Item[] itemArray = this.fItemData.fItems;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            item.fExpanded = false;
            ++n2;
        }
        this.fItemData.updateExpandedItems();
        this.redraw();
    }

    public void expandAll() {
        Item[] itemArray = this.fItemData.fItems;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            item.fExpanded = true;
            ++n2;
        }
        this.fItemData.updateExpandedItems();
        this.redraw();
    }

    public void addTreeListener(ITimeGraphTreeListener listener) {
        if (!this.fTreeListeners.contains(listener)) {
            this.fTreeListeners.add(listener);
        }
    }

    public void removeTreeListener(ITimeGraphTreeListener listener) {
        if (this.fTreeListeners.contains(listener)) {
            this.fTreeListeners.remove(listener);
        }
    }

    public void fireTreeEvent(ITimeGraphEntry entry, boolean expanded) {
        TimeGraphTreeExpansionEvent event = new TimeGraphTreeExpansionEvent(this, entry);
        for (ITimeGraphTreeListener listener : this.fTreeListeners) {
            if (expanded) {
                listener.treeExpanded(event);
                continue;
            }
            listener.treeCollapsed(event);
        }
    }

    public void addTimeGraphEntryMenuListener(MenuDetectListener listener) {
        if (!this.fTimeGraphEntryMenuListeners.contains(listener)) {
            this.fTimeGraphEntryMenuListeners.add(listener);
        }
    }

    public void removeTimeGraphEntryMenuListener(MenuDetectListener listener) {
        if (this.fTimeGraphEntryMenuListeners.contains(listener)) {
            this.fTimeGraphEntryMenuListeners.remove(listener);
        }
    }

    private void fireMenuEventOnTimeGraphEntry(MenuDetectEvent event) {
        for (MenuDetectListener listener : this.fTimeGraphEntryMenuListeners) {
            listener.menuDetected(event);
        }
    }

    public void addTimeEventMenuListener(MenuDetectListener listener) {
        if (!this.fTimeEventMenuListeners.contains(listener)) {
            this.fTimeEventMenuListeners.add(listener);
        }
    }

    public void removeTimeEventMenuListener(MenuDetectListener listener) {
        if (this.fTimeEventMenuListeners.contains(listener)) {
            this.fTimeEventMenuListeners.remove(listener);
        }
    }

    private void fireMenuEventOnTimeEvent(MenuDetectEvent event) {
        for (MenuDetectListener listener : this.fTimeEventMenuListeners) {
            listener.menuDetected(event);
        }
    }

    public ISelection getSelection() {
        TimeGraphSelection sel = new TimeGraphSelection();
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace != null && this.fTimeProvider != null) {
            long selectedTime = this.fTimeProvider.getSelectionBegin();
            ITimeEvent event = Utils.findEvent(trace, selectedTime, 0);
            if (event != null) {
                sel.add(event);
            } else {
                sel.add(trace);
            }
        }
        return sel;
    }

    public ISelection getSelectionTrace() {
        TimeGraphSelection sel = new TimeGraphSelection();
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace != null) {
            sel.add(trace);
        }
        return sel;
    }

    public void selectTrace(int n) {
        if (n != 1 && n != -1) {
            return;
        }
        boolean changed = false;
        int lastSelection = -1;
        int i = 0;
        while (i < this.fItemData.fExpandedItems.length) {
            Item item = this.fItemData.fExpandedItems[i];
            if (item.fSelected) {
                lastSelection = i;
                if (1 == n && i < this.fItemData.fExpandedItems.length - 1) {
                    item.fSelected = false;
                    item = this.fItemData.fExpandedItems[i + 1];
                    item.fSelected = true;
                    changed = true;
                    break;
                }
                if (-1 != n || i <= 0) break;
                item.fSelected = false;
                item = this.fItemData.fExpandedItems[i - 1];
                item.fSelected = true;
                changed = true;
                break;
            }
            ++i;
        }
        if (lastSelection < 0 && this.fItemData.fExpandedItems.length > 0) {
            Item item = this.fItemData.fExpandedItems[0];
            item.fSelected = true;
            changed = true;
        }
        if (changed) {
            this.ensureVisibleItem(-1, false);
            this.redraw();
            this.fireSelectionChanged();
        }
    }

    public void selectEvent(int n) {
        if (this.fTimeProvider == null) {
            return;
        }
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace == null) {
            return;
        }
        long selectedTime = this.fTimeProvider.getSelectionBegin();
        long endTime = this.fTimeProvider.getEndTime();
        ITimeEvent nextEvent = -1 == n && selectedTime > endTime ? Utils.findEvent(trace, selectedTime, 0) : Utils.findEvent(trace, selectedTime, n);
        if (nextEvent == null && -1 == n) {
            nextEvent = Utils.getFirstEvent(trace);
        }
        if (nextEvent != null) {
            long nextTime = nextEvent.getTime();
            if (nextTime <= selectedTime && n == 1) {
                nextTime = nextEvent.getTime() + nextEvent.getDuration();
                if (nextTime > endTime) {
                    nextTime = endTime;
                }
            } else if (n == -1 && nextEvent.getTime() + nextEvent.getDuration() < selectedTime) {
                nextTime = nextEvent.getTime() + nextEvent.getDuration();
            }
            this.fTimeProvider.setSelectedTimeNotify(nextTime, true);
            this.fireSelectionChanged();
        } else if (1 == n) {
            this.fTimeProvider.setSelectedTimeNotify(endTime, true);
            this.fireSelectionChanged();
        }
    }

    public void selectNextEvent() {
        this.selectEvent(1);
        this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
    }

    public void selectPrevEvent() {
        this.selectEvent(-1);
        this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
    }

    public void selectNextTrace() {
        this.selectTrace(1);
    }

    public void selectPrevTrace() {
        this.selectTrace(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoom(boolean zoomIn) {
        int globalX = this.getDisplay().getCursorLocation().x;
        Point p = this.toControl(globalX, 0);
        int nameSpace = this.fTimeProvider.getNameSpace();
        int timeSpace = this.fTimeProvider.getTimeSpace();
        int xPos = Math.max(nameSpace, Math.min(nameSpace + timeSpace, p.x));
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        long interval = time1 - time0;
        if (interval == 0L) {
            interval = 1L;
        }
        long newInterval = zoomIn ? Math.max(Math.round((double)interval * 0.8), this.fTimeProvider.getMinTimeInterval()) : (long)Math.ceil((double)interval * 1.25);
        long center = time0 + Math.round((double)(xPos - nameSpace) / (double)timeSpace * (double)interval);
        long newTime0 = center - Math.round((double)newInterval * (double)(center - time0) / (double)interval);
        long newTime1 = newTime0 + newInterval;
        this.fTimeProvider.setStartFinishTime(newTime0, newTime1);
        Object object = this.fMouseScrollNotifierLock;
        synchronized (object) {
            if (this.fMouseScrollNotifier == null) {
                this.fMouseScrollNotifier = new MouseScrollNotifier();
                this.fMouseScrollNotifier.start();
            }
            this.fMouseScrollNotifier.mouseScrolled();
        }
    }

    public void zoomIn() {
        long prevTime0 = this.fTimeProvider.getTime0();
        long prevTime1 = this.fTimeProvider.getTime1();
        long prevRange = prevTime1 - prevTime0;
        if (prevRange == 0L) {
            return;
        }
        ITimeDataProvider provider = this.fTimeProvider;
        long selTime = (provider.getSelectionEnd() + provider.getSelectionBegin()) / 2L;
        if (selTime <= prevTime0 || selTime >= prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        long time0 = selTime - (long)((double)(selTime - prevTime0) / 1.5);
        long time1 = selTime + (long)((double)(prevTime1 - selTime) / 1.5);
        long inaccuracy = this.fTimeProvider.getMaxTime() - this.fTimeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0L && inaccuracy < 100L) {
            this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getMinTime(), this.fTimeProvider.getMaxTime());
            return;
        }
        long min = this.fTimeProvider.getMinTimeInterval();
        if (time1 - time0 < min) {
            time0 = selTime - (selTime - prevTime0) * min / prevRange;
            time1 = time0 + min;
        }
        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void zoomOut() {
        long prevTime0 = this.fTimeProvider.getTime0();
        long prevTime1 = this.fTimeProvider.getTime1();
        ITimeDataProvider provider = this.fTimeProvider;
        long selTime = (provider.getSelectionEnd() + provider.getSelectionBegin()) / 2L;
        if (selTime <= prevTime0 || selTime >= prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        long time0 = (long)((double)selTime - (double)(selTime - prevTime0) * 1.5);
        long time1 = (long)((double)selTime + (double)(prevTime1 - selTime) * 1.5);
        long inaccuracy = this.fTimeProvider.getMaxTime() - this.fTimeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0L && inaccuracy < 100L) {
            this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getMinTime(), this.fTimeProvider.getMaxTime());
            return;
        }
        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void hideArrows(boolean hideArrows) {
        this.fHideArrows = hideArrows;
    }

    public void followArrowFwd() {
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace == null) {
            return;
        }
        long selectedTime = this.fTimeProvider.getSelectionBegin();
        for (ILinkEvent link : this.fItemData.fLinks) {
            if (link.getEntry() != trace || link.getTime() != selectedTime) continue;
            this.selectItem(link.getDestinationEntry(), false);
            if (link.getDuration() != 0L) {
                this.fTimeProvider.setSelectedTimeNotify(link.getTime() + link.getDuration(), true);
                this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
            }
            this.fireSelectionChanged();
            return;
        }
        this.selectNextEvent();
    }

    public void followArrowBwd() {
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace == null) {
            return;
        }
        long selectedTime = this.fTimeProvider.getSelectionBegin();
        for (ILinkEvent link : this.fItemData.fLinks) {
            if (link.getDestinationEntry() != trace || link.getTime() + link.getDuration() != selectedTime) continue;
            this.selectItem(link.getEntry(), false);
            if (link.getDuration() != 0L) {
                this.fTimeProvider.setSelectedTimeNotify(link.getTime(), true);
                this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
            }
            this.fireSelectionChanged();
            return;
        }
        this.selectPrevEvent();
    }

    public ITimeGraphEntry getSelectedTrace() {
        ITimeGraphEntry trace = null;
        int idx = this.getSelectedIndex();
        if (idx >= 0) {
            trace = this.fItemData.fExpandedItems[idx].fEntry;
        }
        return trace;
    }

    public int getSelectedIndex() {
        int idx = -1;
        int i = 0;
        while (i < this.fItemData.fExpandedItems.length) {
            Item item = this.fItemData.fExpandedItems[i];
            if (item.fSelected) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    boolean toggle(int idx) {
        Item item;
        boolean toggled = false;
        if (idx >= 0 && idx < this.fItemData.fExpandedItems.length && (item = this.fItemData.fExpandedItems[idx]).fHasChildren) {
            item.fExpanded = !item.fExpanded;
            this.fItemData.updateExpandedItems();
            this.adjustScrolls();
            this.redraw();
            toggled = true;
            this.fireTreeEvent(item.fEntry, item.fExpanded);
        }
        return toggled;
    }

    protected int getItemIndexAtY(int y) {
        if (y < 0) {
            return -1;
        }
        int ySum = 0;
        int idx = this.fTopIndex;
        while (idx < this.fItemData.fExpandedItems.length) {
            if (y < (ySum += this.fItemData.fExpandedItems[idx].fItemHeight)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    boolean isOverSplitLine(int x) {
        if (x < 0 || this.fTimeProvider == null) {
            return false;
        }
        int nameWidth = this.fTimeProvider.getNameSpace();
        return Math.abs(x - nameWidth) < 2;
    }

    protected ITimeGraphEntry getEntry(Point pt) {
        int idx = this.getItemIndexAtY(pt.y);
        return idx >= 0 ? this.fItemData.fExpandedItems[idx].fEntry : null;
    }

    @Override
    public int getXForTime(long time) {
        if (this.fTimeProvider == null) {
            return -1;
        }
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        int width = this.getCtrlSize().x;
        int nameSpace = this.fTimeProvider.getNameSpace();
        double pixelsPerNanoSec = width - nameSpace <= 1 ? 0.0 : (double)(width - nameSpace - 1) / (double)(time1 - time0);
        int x = this.getBounds().x + nameSpace + (int)((double)(time - time0) * pixelsPerNanoSec);
        return x;
    }

    @Override
    public long getTimeAtX(int coord) {
        if (this.fTimeProvider == null) {
            return -1L;
        }
        long hitTime = -1L;
        Point size = this.getCtrlSize();
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        int nameWidth = this.fTimeProvider.getNameSpace();
        int x = coord - nameWidth;
        int timeWidth = size.x - nameWidth - 1;
        if (x >= 0 && size.x >= nameWidth) {
            hitTime = time1 - time0 > (long)timeWidth ? time0 + (long)Math.ceil((double)(time1 - time0) * ((double)x / (double)timeWidth)) : time0 + (long)Math.floor((double)(time1 - time0) * ((double)x / (double)timeWidth));
        }
        return hitTime;
    }

    void selectItem(int idx, boolean addSelection) {
        boolean changed = false;
        if (addSelection) {
            if (idx >= 0 && idx < this.fItemData.fExpandedItems.length) {
                Item item = this.fItemData.fExpandedItems[idx];
                changed = !item.fSelected;
                item.fSelected = true;
            }
        } else {
            int i = 0;
            while (i < this.fItemData.fExpandedItems.length) {
                Item item = this.fItemData.fExpandedItems[i];
                if (i == idx && !item.fSelected || idx == -1 && item.fSelected) {
                    changed = true;
                }
                item.fSelected = i == idx;
                ++i;
            }
        }
        if (changed |= this.ensureVisibleItem(idx, true)) {
            this.redraw();
        }
    }

    public void selectItem(ITimeGraphEntry trace, boolean addSelection) {
        int idx = this.fItemData.findItemIndex(trace);
        this.selectItem(idx, addSelection);
    }

    public int countPerPage() {
        int height = this.getCtrlSize().y;
        int count = 0;
        int ySum = 0;
        int idx = this.fTopIndex;
        while (idx < this.fItemData.fExpandedItems.length) {
            if ((ySum += this.fItemData.fExpandedItems[idx].fItemHeight) >= height) {
                return count;
            }
            ++count;
            ++idx;
        }
        idx = this.fTopIndex - 1;
        while (idx >= 0) {
            if ((ySum += this.fItemData.fExpandedItems[idx].fItemHeight) >= height) {
                return count;
            }
            ++count;
            --idx;
        }
        return count;
    }

    public int getTopIndex() {
        return this.fTopIndex;
    }

    public int getExpandedElementCount() {
        return this.fItemData.fExpandedItems.length;
    }

    public ITimeGraphEntry[] getExpandedElements() {
        ArrayList<ITimeGraphEntry> elements = new ArrayList<ITimeGraphEntry>();
        Item[] itemArray = this.fItemData.fExpandedItems;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            elements.add(item.fEntry);
            ++n2;
        }
        return elements.toArray(new ITimeGraphEntry[0]);
    }

    Point getCtrlSize() {
        Point size = this.getSize();
        if (this.getHorizontalBar().isVisible()) {
            size.y -= this.getHorizontalBar().getSize().y;
        }
        return size;
    }

    Rectangle getNameRect(Rectangle bound, int idx, int nameWidth) {
        Rectangle rect = this.getStatesRect(bound, idx, nameWidth);
        rect.x = bound.x;
        rect.width = nameWidth;
        return rect;
    }

    Rectangle getStatesRect(Rectangle bound, int idx, int nameWidth) {
        int i;
        int x = bound.x + nameWidth;
        int width = bound.width - x;
        int ySum = 0;
        if (idx >= this.fTopIndex) {
            i = this.fTopIndex;
            while (i < idx) {
                ySum += this.fItemData.fExpandedItems[i].fItemHeight;
                ++i;
            }
        } else {
            i = this.fTopIndex - 1;
            while (i >= idx) {
                ySum -= this.fItemData.fExpandedItems[i].fItemHeight;
                --i;
            }
        }
        int y = bound.y + ySum;
        int height = this.fItemData.fExpandedItems[idx].fItemHeight;
        return new Rectangle(x, y, width, height);
    }

    @Override
    void paint(Rectangle bounds, PaintEvent e) {
        GC gc = e.gc;
        gc.setBackground(this.getColorScheme().getColor(32));
        this.drawBackground(gc, bounds.x, bounds.y, bounds.width, bounds.height);
        if (bounds.width < 2 || bounds.height < 2 || this.fTimeProvider == null) {
            return;
        }
        this.fIdealNameSpace = 0;
        int nameSpace = this.fTimeProvider.getNameSpace();
        gc.setBackground(this.getColorScheme().getBkColor(false, false, true));
        this.drawBackground(gc, bounds.x, bounds.y, nameSpace, bounds.height);
        this.drawItems(bounds, this.fTimeProvider, this.fItemData.fExpandedItems, this.fTopIndex, nameSpace, gc);
        this.drawLinks(bounds, this.fTimeProvider, this.fItemData.fLinks, nameSpace, gc);
        this.fTimeGraphProvider.postDrawControl(bounds, gc);
        int alpha = gc.getAlpha();
        gc.setAlpha(100);
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        long selectionBegin = this.fTimeProvider.getSelectionBegin();
        long selectionEnd = this.fTimeProvider.getSelectionEnd();
        double pixelsPerNanoSec = bounds.width - nameSpace <= 1 ? 0.0 : (double)(bounds.width - nameSpace - 1) / (double)(time1 - time0);
        int x0 = bounds.x + nameSpace + (int)((double)(selectionBegin - time0) * pixelsPerNanoSec);
        int x1 = bounds.x + nameSpace + (int)((double)(selectionEnd - time0) * pixelsPerNanoSec);
        if (this.fDragState != 4) {
            gc.setForeground(this.getColorScheme().getColor(68));
            if (x0 >= nameSpace && x0 < bounds.x + bounds.width) {
                gc.drawLine(x0, bounds.y, x0, bounds.y + bounds.height);
            }
            if (x1 != x0 && x1 >= nameSpace && x1 < bounds.x + bounds.width) {
                gc.drawLine(x1, bounds.y, x1, bounds.y + bounds.height);
            }
        }
        if (selectionBegin != 0L && selectionEnd != 0L && this.fDragState != 4) {
            x0 = Math.max(nameSpace, Math.min(bounds.x + bounds.width, x0));
            x1 = Math.max(nameSpace, Math.min(bounds.x + bounds.width, x1));
            gc.setBackground(this.getColorScheme().getBkColor(false, false, true));
            if (x1 - x0 > 1) {
                gc.fillRectangle(new Rectangle(x0 + 1, bounds.y, x1 - x0 - 1, bounds.height));
            } else if (x0 - x1 > 1) {
                gc.fillRectangle(new Rectangle(x1 + 1, bounds.y, x0 - x1 - 1, bounds.height));
            }
        }
        if (this.fDragState == 3 || this.fDragState == 4) {
            gc.setBackground(this.getColorScheme().getBkColor(false, false, true));
            if (this.fDragX0 < this.fDragX) {
                gc.fillRectangle(new Rectangle(this.fDragX0, bounds.y, this.fDragX - this.fDragX0, bounds.height));
            } else if (this.fDragX0 > this.fDragX) {
                gc.fillRectangle(new Rectangle(this.fDragX, bounds.y, this.fDragX0 - this.fDragX, bounds.height));
            }
        }
        if (2 == this.fDragState) {
            gc.setForeground(this.getColorScheme().getColor(43));
            gc.drawLine(bounds.x + nameSpace, bounds.y, bounds.x + nameSpace, bounds.y + bounds.height - 1);
        } else if (3 == this.fDragState && Math.max(this.fDragX, this.fDragX0) > nameSpace) {
            gc.setForeground(this.getColorScheme().getColor(39));
            gc.drawLine(this.fDragX0, bounds.y, this.fDragX0, bounds.y + bounds.height - 1);
            if (this.fDragX != this.fDragX0) {
                gc.drawLine(this.fDragX, bounds.y, this.fDragX, bounds.y + bounds.height - 1);
            }
        } else if (4 == this.fDragState && Math.max(this.fDragX, this.fDragX0) > nameSpace) {
            gc.setForeground(this.getColorScheme().getColor(68));
            gc.drawLine(this.fDragX0, bounds.y, this.fDragX0, bounds.y + bounds.height - 1);
            if (this.fDragX != this.fDragX0) {
                gc.drawLine(this.fDragX, bounds.y, this.fDragX, bounds.y + bounds.height - 1);
            }
        } else if (this.fDragState == 0 && this.fMouseOverSplitLine && this.fTimeProvider.getNameSpace() > 0) {
            gc.setForeground(this.getColorScheme().getColor(62));
            gc.drawLine(bounds.x + nameSpace, bounds.y, bounds.x + nameSpace, bounds.y + bounds.height - 1);
        }
        gc.setAlpha(alpha);
    }

    public void drawItems(Rectangle bounds, ITimeDataProvider timeProvider, Item[] items, int topIndex, int nameSpace, GC gc) {
        int i = topIndex;
        while (i < items.length) {
            Item item = items[i];
            this.drawItem(item, bounds, timeProvider, i, nameSpace, gc);
            ++i;
        }
    }

    protected void drawItem(Item item, Rectangle bounds, ITimeDataProvider timeProvider, int i, int nameSpace, GC gc) {
        double pixelsPerNanoSec;
        ITimeGraphEntry entry = item.fEntry;
        long time0 = timeProvider.getTime0();
        long time1 = timeProvider.getTime1();
        long selectedTime = this.fTimeProvider.getSelectionBegin();
        Rectangle nameRect = this.getNameRect(bounds, i, nameSpace);
        if (nameRect.y >= bounds.y + bounds.height) {
            return;
        }
        if (!item.fEntry.hasTimeEvents()) {
            Rectangle statesRect = this.getStatesRect(bounds, i, nameSpace);
            nameRect.width += statesRect.width;
            this.drawName(item, nameRect, gc);
        } else {
            this.drawName(item, nameRect, gc);
        }
        Rectangle rect = this.getStatesRect(bounds, i, nameSpace);
        if (rect.isEmpty()) {
            this.fTimeGraphProvider.postDrawEntry(entry, rect, gc);
            return;
        }
        if (time1 <= time0) {
            gc.setBackground(this.getColorScheme().getBkColor(false, false, false));
            gc.fillRectangle(rect);
            this.fTimeGraphProvider.postDrawEntry(entry, rect, gc);
            return;
        }
        Rectangle stateRect = Utils.clone(rect);
        boolean selected = item.fSelected;
        double d = pixelsPerNanoSec = rect.width <= 1 ? 0.0 : (double)(rect.width - 1) / (double)(time1 - time0);
        if (item.fEntry.hasTimeEvents()) {
            this.fillSpace(rect, gc, selected);
            stateRect.y += 3;
            stateRect.height -= 6;
            long maxDuration = timeProvider.getTimeSpace() == 0 ? Long.MAX_VALUE : 1L * (time1 - time0) / (long)timeProvider.getTimeSpace();
            Iterator iterator = entry.getTimeEventsIterator(time0, time1, maxDuration);
            int lastX = -1;
            while (iterator.hasNext()) {
                boolean timeSelected;
                ITimeEvent event = (ITimeEvent)iterator.next();
                int x = rect.x + (int)((double)(event.getTime() - time0) * pixelsPerNanoSec);
                int xEnd = rect.x + (int)((double)(event.getTime() + event.getDuration() - time0) * pixelsPerNanoSec);
                if (x >= rect.x + rect.width || xEnd < rect.x) continue;
                xEnd = Math.min(rect.x + rect.width, xEnd);
                stateRect.x = Math.max(rect.x, x);
                stateRect.width = Math.max(0, xEnd - stateRect.x + 1);
                if (stateRect.x == lastX) {
                    --stateRect.width;
                    if (stateRect.width > 0) {
                        gc.setForeground(Display.getDefault().getSystemColor(2));
                        gc.drawPoint(stateRect.x, stateRect.y - 2);
                        ++stateRect.x;
                    }
                }
                boolean bl = timeSelected = selectedTime >= event.getTime() && selectedTime < event.getTime() + event.getDuration();
                if (!this.drawState(this.getColorScheme(), event, stateRect, gc, selected, timeSelected)) continue;
                lastX = x;
            }
        }
        this.fTimeGraphProvider.postDrawEntry(entry, rect, gc);
    }

    public void drawLinks(Rectangle bounds, ITimeDataProvider timeProvider, List<ILinkEvent> links, int nameSpace, GC gc) {
        if (this.fHideArrows) {
            return;
        }
        for (ILinkEvent event : links) {
            this.drawLink(event, bounds, timeProvider, nameSpace, gc);
        }
    }

    protected void drawLink(ILinkEvent event, Rectangle bounds, ITimeDataProvider timeProvider, int nameSpace, GC gc) {
        int srcIndex = this.fItemData.findItemIndex(event.getEntry());
        int destIndex = this.fItemData.findItemIndex(event.getDestinationEntry());
        if (srcIndex == -1 || destIndex == -1) {
            return;
        }
        Rectangle src = this.getStatesRect(bounds, srcIndex, nameSpace);
        Rectangle dst = this.getStatesRect(bounds, destIndex, nameSpace);
        int x0 = this.getXForTime(event.getTime());
        int x1 = this.getXForTime(event.getTime() + event.getDuration());
        int limit = 0x1FFFFF;
        x0 = Math.max(-2097151, Math.min(x0, 0x1FFFFF));
        x1 = Math.max(-2097151, Math.min(x1, 0x1FFFFF));
        int y0 = src.y + src.height / 2;
        int y1 = dst.y + dst.height / 2;
        this.drawArrow(this.getColorScheme(), event, new Rectangle(x0, y0, x1 - x0, y1 - y0), gc);
    }

    protected boolean drawArrow(TimeGraphColorScheme colors, ITimeEvent event, Rectangle rect, GC gc) {
        boolean visible;
        int colorIdx = this.fTimeGraphProvider.getStateTableIndex(event);
        if (colorIdx < 0) {
            return false;
        }
        boolean bl = visible = rect.height != 0 || rect.width != 0;
        if (visible) {
            Color stateColor = null;
            stateColor = colorIdx < this.fEventColorMap.length ? this.fEventColorMap[colorIdx] : Display.getDefault().getSystemColor(2);
            gc.setForeground(stateColor);
            gc.setBackground(stateColor);
            gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
            TimeGraphControl.drawArrowHead(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, gc);
        }
        this.fTimeGraphProvider.postDrawEvent(event, rect, gc);
        return visible;
    }

    private static void drawArrowHead(int x0, int y0, int x1, int y1, GC gc) {
        int factor = 10;
        double cos = 0.951;
        double sin = 0.309;
        long lenx = x1 - x0;
        long leny = y1 - y0;
        double len = Math.sqrt(lenx * lenx + leny * leny);
        double dx = (double)((long)factor * lenx) / len;
        double dy = (double)((long)factor * leny) / len;
        int end1X = (int)Math.round((double)x1 - (dx * cos + dy * -sin));
        int end1Y = (int)Math.round((double)y1 - (dx * sin + dy * cos));
        int end2X = (int)Math.round((double)x1 - (dx * cos + dy * sin));
        int end2Y = (int)Math.round((double)y1 - (dx * -sin + dy * cos));
        int[] arrow = new int[]{x1, y1, end1X, end1Y, end2X, end2Y, x1, y1};
        gc.fillPolygon(arrow);
    }

    protected void drawName(Item item, Rectangle bounds, GC gc) {
        boolean hasTimeEvents = item.fEntry.hasTimeEvents();
        if (!hasTimeEvents) {
            gc.setBackground(this.getColorScheme().getBkColorGroup(item.fSelected, this.fIsInFocus));
            gc.fillRectangle(bounds);
            if (item.fSelected && this.fIsInFocus) {
                gc.setForeground(this.getColorScheme().getBkColor(item.fSelected, this.fIsInFocus, false));
                gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
        } else {
            gc.setBackground(this.getColorScheme().getBkColor(item.fSelected, this.fIsInFocus, true));
            gc.setForeground(this.getColorScheme().getFgColor(item.fSelected, this.fIsInFocus));
            gc.fillRectangle(bounds);
        }
        if (this.fTimeProvider.getNameSpace() == 0) {
            return;
        }
        int leftMargin = 4 + item.fLevel * 9;
        if (item.fHasChildren) {
            gc.setForeground(this.getColorScheme().getFgColorGroup(false, false));
            gc.setBackground(this.getColorScheme().getBkColor(false, false, false));
            Rectangle rect = Utils.clone(bounds);
            rect.x += leftMargin;
            rect.y += (bounds.height - 9) / 2;
            rect.width = 9;
            rect.height = 9;
            gc.fillRectangle(rect);
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            int midy = rect.y + rect.height / 2;
            gc.drawLine(rect.x + 2, midy, rect.x + rect.width - 3, midy);
            if (!item.fExpanded) {
                int midx = rect.x + rect.width / 2;
                gc.drawLine(midx, rect.y + 2, midx, rect.y + rect.height - 3);
            }
        }
        leftMargin += 13;
        Image img = this.fTimeGraphProvider.getItemImage(item.fEntry);
        if (img != null) {
            int imgHeight = img.getImageData().height;
            int imgWidth = img.getImageData().width;
            int x = leftMargin;
            int y = bounds.y + (bounds.height - imgHeight) / 2;
            gc.drawImage(img, x, y);
            leftMargin += imgWidth + 4;
        }
        String name = item.fName;
        Point size = gc.stringExtent(name);
        if (this.fIdealNameSpace < leftMargin + size.x + 4) {
            this.fIdealNameSpace = leftMargin + size.x + 4;
        }
        if (hasTimeEvents) {
            int width = bounds.width - leftMargin;
            int cuts = 0;
            while (size.x > width && name.length() > 1) {
                ++cuts;
                name = name.substring(0, name.length() - 1);
                size = gc.stringExtent(String.valueOf(name) + "...");
            }
            if (cuts > 0) {
                name = String.valueOf(name) + "...";
            }
        }
        Rectangle rect = Utils.clone(bounds);
        rect.x += leftMargin;
        rect.width -= leftMargin;
        if (rect.width > 0) {
            rect.y += (bounds.height - gc.stringExtent((String)name).y) / 2;
            gc.setForeground(this.getColorScheme().getFgColor(item.fSelected, this.fIsInFocus));
            int textWidth = Utils.drawText(gc, name, rect, true);
            leftMargin += textWidth + 4;
            rect.y -= 2;
            if (hasTimeEvents) {
                int x = bounds.x + leftMargin;
                int width = bounds.width - x;
                int midy = bounds.y + bounds.height / 2;
                gc.setForeground(this.getColorScheme().getColor(61));
                gc.drawLine(x, midy, x + width, midy);
            }
        }
    }

    protected boolean drawState(TimeGraphColorScheme colors, ITimeEvent event, Rectangle rect, GC gc, boolean selected, boolean timeSelected) {
        int colorIdx = this.fTimeGraphProvider.getStateTableIndex(event);
        if (colorIdx < 0 && colorIdx != -2) {
            return false;
        }
        boolean visible = rect.width != 0;
        Color black = Display.getDefault().getSystemColor(2);
        gc.setForeground(black);
        if (visible) {
            if (colorIdx == -2) {
                gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                if (rect.width == 1) {
                    gc.drawPoint(rect.x, rect.y - 2);
                }
                return false;
            }
            Color stateColor = null;
            stateColor = colorIdx < this.fEventColorMap.length ? this.fEventColorMap[colorIdx] : black;
            boolean reallySelected = timeSelected && selected;
            gc.setBackground(stateColor);
            gc.fillRectangle(rect);
            if (reallySelected) {
                gc.drawLine(rect.x, rect.y - 1, rect.x + rect.width - 1, rect.y - 1);
                gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width - 1, rect.y + rect.height);
            }
        } else {
            gc.drawPoint(rect.x, rect.y - 2);
        }
        this.fTimeGraphProvider.postDrawEvent(event, rect, gc);
        return visible;
    }

    protected void fillSpace(Rectangle rect, GC gc, boolean selected) {
        gc.setBackground(this.getColorScheme().getBkColor(selected, this.fIsInFocus, false));
        gc.fillRectangle(rect);
        if (this.fDragState == 3) {
            gc.setBackground(this.getColorScheme().getBkColor(selected, this.fIsInFocus, true));
            if (this.fDragX0 < this.fDragX) {
                gc.fillRectangle(new Rectangle(this.fDragX0, rect.y, this.fDragX - this.fDragX0, rect.height));
            } else if (this.fDragX0 > this.fDragX) {
                gc.fillRectangle(new Rectangle(this.fDragX, rect.y, this.fDragX0 - this.fDragX, rect.height));
            }
        }
        gc.setForeground(this.getColorScheme().getColor(61));
        int midy = rect.y + rect.height / 2;
        gc.drawLine(rect.x, midy, rect.x + rect.width, midy);
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16 || e.detail == 8) {
            e.doit = true;
        }
    }

    public void keyPressed(KeyEvent e) {
        int page;
        int idx = -1;
        if (this.fItemData.fExpandedItems.length == 0) {
            return;
        }
        if (0x1000007 == e.keyCode) {
            idx = 0;
        } else if (0x1000008 == e.keyCode) {
            idx = this.fItemData.fExpandedItems.length - 1;
        } else if (0x1000002 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx < this.fItemData.fExpandedItems.length - 1) {
                ++idx;
            }
        } else if (0x1000001 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx > 0) {
                --idx;
            }
        } else if (0x1000003 == e.keyCode) {
            this.selectPrevEvent();
        } else if (0x1000004 == e.keyCode) {
            this.selectNextEvent();
        } else if (0x1000006 == e.keyCode) {
            page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx += page) >= this.fItemData.fExpandedItems.length) {
                idx = this.fItemData.fExpandedItems.length - 1;
            }
        } else if (0x1000005 == e.keyCode) {
            page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx -= page) < 0) {
                idx = 0;
            }
        } else if (13 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx >= 0) {
                if (this.fItemData.fExpandedItems[idx].fHasChildren) {
                    this.toggle(idx);
                } else {
                    this.fireDefaultSelection();
                }
            }
            idx = -1;
        }
        if (idx >= 0) {
            this.selectItem(idx, false);
            this.fireSelectionChanged();
        }
        int x = this.toControl((Point)e.display.getCursorLocation()).x;
        this.updateCursor(x, e.stateMask | e.keyCode);
    }

    public void keyReleased(KeyEvent e) {
        int x = this.toControl((Point)e.display.getCursorLocation()).x;
        this.updateCursor(x, e.stateMask & ~e.keyCode);
    }

    public void focusGained(FocusEvent e) {
        this.fIsInFocus = true;
        if (this.fMouseScrollFilterListener == null) {
            this.fMouseScrollFilterListener = new Listener(){

                public void handleEvent(Event event) {
                    event.doit = false;
                }
            };
            this.getDisplay().addFilter(37, this.fMouseScrollFilterListener);
        }
        this.redraw();
        this.updateStatusLine(-1);
    }

    public void focusLost(FocusEvent e) {
        this.fIsInFocus = false;
        if (this.fMouseScrollFilterListener != null) {
            this.getDisplay().removeFilter(37, this.fMouseScrollFilterListener);
            this.fMouseScrollFilterListener = null;
        }
        if (this.fDragState != 0) {
            this.setCapture(false);
            this.fDragState = 0;
        }
        this.redraw();
        this.updateStatusLine(-1);
    }

    public boolean isInFocus() {
        return this.fIsInFocus;
    }

    public void waitCursor(boolean waitInd) {
        if (waitInd) {
            this.setCursor(this.fWaitCursor);
        } else {
            this.setCursor(null);
        }
    }

    private void updateCursor(int x, int stateMask) {
        if (this.getCursor() == this.fWaitCursor) {
            return;
        }
        Cursor cursor = null;
        if (this.fDragState != 2) {
            if (this.fDragState == 4) {
                cursor = this.fResizeCursor;
            } else if (this.fDragState == 1) {
                cursor = this.fDragCursor;
            } else if (this.fDragState == 3) {
                cursor = this.fZoomCursor;
            } else if ((stateMask & SWT.MODIFIER_MASK) == 262144) {
                cursor = this.fDragCursor;
            } else if ((stateMask & SWT.MODIFIER_MASK) == 131072) {
                cursor = this.fResizeCursor;
            } else if (!this.isOverSplitLine(x)) {
                long selectionBegin = this.fTimeProvider.getSelectionBegin();
                long selectionEnd = this.fTimeProvider.getSelectionEnd();
                int xBegin = this.getXForTime(selectionBegin);
                int xEnd = this.getXForTime(selectionEnd);
                if (Math.abs(x - xBegin) < 2 || Math.abs(x - xEnd) < 2) {
                    cursor = this.fResizeCursor;
                }
            }
        }
        if (this.getCursor() != cursor) {
            this.setCursor(cursor);
        }
    }

    private void updateStatusLine(int x) {
        if (this.fStatusLineManager == null || this.fTimeProvider == null || this.fTimeProvider.getTime0() == this.fTimeProvider.getTime1()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        if (x >= 0 && this.fDragState == 0) {
            long time = this.getTimeAtX(x);
            if (time >= 0L) {
                message.append("T: ");
                message.append(new TmfNanoTimestamp(time).toString());
                message.append("     T1: ");
                long selectionBegin = this.fTimeProvider.getSelectionBegin();
                long selectionEnd = this.fTimeProvider.getSelectionEnd();
                message.append(new TmfNanoTimestamp(Math.min(selectionBegin, selectionEnd)).toString());
                if (selectionBegin != selectionEnd) {
                    message.append("     T2: ");
                    message.append(new TmfNanoTimestamp(Math.max(selectionBegin, selectionEnd)).toString());
                    message.append("     \u0394: ");
                    message.append(new TmfTimestampDelta(Math.abs(selectionBegin - selectionEnd), -9));
                }
            }
        } else if (this.fDragState == 4 || this.fDragState == 3) {
            long time0 = this.fDragTime0;
            long time = this.getTimeAtX(this.fDragX);
            message.append("T1: ");
            message.append(new TmfNanoTimestamp(Math.min(time, time0)).toString());
            if (time != time0) {
                message.append("     T2: ");
                message.append(new TmfNanoTimestamp(Math.max(time, time0)).toString());
                message.append("     \u0394: ");
                message.append(new TmfTimestampDelta(Math.abs(time - time0), -9));
            }
        }
        this.fStatusLineManager.setMessage(message.toString());
    }

    public void mouseMove(MouseEvent e) {
        if (this.fTimeProvider == null) {
            return;
        }
        Point size = this.getCtrlSize();
        if (1 == this.fDragState) {
            int nameWidth = this.fTimeProvider.getNameSpace();
            if (e.x > nameWidth && size.x > nameWidth && this.fDragX != e.x) {
                long time0;
                long maxTime;
                this.fDragX = e.x;
                double pixelsPerNanoSec = size.x - nameWidth <= 1 ? 0.0 : (double)(size.x - nameWidth - 1) / (double)(this.fTime1bak - this.fTime0bak);
                long timeDelta = (long)(pixelsPerNanoSec == 0.0 ? 0.0 : (double)(this.fDragX - this.fDragX0) / pixelsPerNanoSec);
                long time1 = this.fTime1bak - timeDelta;
                if (time1 > (maxTime = this.fTimeProvider.getMaxTime())) {
                    time1 = maxTime;
                }
                if ((time0 = time1 - (this.fTime1bak - this.fTime0bak)) < this.fTimeProvider.getMinTime()) {
                    time0 = this.fTimeProvider.getMinTime();
                    time1 = time0 + (this.fTime1bak - this.fTime0bak);
                }
                this.fTimeProvider.setStartFinishTime(time0, time1);
            }
        } else if (2 == this.fDragState) {
            this.fDragX = e.x;
            this.fTimeProvider.setNameSpace(e.x);
        } else if (4 == this.fDragState) {
            this.fDragX = Math.min(Math.max(e.x, this.fTimeProvider.getNameSpace()), size.x - 1);
            this.redraw();
            this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
        } else if (3 == this.fDragState) {
            this.fDragX = Math.min(Math.max(e.x, this.fTimeProvider.getNameSpace()), size.x - 1);
            this.redraw();
            this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
        } else if (this.fDragState == 0) {
            boolean mouseOverSplitLine = this.isOverSplitLine(e.x);
            if (this.fMouseOverSplitLine != mouseOverSplitLine) {
                this.redraw();
            }
            this.fMouseOverSplitLine = mouseOverSplitLine;
        }
        this.updateCursor(e.x, e.stateMask);
        this.updateStatusLine(e.x);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.fTimeProvider == null) {
            return;
        }
        if (1 == e.button && (e.stateMask & SWT.BUTTON_MASK) == 0) {
            if (this.isOverSplitLine(e.x) && this.fTimeProvider.getNameSpace() != 0) {
                this.fTimeProvider.setNameSpace(this.fIdealNameSpace);
                boolean mouseOverSplitLine = this.isOverSplitLine(e.x);
                if (this.fMouseOverSplitLine != mouseOverSplitLine) {
                    this.redraw();
                }
                this.fMouseOverSplitLine = mouseOverSplitLine;
                return;
            }
            int idx = this.getItemIndexAtY(e.y);
            if (idx >= 0) {
                this.selectItem(idx, false);
                this.fireDefaultSelection();
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        int nameSpace;
        if (this.fDragState != 0 || this.fTimeProvider == null || this.fTimeProvider.getTime0() == this.fTimeProvider.getTime1() || this.getCtrlSize().x - this.fTimeProvider.getNameSpace() <= 0) {
            return;
        }
        if (1 == e.button && (e.stateMask & SWT.MODIFIER_MASK) == 0 && (nameSpace = this.fTimeProvider.getNameSpace()) != 0 && this.isOverSplitLine(e.x)) {
            this.fDragState = 2;
            this.fDragButton = e.button;
            this.fDragX0 = this.fDragX = e.x;
            this.fTime0bak = this.fTimeProvider.getTime0();
            this.fTime1bak = this.fTimeProvider.getTime1();
            this.redraw();
            this.updateCursor(e.x, e.stateMask);
            return;
        }
        if (1 == e.button && ((e.stateMask & SWT.MODIFIER_MASK) == 0 || (e.stateMask & SWT.MODIFIER_MASK) == 131072)) {
            nameSpace = this.fTimeProvider.getNameSpace();
            int idx = this.getItemIndexAtY(e.y);
            if (idx >= 0) {
                Item item = this.fItemData.fExpandedItems[idx];
                if (item.fHasChildren && e.x < nameSpace && e.x < 4 + (item.fLevel + 1) * 9) {
                    this.toggle(idx);
                    return;
                }
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            } else {
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            }
            long hitTime = this.getTimeAtX(e.x);
            if (hitTime >= 0L) {
                this.setCapture(true);
                this.fDragState = 4;
                this.fDragButton = e.button;
                this.fDragX0 = this.fDragX = e.x;
                this.fDragTime0 = this.getTimeAtX(this.fDragX0);
                long selectionBegin = this.fTimeProvider.getSelectionBegin();
                long selectionEnd = this.fTimeProvider.getSelectionEnd();
                int xBegin = this.getXForTime(selectionBegin);
                int xEnd = this.getXForTime(selectionEnd);
                if ((e.stateMask & SWT.MODIFIER_MASK) == 131072) {
                    long time = this.getTimeAtX(e.x);
                    if (Math.abs(time - selectionBegin) < Math.abs(time - selectionEnd)) {
                        this.fDragX0 = xEnd;
                        this.fDragTime0 = selectionEnd;
                    } else {
                        this.fDragX0 = xBegin;
                        this.fDragTime0 = selectionBegin;
                    }
                } else {
                    long time = this.getTimeAtX(e.x);
                    if (Math.abs(e.x - xBegin) < 2 && Math.abs(time - selectionBegin) <= Math.abs(time - selectionEnd)) {
                        this.fDragX0 = xEnd;
                        this.fDragTime0 = selectionEnd;
                    } else if (Math.abs(e.x - xEnd) < 2 && Math.abs(time - selectionEnd) <= Math.abs(time - selectionBegin)) {
                        this.fDragX0 = xBegin;
                        this.fDragTime0 = selectionBegin;
                    }
                }
                this.fTime0bak = this.fTimeProvider.getTime0();
                this.fTime1bak = this.fTimeProvider.getTime1();
                this.redraw();
                this.updateCursor(e.x, e.stateMask);
                this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
            }
        } else if (2 == e.button || 1 == e.button && (e.stateMask & SWT.MODIFIER_MASK) == 262144) {
            long hitTime = this.getTimeAtX(e.x);
            if (hitTime > 0L) {
                this.setCapture(true);
                this.fDragState = 1;
                this.fDragButton = e.button;
                this.fDragX0 = this.fDragX = e.x;
                this.fTime0bak = this.fTimeProvider.getTime0();
                this.fTime1bak = this.fTimeProvider.getTime1();
                this.updateCursor(e.x, e.stateMask);
            }
        } else if (3 == e.button) {
            this.setCapture(true);
            this.fDragX0 = this.fDragX = Math.min(Math.max(e.x, this.fTimeProvider.getNameSpace()), this.getCtrlSize().x - 1);
            this.fDragState = 3;
            this.fDragButton = e.button;
            this.redraw();
            this.updateCursor(e.x, e.stateMask);
            this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.fPendingMenuDetectEvent != null && e.button == 3) {
            this.menuDetected(this.fPendingMenuDetectEvent);
        }
        if (this.fDragState != 0) {
            this.setCapture(false);
            if (e.button == this.fDragButton && 1 == this.fDragState) {
                if (this.fDragX != this.fDragX0) {
                    this.fTimeProvider.notifyStartFinishTime();
                }
                this.fDragState = 0;
            } else if (e.button == this.fDragButton && 2 == this.fDragState) {
                this.fDragState = 0;
                this.redraw();
            } else if (e.button == this.fDragButton && 4 == this.fDragState) {
                if (this.fDragX == this.fDragX0) {
                    long time = this.getTimeAtX(e.x);
                    this.fTimeProvider.setSelectedTimeNotify(time, false);
                } else {
                    long time0 = this.fDragTime0;
                    long time1 = this.getTimeAtX(this.fDragX);
                    if (time0 <= time1) {
                        this.fTimeProvider.setSelectionRangeNotify(time0, time1);
                    } else {
                        this.fTimeProvider.setSelectionRangeNotify(time1, time0);
                    }
                }
                this.fDragState = 0;
                this.redraw();
                this.fTimeGraphScale.setDragRange(-1, -1);
            } else if (e.button == this.fDragButton && 3 == this.fDragState) {
                int nameWidth = this.fTimeProvider.getNameSpace();
                if (Math.max(this.fDragX, this.fDragX0) > nameWidth && this.fDragX != this.fDragX0) {
                    long time1;
                    long time0 = this.getTimeAtX(this.fDragX0);
                    if (time0 < (time1 = this.getTimeAtX(this.fDragX))) {
                        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
                    } else {
                        this.fTimeProvider.setStartFinishTimeNotify(time1, time0);
                    }
                } else {
                    this.redraw();
                }
                this.fDragState = 0;
                this.fTimeGraphScale.setDragRange(-1, -1);
            }
        }
        this.updateCursor(e.x, e.stateMask);
        this.updateStatusLine(e.x);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this.fMouseOverSplitLine) {
            this.fMouseOverSplitLine = false;
            this.redraw();
        }
        this.updateStatusLine(-1);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
        if (this.fMouseScrollFilterListener == null || this.fDragState != 0) {
            return;
        }
        boolean zoomScroll = false;
        Point p = this.getParent().toControl(this.getDisplay().getCursorLocation());
        Point parentSize = this.getParent().getSize();
        if (p.x >= 0 && p.x < parentSize.x && p.y >= 0 && p.y < parentSize.y) {
            zoomScroll = e.x > this.getCtrlSize().x ? false : e.y < 0 || e.y >= this.getCtrlSize().y || e.x >= this.fTimeProvider.getNameSpace();
        }
        if (zoomScroll && this.fTimeProvider.getTime0() != this.fTimeProvider.getTime1()) {
            if (e.count > 0) {
                this.zoom(true);
            } else if (e.count < 0) {
                this.zoom(false);
            }
        } else {
            this.setTopIndex(this.getTopIndex() - e.count);
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.adjustScrolls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.getVerticalBar()) {
            this.setTopIndex(this.getVerticalBar().getSelection());
        } else if (e.widget == this.getHorizontalBar() && this.fTimeProvider != null) {
            int start = this.getHorizontalBar().getSelection();
            long time0 = this.fTimeProvider.getTime0();
            long time1 = this.fTimeProvider.getTime1();
            long timeMin = this.fTimeProvider.getMinTime();
            long timeMax = this.fTimeProvider.getMaxTime();
            long delta = timeMax - timeMin;
            long range = time1 - time0;
            time0 = timeMin + Math.round((double)delta * ((double)start / 2.147483646E9));
            time1 = time0 + range;
            if (e.detail == 1) {
                this.fTimeProvider.setStartFinishTime(time0, time1);
            } else {
                this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
            }
        }
    }

    public int getBorderWidth() {
        return this.fBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.fBorderWidth = borderWidth;
    }

    public int getHeaderHeight() {
        return this.fHeaderHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        this.fHeaderHeight = headerHeight;
    }

    public int getItemHeight() {
        return this.fGlobalItemHeight;
    }

    public void setItemHeight(int rowHeight) {
        this.fGlobalItemHeight = rowHeight;
    }

    public boolean setItemHeight(ITimeGraphEntry entry, int rowHeight) {
        Item item = this.fItemData.findItem(entry);
        if (item != null) {
            item.fItemHeight = rowHeight;
            return true;
        }
        return false;
    }

    public void setMinimumItemWidth(int width) {
        this.fMinimumItemWidth = width;
    }

    public int getMinimumItemWidth() {
        return this.fMinimumItemWidth;
    }

    public List<ITimeGraphEntry> getFilteredOut() {
        return this.fItemData.getFilteredOut();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.fSelectionChangedListeners.contains(listener)) {
            this.fSelectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fSelectionChangedListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        TimeGraphSelection sel;
        Object ob;
        if (selection instanceof TimeGraphSelection && (ob = (sel = (TimeGraphSelection)selection).getFirstElement()) instanceof ITimeGraphEntry) {
            ITimeGraphEntry trace = (ITimeGraphEntry)ob;
            this.selectItem(trace, false);
        }
    }

    public void addFilter(ViewerFilter filter) {
        if (!this.fFilters.contains(filter)) {
            this.fFilters.add(filter);
        }
    }

    public void removeFilter(ViewerFilter filter) {
        this.fFilters.remove(filter);
    }

    @Override
    public void colorSettingsChanged(StateItem[] stateItems) {
        if (this.fEventColorMap != null) {
            Color[] colorArray = this.fEventColorMap;
            int n = this.fEventColorMap.length;
            int n2 = 0;
            while (n2 < n) {
                Color color = colorArray[n2];
                this.fResourceManager.destroyColor(color.getRGB());
                ++n2;
            }
        }
        if (stateItems != null) {
            this.fEventColorMap = new Color[stateItems.length];
            int i = 0;
            while (i < stateItems.length) {
                this.fEventColorMap[i] = this.fResourceManager.createColor(stateItems[i].getStateColor());
                ++i;
            }
        } else {
            this.fEventColorMap = new Color[0];
        }
        this.redraw();
    }

    public void menuDetected(MenuDetectEvent e) {
        if (this.fTimeProvider == null) {
            return;
        }
        if (e.detail == 0) {
            if (this.fPendingMenuDetectEvent == null) {
                this.fPendingMenuDetectEvent = e;
                return;
            }
            this.fPendingMenuDetectEvent = null;
            if (this.fDragState != 3 || this.fDragX != this.fDragX0) {
                return;
            }
        } else if (this.fDragState != 0) {
            return;
        }
        Point p = this.toControl(e.x, e.y);
        int idx = this.getItemIndexAtY(p.y);
        if (idx >= 0 && idx < this.fItemData.fExpandedItems.length) {
            ITimeEvent event;
            Item item = this.fItemData.fExpandedItems[idx];
            ITimeGraphEntry entry = item.fEntry;
            if (entry.hasTimeEvents() && (event = Utils.findEvent(entry, this.getTimeAtX(p.x), 2)) != null) {
                e.data = event;
                this.fireMenuEventOnTimeEvent(e);
                return;
            }
            e.data = entry;
            this.fireMenuEventOnTimeGraphEntry(e);
        }
    }

    private class Item {
        private boolean fExpanded;
        private int fExpandedIndex;
        private boolean fSelected;
        private boolean fHasChildren;
        private int fItemHeight;
        private final int fLevel;
        private final List<Item> fChildren;
        private final String fName;
        private final ITimeGraphEntry fEntry;

        public Item(ITimeGraphEntry entry, String name, int level) {
            this.fEntry = entry;
            this.fName = name;
            this.fLevel = level;
            this.fChildren = new ArrayList<Item>();
        }

        public String toString() {
            return this.fName;
        }
    }

    private class ItemData {
        private final Map<ITimeGraphEntry, Item> fItemMap = new LinkedHashMap<ITimeGraphEntry, Item>();
        private Item[] fExpandedItems = new Item[0];
        private Item[] fItems = new Item[0];
        private ITimeGraphEntry[] fRootEntries = new ITimeGraphEntry[0];
        private List<ILinkEvent> fLinks = new ArrayList<ILinkEvent>();
        private boolean[] fEntryFilter = new boolean[0];
        private final ArrayList<ITimeGraphEntry> fFilteredOut = new ArrayList();

        public Item findItem(ITimeGraphEntry entry) {
            return this.fItemMap.get(entry);
        }

        public int findItemIndex(ITimeGraphEntry entry) {
            Item item = this.fItemMap.get(entry);
            if (item == null) {
                return -1;
            }
            return item.fExpandedIndex;
        }

        public void refreshData() {
            this.fItemMap.clear();
            this.fFilteredOut.clear();
            ITimeGraphEntry selection = TimeGraphControl.this.getSelectedTrace();
            int i = 0;
            while (i < this.fRootEntries.length) {
                ITimeGraphEntry entry = this.fRootEntries[i];
                this.refreshData(this.fItemMap, null, 0, entry);
                ++i;
            }
            this.fItems = this.fItemMap.values().toArray(new Item[0]);
            this.updateExpandedItems();
            if (selection != null) {
                Item[] itemArray = this.fExpandedItems;
                int n = this.fExpandedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    if (item.fEntry == selection) {
                        item.fSelected = true;
                        break;
                    }
                    ++n2;
                }
            }
        }

        private void refreshData(Map<ITimeGraphEntry, Item> itemMap, Item parent, int level, ITimeGraphEntry entry) {
            Item item = new Item(entry, entry.getName(), level);
            if (parent != null) {
                parent.fChildren.add(item);
            }
            if (TimeGraphControl.this.fGlobalItemHeight == -1) {
                item.fItemHeight = TimeGraphControl.this.fTimeGraphProvider.getItemHeight(entry);
            } else {
                item.fItemHeight = TimeGraphControl.this.fGlobalItemHeight;
            }
            itemMap.put(entry, item);
            if (entry.hasChildren()) {
                item.fExpanded = true;
                item.fHasChildren = true;
                for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                    this.refreshData(itemMap, item, level + 1, iTimeGraphEntry);
                }
            }
        }

        public void updateExpandedItems() {
            Item[] itemArray = this.fItems;
            int n = this.fItems.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                item.fExpandedIndex = -1;
                ++n2;
            }
            ArrayList<Item> expandedItemList = new ArrayList<Item>();
            int i = 0;
            while (i < this.fRootEntries.length) {
                ITimeGraphEntry entry = this.fRootEntries[i];
                Item item = this.findItem(entry);
                this.refreshExpanded(expandedItemList, item);
                ++i;
            }
            this.fExpandedItems = expandedItemList.toArray(new Item[0]);
            TimeGraphControl.this.fTopIndex = Math.min(TimeGraphControl.this.fTopIndex, Math.max(0, this.fExpandedItems.length - 1));
        }

        private void refreshExpanded(List<Item> expandedItemList, Item item) {
            boolean display = true;
            for (ViewerFilter filter : TimeGraphControl.this.fFilters) {
                if (filter.select(null, (Object)item.fEntry.getParent(), (Object)item.fEntry)) continue;
                display = false;
                break;
            }
            if (display) {
                item.fExpandedIndex = expandedItemList.size();
                expandedItemList.add(item);
                if (item.fHasChildren && item.fExpanded) {
                    for (Item child : item.fChildren) {
                        this.refreshExpanded(expandedItemList, child);
                    }
                }
            }
        }

        public void refreshData(ITimeGraphEntry[] entries) {
            if (entries == null) {
                this.fEntryFilter = null;
                this.fRootEntries = null;
            } else {
                if (entries.length == 0) {
                    this.fEntryFilter = null;
                } else if (this.fEntryFilter == null || entries.length != this.fEntryFilter.length) {
                    this.fEntryFilter = new boolean[entries.length];
                    Arrays.fill(this.fEntryFilter, true);
                }
                this.fRootEntries = Arrays.copyOf(entries, entries.length);
            }
            this.refreshData();
        }

        public void refreshArrows(List<ILinkEvent> events) {
            this.fLinks = events != null ? events : new ArrayList<ILinkEvent>();
        }

        public ITimeGraphEntry[] getEntries() {
            return this.fRootEntries;
        }

        public boolean[] getEntryFilter() {
            return this.fEntryFilter;
        }

        public List<ITimeGraphEntry> getFilteredOut() {
            return this.fFilteredOut;
        }
    }

    private class MouseScrollNotifier
    extends Thread {
        private static final long DELAY = 400L;
        private static final long POLLING_INTERVAL = 10L;
        private long fLastScrollTime = Long.MAX_VALUE;

        private MouseScrollNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (System.currentTimeMillis() - this.fLastScrollTime < 400L) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    return;
                }
            }
            if (!this.isInterrupted()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TimeGraphControl.this.isDisposed()) {
                            return;
                        }
                        TimeGraphControl.this.fTimeProvider.notifyStartFinishTime();
                    }
                });
            }
            Object object = TimeGraphControl.this.fMouseScrollNotifierLock;
            synchronized (object) {
                TimeGraphControl.this.fMouseScrollNotifier = null;
            }
        }

        public void mouseScrolled() {
            this.fLastScrollTime = System.currentTimeMillis();
        }
    }
}

