/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.launch;

import java.io.File;
import java.net.URI;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.gprof.launch.GprofLaunchMessages;
import org.eclipse.linuxtools.internal.gprof.launch.GprofNoGmonDialog;
import org.eclipse.linuxtools.internal.gprof.view.GmonView;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GprofLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    private ILaunchConfiguration config;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        IPath exePath = this.getExePath(config);
        IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(this.getProject());
        File workDir = this.getWorkingDirectory(config);
        if (workDir == null) {
            workDir = new File(System.getProperty("user.home", "."));
        }
        String[] arguments = this.getProgramArgumentsArray(config);
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationWatcher(launch, exePath));
        Process process = launcher.execute(exePath, arguments, this.getEnvironment(config), (IPath)new Path(workDir.getAbsolutePath()), monitor);
        DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.gprof.launch";
    }

    private IProject getProject() {
        try {
            return CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IPath getExePath(ILaunchConfiguration config) throws CoreException {
        return CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
    }

    class LaunchTerminationWatcher
    implements ILaunchesListener2 {
        private ILaunch launch;
        private IPath exePath;

        public LaunchTerminationWatcher(ILaunch il, IPath exePath) {
            this.launch = il;
            this.exePath = exePath;
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch l = iLaunchArray[n2];
                if (l.equals(this.launch)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IFileStore exe;
                                String s = LaunchTerminationWatcher.this.exePath.toOSString();
                                URI workingDirURI = GprofLaunchConfigurationDelegate.this.getProject().getLocationURI();
                                RemoteProxyManager rpmgr = RemoteProxyManager.getInstance();
                                IRemoteFileProxy proxy = rpmgr.getFileProxy(GprofLaunchConfigurationDelegate.this.getProject());
                                String workingDirPath = proxy.toPath(workingDirURI);
                                String gmonExpected = String.valueOf(workingDirPath) + "/gmon.out";
                                IFileStore f = proxy.getResource(gmonExpected);
                                if (!f.fetchInfo().exists()) {
                                    Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                                    GprofNoGmonDialog dialog = new GprofNoGmonDialog(parent, GprofLaunchConfigurationDelegate.this.getProject());
                                    if (dialog.open() != 0) {
                                        gmonExpected = dialog.getPathToGmon();
                                        f = proxy.getResource(gmonExpected);
                                    } else {
                                        return;
                                    }
                                }
                                if ((exe = proxy.getResource(LaunchTerminationWatcher.this.exePath.toString())).fetchInfo().getLastModified() > f.fetchInfo().getLastModified()) {
                                    String title = GprofLaunchMessages.GprofGmonStale_msg;
                                    String message = GprofLaunchMessages.GprofGmonStaleExplanation_msg;
                                    Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                                    MessageDialog.openWarning((Shell)parent, (String)title, (String)message);
                                }
                                Display.getDefault().asyncExec((Runnable)new LaunchTerminationWatcherRunnable(s, gmonExpected));
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                        }
                    });
                }
                ++n2;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        class LaunchTerminationWatcherRunnable
        implements Runnable {
            private String exePath;
            private String gmonPath;

            public LaunchTerminationWatcherRunnable(String exePath, String gmonPath) {
                this.exePath = exePath;
                this.gmonPath = gmonPath;
            }

            @Override
            public void run() {
                GmonView.displayGprofView((String)this.exePath, (String)this.gmonPath, (IProject)GprofLaunchConfigurationDelegate.this.getProject());
            }
        }
    }
}

