/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.man.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.man.Activator;

public class ManParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringBuilder getRawManPage(String manPage) {
        String manExecutable = Activator.getDefault().getPreferenceStore().getString("pathPreference");
        ProcessBuilder builder = new ProcessBuilder(manExecutable, manPage);
        builder.redirectErrorStream(true);
        StringBuilder sb = new StringBuilder();
        try {
            Process process = builder.start();
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") != 0) {
                process.waitFor();
            }
            String line = null;
            Throwable throwable = null;
            Object var8_11 = null;
            try {
                InputStream manContent = process.getInputStream();
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(manContent));){
                        while ((line = reader.readLine()) != null) {
                            sb.append(String.valueOf(line) + "\n");
                        }
                    }
                    if (manContent == null) return sb;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (manContent == null) throw throwable;
                    manContent.close();
                    throw throwable;
                }
                manContent.close();
                return sb;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e1) {
            Status status = new Status(4, e1.getMessage(), "org.eclipse.linuxtools.man");
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return sb;
    }
}

