/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.structures.runnable.Command;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpExec;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ConsoleStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ErrorStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.RemoteScriptOptions;
import org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;

public class ScriptConsole
extends IOConsole {
    private static final long RETRY_STOP_TIME = 500L;
    private static final long JOIN_WAIT_TIME = 500L;
    private Command cmd = null;
    private Runnable stopCommand;
    private Thread stopCommandThread;
    private Thread onCmdStopThread;
    private Thread onCmdStartThread;
    private String moduleName;
    private ErrorStreamDaemon errorDaemon;
    private ConsoleStreamDaemon consoleDaemon;
    private final List<ScriptConsoleObserver> activeConsoleObservers = new LinkedList<ScriptConsoleObserver>();
    private List<ScriptConsoleObserver> inactiveConsoleObservers = new LinkedList<ScriptConsoleObserver>();

    public static boolean instanceIsRunning(String name) {
        IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        if (ic != null) {
            IConsole[] iConsoleArray = ic;
            int n = ic.length;
            int n2 = 0;
            while (n2 < n) {
                ScriptConsole activeConsole;
                IConsole consoleIterator = iConsoleArray[n2];
                if (consoleIterator instanceof ScriptConsole && (activeConsole = (ScriptConsole)consoleIterator).getName().endsWith(name) && activeConsole.isRunning()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static synchronized ScriptConsole getInstance(String name) {
        ScriptConsole console = null;
        try {
            IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            if (ic != null) {
                IConsole[] iConsoleArray = ic;
                int n = ic.length;
                int n2 = 0;
                while (n2 < n) {
                    ScriptConsole activeConsole;
                    IConsole consoleIterator = iConsoleArray[n2];
                    if (consoleIterator instanceof ScriptConsole && (activeConsole = (ScriptConsole)consoleIterator).getName().endsWith(name)) {
                        if (activeConsole.isRunning()) {
                            activeConsole.stop();
                            if (activeConsole.errorDaemon != null) {
                                activeConsole.cmd.removeErrorStreamListener((IGobblerListener)activeConsole.errorDaemon);
                            }
                            if (activeConsole.consoleDaemon != null) {
                                activeConsole.cmd.removeInputStreamListener((IGobblerListener)activeConsole.consoleDaemon);
                            }
                        }
                        if (activeConsole.onCmdStopThread != null && activeConsole.onCmdStopThread.isAlive()) {
                            activeConsole.onCmdStopThread.interrupt();
                            try {
                                activeConsole.onCmdStopThread.join(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        activeConsole.clearConsole();
                        activeConsole.setName(name);
                        console = activeConsole;
                        break;
                    }
                    ++n2;
                }
            }
            if (console == null) {
                console = new ScriptConsole(name, null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
        catch (NullPointerException npe) {
            console = null;
        }
        return console;
    }

    public static boolean anyRunning() {
        IConsole[] ic;
        IConsole[] iConsoleArray = ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = ic.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptConsole console;
            IConsole con = iConsoleArray[n2];
            if (con instanceof ScriptConsole && (console = (ScriptConsole)con).isRunning()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void stopAll() {
        IConsole[] ic;
        IConsole[] iConsoleArray = ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = ic.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole con = iConsoleArray[n2];
            if (con instanceof ScriptConsole) {
                ScriptConsole console = (ScriptConsole)con;
                console.stop();
            }
            ++n2;
        }
    }

    ScriptConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    private void createConsoleDaemon() {
        this.consoleDaemon = new ConsoleStreamDaemon(this);
    }

    private void createErrorDaemon(IErrorParser parser) {
        ErrorView errorView = null;
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView");
        if (ivp instanceof ErrorView) {
            errorView = (ErrorView)ivp;
        }
        this.errorDaemon = new ErrorStreamDaemon(this, errorView, parser);
    }

    private boolean waitingToStart() {
        return this.onCmdStartThread != null && this.onCmdStartThread.isAlive();
    }

    public void run(String[] command, String[] envVars, final RemoteScriptOptions remoteOptions, IErrorParser errorParser) {
        if (this.waitingToStart()) {
            return;
        }
        this.cmd = new ScpExec(command, remoteOptions, envVars);
        this.stopCommand = new Runnable(){
            private final Command stopcmd;
            private final String stopString;
            {
                this.stopcmd = ScriptConsole.this.cmd;
                this.stopString = ScriptConsole.this.getStopString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ScpExec stop = new ScpExec(new String[]{this.stopString}, remoteOptions, null);
                try {
                    Command command = this.stopcmd;
                    synchronized (command) {
                        while (this.stopcmd.isRunning()) {
                            stop.start();
                            this.stopcmd.wait(500L);
                        }
                    }
                }
                catch (CoreException e) {
                    ExceptionErrorDialog.openError((String)Localization.getString("ScriptConsole.ErrorKillingStap"), (String)e.getMessage(), (Exception)((Object)e));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.run(this.cmd, errorParser);
    }

    public void runLocally(String[] command, String[] envVars, IErrorParser errorParser, IProject project) {
        if (this.waitingToStart()) {
            return;
        }
        this.cmd = new Command(command, envVars, project);
        final IProject proj = project;
        this.stopCommand = new Runnable(){
            private final Command stopcmd;
            String stopString;
            {
                this.stopcmd = ScriptConsole.this.cmd;
                this.stopString = ScriptConsole.this.getStopString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Command command = this.stopcmd;
                    synchronized (command) {
                        while (this.stopcmd.isRunning()) {
                            RuntimeProcessFactory.getFactory().exec(this.stopString, null, proj);
                            this.stopcmd.wait(500L);
                        }
                    }
                }
                catch (IOException e) {
                    ExceptionErrorDialog.openError((String)Localization.getString("ScriptConsole.ErrorKillingStap"), (String)e.getMessage(), (Exception)e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.run(this.cmd, errorParser);
    }

    private void run(final Command cmd, IErrorParser errorParser) {
        final Runnable onCmdStop = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Command command = cmd;
                    synchronized (command) {
                        while (cmd.isRunning()) {
                            cmd.wait();
                        }
                        ScriptConsole.this.onCmdStopActions();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        Runnable onCmdStart = new Runnable(){

            @Override
            public void run() {
                if (ScriptConsole.this.stopCommandThread != null && ScriptConsole.this.stopCommandThread.isAlive()) {
                    try {
                        ScriptConsole.this.stopCommandThread.join();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                ScriptConsole.this.createConsoleDaemon();
                if (ScriptConsole.this.errorDaemon != null) {
                    cmd.addErrorStreamListener((IGobblerListener)ScriptConsole.this.errorDaemon);
                }
                cmd.addInputStreamListener((IGobblerListener)ScriptConsole.this.consoleDaemon);
                ScriptConsole.this.onCmdStopThread = new Thread(onCmdStop);
                ScriptConsole.this.onCmdStopThread.start();
                try {
                    cmd.start();
                }
                catch (CoreException e) {
                    ExceptionErrorDialog.openError((String)Localization.getString("ScriptConsole.ErrorRunningStapTitle"), (String)Localization.getString("ScriptConsole.ErrorRunningStapMessage"), (Exception)((Object)e));
                    cmd.dispose();
                    return;
                }
                ScriptConsole.this.notifyConsoleObservers();
            }
        };
        if (errorParser != null) {
            this.createErrorDaemon(errorParser);
        }
        this.activate();
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
        this.onCmdStartThread = new Thread(onCmdStart);
        this.onCmdStartThread.start();
    }

    private void onCmdStopActions() {
        this.notifyConsoleObservers();
        final String name = super.getName();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScriptConsole.this.setName(String.valueOf(Localization.getString("ScriptConsole.Terminated")) + name);
            }
        });
    }

    private synchronized void notifyConsoleObservers() {
        boolean started = this.hasStarted();
        boolean running = this.isRunning();
        for (ScriptConsoleObserver observer : this.inactiveConsoleObservers) {
            this.activeConsoleObservers.remove(observer);
        }
        this.inactiveConsoleObservers = new LinkedList<ScriptConsoleObserver>();
        for (ScriptConsoleObserver observer : this.activeConsoleObservers) {
            observer.runningStateChanged(started, !running);
        }
    }

    public synchronized void addScriptConsoleObserver(ScriptConsoleObserver observer) {
        this.activeConsoleObservers.add(observer);
        observer.runningStateChanged(this.hasStarted(), !this.isRunning());
    }

    public synchronized void removeScriptConsoleObserver(ScriptConsoleObserver observer) {
        if (this.activeConsoleObservers.contains(observer)) {
            this.inactiveConsoleObservers.add(observer);
        }
    }

    private boolean hasStarted() {
        return this.cmd == null ? false : this.cmd.hasStarted();
    }

    public boolean isRunning() {
        return this.cmd == null ? false : this.cmd.isRunning();
    }

    public boolean isDisposed() {
        if (this.cmd == null) {
            return true;
        }
        return this.cmd.isDisposed();
    }

    public void saveStream(File file) {
        if (this.isRunning() && !this.cmd.saveLog(file)) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("ScriptConsole.Problem"), (String)Localization.getString("ScriptConsole.ErrorSavingLog"));
        }
    }

    public Command getCommand() {
        return this.cmd;
    }

    public Process getProcess() {
        return this.cmd != null ? this.cmd.getProcess() : null;
    }

    public synchronized void stop() {
        if (this.isRunning() && (this.stopCommandThread == null || !this.stopCommandThread.isAlive())) {
            this.stopCommandThread = new Thread(this.stopCommand);
            this.stopCommandThread.start();
        }
    }

    private String getModuleName() {
        if (this.moduleName == null) {
            int lastDot;
            this.moduleName = this.getName();
            int lastSlash = this.moduleName.lastIndexOf(47) + 1;
            if (lastSlash < 0) {
                lastSlash = 0;
            }
            if ((lastDot = this.moduleName.indexOf(".stp")) > 0) {
                this.moduleName = this.moduleName.substring(lastSlash, lastDot);
            }
        }
        return this.moduleName;
    }

    private String getStopString() {
        return "pkill -SIGINT -f stapio.*" + this.getModuleName();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (this.cmd != null) {
                this.cmd.dispose();
            }
            this.cmd = null;
            if (this.errorDaemon != null) {
                this.errorDaemon.dispose();
            }
            this.errorDaemon = null;
            if (this.consoleDaemon != null) {
                this.consoleDaemon.dispose();
            }
            this.consoleDaemon = null;
        }
    }

    public void setName(String name) {
        super.setName(name);
        if (ConsolePlugin.getDefault() != null) {
            ConsolePlugin.getDefault().getConsoleManager().refresh((IConsole)this);
        }
    }

    public static interface ScriptConsoleObserver {
        public void runningStateChanged(boolean var1, boolean var2);
    }
}

