/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.rpm.ui.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;
import org.eclipse.linuxtools.rpm.ui.RPMExportOperation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.EditorPart;

public class SpecfileEditorRPMBuildHandler
extends AbstractHandler {
    protected RPMProject rpj;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource resource = SpecfileEditorRPMBuildHandler.getResource(event);
        String eventBuildType = event.getParameter("buildType");
        this.rpj = SpecfileEditorRPMBuildHandler.getRPMProject(resource);
        RPMExportOperation job = new RPMExportOperation(this.rpj, eventBuildType);
        job.setUser(true);
        job.schedule();
        return null;
    }

    private static IResource getResource(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null) {
            return null;
        }
        if (part instanceof EditorPart) {
            IEditorInput input = ((EditorPart)part).getEditorInput();
            if (input instanceof IFileEditorInput) {
                return ((IFileEditorInput)input).getFile();
            }
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return null;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection selection = provider.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                return (IResource)element;
            }
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                return (IResource)adaptable.getAdapter(IResource.class);
            }
            return null;
        }
        return null;
    }

    private static RPMProject getRPMProject(IResource resource) {
        RPMProject rc = null;
        try {
            IProject parentProject = resource.getProject();
            rc = parentProject.hasNature("org.eclipse.linuxtools.rpm.core.rpmnature") ? (parentProject.getPersistentProperty(new QualifiedName("org.eclipse.linuxtools.rpm.core", "SPECS")) != null ? new RPMProject(parentProject, RPMProjectLayout.RPMBUILD) : new RPMProject(parentProject, RPMProjectLayout.FLAT)) : new RPMProject(parentProject, RPMProjectLayout.FLAT);
        }
        catch (CoreException e) {
            Activator.logError(Messages.getString("SpecfileEditorRPMBuildHandler.logRPMProjectError"), e);
        }
        return rc;
    }
}

