/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.formatter.AbortFormatting;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ptp.internal.rdt.core.formatter.RemoteDefaultCodeFormatterOptions;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteCodeFormattingService;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.text.edits.TextEdit;

public class RemoteCCodeFormatter
extends CodeFormatter {
    private RemoteDefaultCodeFormatterOptions preferences;
    private Map<String, ?> options;

    public RemoteCCodeFormatter() {
        this(DefaultCodeFormatterOptions.getDefaultSettings());
    }

    public RemoteCCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public RemoteCCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, ?> options) {
        this.setOptions(options);
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public RemoteCCodeFormatter(Map<String, ?> options) {
        this(null, options);
    }

    public String createIndentationString(int indentationLevel) {
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        int tabs = 0;
        int spaces = 0;
        switch (this.preferences.tab_char) {
            case 2: {
                spaces = indentationLevel * this.preferences.tab_size;
                break;
            }
            case 1: {
                tabs = indentationLevel;
                break;
            }
            case 4: {
                int tabSize = this.preferences.tab_size;
                int spaceEquivalents = indentationLevel * this.preferences.indentation_size;
                tabs = spaceEquivalents / tabSize;
                spaces = spaceEquivalents % tabSize;
                break;
            }
            default: {
                return "";
            }
        }
        if (tabs == 0 && spaces == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public void setOptions(Map<String, ?> options) {
        if (options != null) {
            this.options = options;
            HashMap<String, String> formatterPrefs = new HashMap<String, String>(options.size());
            for (String key : options.keySet()) {
                Object value = options.get(key);
                if (!(value instanceof String)) continue;
                formatterPrefs.put(key, (String)value);
            }
            this.preferences = new RemoteDefaultCodeFormatterOptions(formatterPrefs);
        } else {
            this.options = CCorePlugin.getOptions();
            this.preferences = RemoteDefaultCodeFormatterOptions.getDefaultSettings();
        }
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        this.preferences.initial_indentation_level = indentationLevel;
        return this.format(kind, source, new IRegion[]{new Region(offset, length)}, lineSeparator)[0];
    }

    public TextEdit[] format(int kind, String source, IRegion[] regions, String lineSeparator) {
        TextEdit[] edits = new TextEdit[regions.length];
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        ITranslationUnit tu = this.getTranslationUnit(source);
        if (tu != null) {
            IRemoteCodeFormattingService codeFormattingService = this.getCodeFormattingService(tu.getCProject().getProject());
            try {
                int i = 0;
                while (i < regions.length) {
                    IRegion region = regions[i];
                    edits[i] = codeFormattingService.computeCodeFormatting(tu, source, this.preferences, region.getOffset(), region.getLength(), (IProgressMonitor)new NullProgressMonitor());
                    ++i;
                }
            }
            catch (CoreException e) {
                UIPlugin.log(e);
            }
        }
        return edits;
    }

    private ITranslationUnit getTranslationUnit(String source) {
        IFile file;
        ITranslationUnit tu = (ITranslationUnit)this.options.get("org.eclipse.cdt.core.formatter.current_translation_unit");
        if (tu == null && (file = (IFile)this.options.get("org.eclipse.cdt.core.formatter.current_file")) != null) {
            tu = (ITranslationUnit)CoreModel.getDefault().create(file);
        }
        if (tu != null && source != null) {
            try {
                if (tu.isWorkingCopy()) {
                    tu = ((IWorkingCopy)tu).getOriginalElement();
                }
                tu = tu.getWorkingCopy();
                tu.getBuffer().setContents(source);
            }
            catch (CModelException e) {
                throw new AbortFormatting((Throwable)e);
            }
        }
        return tu;
    }

    private IRemoteCodeFormattingService getCodeFormattingService(IProject project) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (!(serviceProvider instanceof IIndexServiceProvider2)) {
            return null;
        }
        IRemoteCodeFormattingService service = ((IIndexServiceProvider2)serviceProvider).getRemoteCodeFormattingService();
        return service;
    }
}

