/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteBuildServiceProvider;
import org.eclipse.ptp.rdt.ui.wizards.IIndexFilePathChangeListener;
import org.eclipse.ptp.rdt.ui.wizards.RemoteBuildServiceFileLocationWidget;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RemoteServicesServiceProviderContributor
implements IServiceProviderContributor {
    private IServiceProviderWorkingCopy fProviderWorkingCopy;
    private IRemoteConnection fSelectedConnection;
    private RemoteBuildServiceFileLocationWidget fBuildConfigLocationWidget;
    private RemoteConnectionWidget fRemoteConnectionWidget;

    public void configureServiceProvider(IServiceProviderWorkingCopy provider, Composite container) {
        this.fProviderWorkingCopy = null;
        if (provider instanceof IServiceProviderWorkingCopy) {
            this.fProviderWorkingCopy = provider;
        }
        if (!(provider.getOriginal() instanceof RemoteBuildServiceProvider)) {
            throw new IllegalArgumentException();
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.fRemoteConnectionWidget = new RemoteConnectionWidget(container, 0, null, RemoteConnectionWidget.FLAG_FORCE_PROVIDER_SELECTION);
        this.fRemoteConnectionWidget.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteServicesServiceProviderContributor.this.fSelectedConnection = RemoteServicesServiceProviderContributor.this.fRemoteConnectionWidget.getConnection();
                RemoteServicesServiceProviderContributor.this.updateProvider();
                RemoteServicesServiceProviderContributor.this.fBuildConfigLocationWidget.update(RemoteServicesServiceProviderContributor.this.fSelectedConnection);
            }
        });
        String providerSelected = this.fProviderWorkingCopy.getString("RemoteBuildServiceProvider.remoteToolsProviderID", null);
        String connection = this.fProviderWorkingCopy.getString("RemoteBuildServiceProvider.remoteToolsConnectionName", null);
        this.fRemoteConnectionWidget.setConnection(providerSelected, connection);
        this.fSelectedConnection = this.fRemoteConnectionWidget.getConnection();
        String configPath = this.fProviderWorkingCopy.getString("RemoteBuildServiceProvider.configLocation", "");
        if (configPath.length() <= 0) {
            configPath = RemoteBuildServiceFileLocationWidget.getDefaultPath(this.fSelectedConnection);
        }
        this.fBuildConfigLocationWidget = new RemoteBuildServiceFileLocationWidget(container, 0, this.fSelectedConnection, configPath);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        this.fBuildConfigLocationWidget.setLayoutData(data);
        this.fBuildConfigLocationWidget.addPathListener(new IIndexFilePathChangeListener(){

            @Override
            public void pathChanged(String newPath) {
                RemoteServicesServiceProviderContributor.this.updateProvider();
            }
        });
        this.updateProvider();
    }

    protected void updateProvider() {
        String provider = "";
        String name = "";
        if (this.fSelectedConnection != null) {
            provider = this.fSelectedConnection.getRemoteServices().getId();
            name = this.fSelectedConnection.getName();
        }
        this.fProviderWorkingCopy.putString("RemoteBuildServiceProvider.remoteToolsProviderID", provider);
        this.fProviderWorkingCopy.putString("RemoteBuildServiceProvider.remoteToolsConnectionName", name);
        this.fProviderWorkingCopy.putString("RemoteBuildServiceProvider.configLocation", this.fBuildConfigLocationWidget.getConfigLocationPath());
    }

    public IWizard getWizard(IServiceProvider provider, IWizardPage page) {
        return null;
    }

    public WizardPage[] getWizardPages(IWizard wizard, IServiceProvider provider) {
        return null;
    }
}

