/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.internal.remote.terminal.Activator;
import org.eclipse.ptp.internal.remote.terminal.TerminalInfoView;
import org.eclipse.ptp.internal.remote.terminal.scripts.Scripts;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;

public class MachineManager {
    private static Map<String, MachineInfo> machineInfoTable = new HashMap<String, MachineInfo>();

    private static synchronized MachineInfo getMachineInfo(String connectionName) {
        MachineInfo minfo = machineInfoTable.get(connectionName);
        if (minfo == null) {
            minfo = new MachineInfo();
            machineInfoTable.put(connectionName, minfo);
        }
        return minfo;
    }

    public static OutputStream getOutputStream(String address) {
        MachineInfo minfo = MachineManager.getMachineInfo(address);
        return minfo.openStream;
    }

    public static void setOutputStream(String address, OutputStream out) {
        MachineInfo minfo = MachineManager.getMachineInfo(address);
        minfo.openStream = out;
    }

    public static MachineInfo initializeMachine(IRemoteConnection remoteConnection) throws IOException {
        String address = remoteConnection.getAddress();
        MachineInfo minfo = MachineManager.getMachineInfo(address);
        if (!minfo.init) {
            minfo.init = true;
            ArrayList<String> whichCommand = new ArrayList<String>();
            whichCommand.add("which");
            whichCommand.add("tailf");
            IRemoteProcessBuilder processBuilder = remoteConnection.getProcessBuilder(whichCommand);
            String remoteShell = (String)processBuilder.environment().get("SHELL");
            IRemoteProcess whichResult = processBuilder.start();
            try {
                minfo.hasTailF = whichResult.waitFor() == 0;
            }
            catch (InterruptedException e) {
                Activator.log(e);
                minfo.hasTailF = false;
            }
            minfo.shell = remoteShell != null ? remoteShell : "/bin/bash";
            minfo.isBash = minfo.shell.contains("bash");
            minfo.isCsh = minfo.shell.contains("csh");
        }
        final String name = remoteConnection.getAddress();
        if (minfo.history == null || !minfo.history.isAlive()) {
            ArrayList<String> tailCommand = new ArrayList<String>();
            if (minfo.isCsh) {
                tailCommand.add("perl");
                tailCommand.add("-e");
                tailCommand.add(Scripts.WATCH_CSH_HISTORY_PERL_SCRIPT);
            } else if (minfo.hasTailF) {
                tailCommand.add("tailf");
            } else {
                tailCommand.add("tail");
                tailCommand.add("-f");
            }
            if (minfo.isBash) {
                tailCommand.add(".bash_history");
            } else {
                tailCommand.add(".history");
            }
            final IRemoteProcessBuilder builder = remoteConnection.getProcessBuilder(tailCommand);
            Thread commands = new Thread(){

                @Override
                public void run() {
                    InputStream in = null;
                    try {
                        try {
                            int c;
                            builder.redirectErrorStream();
                            IRemoteProcess remoteProc = builder.start();
                            in = remoteProc.getInputStream();
                            remoteProc.getOutputStream().close();
                            StringBuilder sb = new StringBuilder();
                            while ((c = in.read()) >= 0) {
                                char ch = (char)c;
                                sb.append(ch);
                                if (ch == 'K') {
                                    int n = sb.length();
                                    if (n < 3 || sb.charAt(n - 2) != '[' || sb.charAt(n - 3) != '\u001b') continue;
                                    sb.setLength(n - 3);
                                    continue;
                                }
                                if (ch != '\n') continue;
                                String s = sb.toString().trim();
                                sb.setLength(0);
                                if (s.startsWith("#") || s.startsWith("/bin/bash -l -c 'echo \"PID=$$")) continue;
                                TerminalInfoView.addToHistory(name, s);
                            }
                        }
                        catch (IOException e) {
                            Activator.log(e);
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException e2) {
                                Activator.log(e2);
                            }
                        }
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            Activator.log(e);
                        }
                    }
                }
            };
            commands.start();
            minfo.history = commands;
        }
        return minfo;
    }

    public static class MachineInfo {
        public boolean hasTailF;
        public String shell;
        public OutputStream openStream;
        public Thread history;
        public boolean isBash;
        public boolean isCsh;
        public boolean init;
    }
}

