/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.ui.wizards;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.JSchConnectionWorkingCopy;
import org.eclipse.remote.internal.jsch.ui.messages.Messages;
import org.eclipse.remote.ui.widgets.RemoteFileWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class JSchConnectionPage
extends WizardPage {
    private Text fConnectionName;
    private Button fPasswordButton;
    private Button fPublicKeyButton;
    private Text fHostText;
    private Text fUserText;
    private Text fPasswordText;
    private Text fPassphraseText;
    private Text fPortText;
    private Text fTimeoutText;
    private RemoteFileWidget fFileWidget;
    private String fInitialName = "Remote Host";
    private Set<String> fInvalidConnectionNames;
    private final Map<String, String> fInitialAttributes = new HashMap<String, String>();
    private JSchConnectionWorkingCopy fConnection;
    private final IRemoteConnectionManager fConnectionManager;
    private final DataModifyListener fDataModifyListener = new DataModifyListener();

    public JSchConnectionPage(IRemoteConnectionManager connMgr) {
        super(Messages.JSchNewConnectionPage_New_Connection);
        this.fConnectionManager = connMgr;
        this.setPageComplete(false);
    }

    private void createAdvancedControls(final Composite parent) {
        ExpandableComposite expComp = new ExpandableComposite(parent, 2);
        expComp.setText(Messages.JSchNewConnectionPage_Advanced);
        expComp.setLayoutData((Object)new GridData(4, 128, true, false));
        expComp.setExpanded(false);
        expComp.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                Point newSize = parent.computeSize(-1, -1);
                Point currentSize = parent.getSize();
                int deltaY = newSize.y - currentSize.y;
                Point shellSize = JSchConnectionPage.this.getShell().getSize();
                shellSize.y += deltaY;
                JSchConnectionPage.this.getShell().setSize(shellSize);
                JSchConnectionPage.this.getShell().layout(true, true);
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite advancedComp = new Composite((Composite)expComp, 0);
        advancedComp.setLayout((Layout)new GridLayout(2, false));
        advancedComp.setLayoutData((Object)new GridData(4, 128, true, false));
        Label portLabel = new Label(advancedComp, 0);
        portLabel.setText(Messages.JSchNewConnectionPage_Port);
        portLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fPortText = new Text(advancedComp, 2052);
        this.fPortText.setText(Integer.toString(22));
        this.fPortText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.setTextFieldWidthInChars(this.fPortText, 5);
        Label timeoutLabel = new Label(advancedComp, 0);
        timeoutLabel.setText(Messages.JSchNewConnectionPage_Timeout);
        timeoutLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fTimeoutText = new Text(advancedComp, 2052);
        this.fTimeoutText.setText(Integer.toString(5));
        this.fTimeoutText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.setTextFieldWidthInChars(this.fTimeoutText, 5);
        expComp.setClient((Control)advancedComp);
    }

    private void createAuthControls(Composite parent) {
        Composite controls = new Composite(parent, 0);
        controls.setLayout((Layout)new GridLayout(2, false));
        controls.setLayoutData((Object)new GridData(4, 4, true, false));
        Label hostLabel = new Label(controls, 0);
        hostLabel.setText(Messages.JSchNewConnectionPage_Host);
        hostLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fHostText = new Text(controls, 2052);
        this.fHostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label userLabel = new Label(controls, 0);
        userLabel.setText(Messages.JSchNewConnectionPage_User);
        userLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fUserText = new Text(controls, 2052);
        this.fUserText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fPasswordButton = new Button(controls, 16);
        this.fPasswordButton.setText(Messages.JSchNewConnectionPage_Password_based_authentication);
        this.fPasswordButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.fPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSchConnectionPage.this.validateFields();
                JSchConnectionPage.this.updateEnablement();
            }
        });
        Label passwordLabel = new Label(controls, 0);
        passwordLabel.setText(Messages.JSchNewConnectionPage_Password);
        passwordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fPasswordText = new Text(controls, 0x400804);
        this.fPasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fPublicKeyButton = new Button(controls, 16);
        this.fPublicKeyButton.setText(Messages.JSchNewConnectionPage_Public_key_based_authentication);
        this.fPublicKeyButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.fPublicKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSchConnectionPage.this.validateFields();
                JSchConnectionPage.this.updateEnablement();
            }
        });
        this.fFileWidget = new RemoteFileWidget(controls, 0, 0, null, "");
        this.fFileWidget.setConnection(RemoteServices.getLocalServices().getConnectionManager().getConnection("Local"));
        this.fFileWidget.setLabel(Messages.JSchNewConnectionPage_File_with_private_key);
        this.fFileWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label passphraseLabel = new Label(controls, 0);
        passphraseLabel.setText(Messages.JSchNewConnectionPage_Passphrase);
        passphraseLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fPassphraseText = new Text(controls, 0x400804);
        this.fPassphraseText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fPasswordButton.setSelection(true);
        this.fPublicKeyButton.setSelection(false);
        controls.setTabList(new Control[]{this.fHostText, this.fUserText, this.fPasswordButton, this.fPasswordText, this.fPublicKeyButton, this.fFileWidget, this.fPassphraseText});
    }

    public void createControl(Composite parent) {
        if (this.fConnection == null) {
            this.setDescription(Messages.JSchNewConnectionPage_New_connection_properties);
            this.setTitle(Messages.JSchNewConnectionPage_New_Connection);
            this.setMessage(Messages.JSchConnectionPage_Please_enter_name_for_connection);
        } else {
            this.setDescription(Messages.JSchConnectionPage_Edit_properties_of_an_existing_connection);
            this.setTitle(Messages.JSchConnectionPage_Edit_Connection);
        }
        this.setErrorMessage(null);
        GridLayout topLayout = new GridLayout(2, false);
        Composite topControl = new Composite(parent, 0);
        this.setControl((Control)topControl);
        topControl.setLayout((Layout)topLayout);
        Label label = new Label(topControl, 0);
        label.setText(Messages.JSchNewConnectionPage_Connection_name);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fConnectionName = new Text(topControl, 2052);
        this.fConnectionName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fConnectionName.setEnabled(this.fConnection == null);
        Group authGroup = new Group(topControl, 0);
        authGroup.setText(Messages.JSchNewConnectionPage_Host_information);
        authGroup.setLayout((Layout)new GridLayout(1, false));
        authGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createAuthControls((Composite)authGroup);
        this.createAdvancedControls((Composite)authGroup);
        this.loadValues();
        this.registerListeners();
        if (this.fConnection != null) {
            this.validateFields();
        }
        this.updateEnablement();
    }

    public JSchConnectionWorkingCopy getConnection() {
        return this.fConnection;
    }

    private boolean isInvalidName(String name) {
        if (this.fConnection == null) {
            if (this.fInvalidConnectionNames == null) {
                return this.fConnectionManager.getConnection(name) != null;
            }
            return this.fInvalidConnectionNames.contains(name);
        }
        return false;
    }

    private void loadValues() {
        if (this.fConnection != null) {
            this.fConnectionName.setText(this.fConnection.getName());
            this.fHostText.setText(this.fConnection.getAddress());
            this.fUserText.setText(this.fConnection.getUsername());
            this.fPortText.setText(Integer.toString(this.fConnection.getPort()));
            this.fTimeoutText.setText(Integer.toString(this.fConnection.getTimeout()));
            boolean isPwd = this.fConnection.isPasswordAuth();
            this.fPasswordButton.setSelection(isPwd);
            this.fPublicKeyButton.setSelection(!isPwd);
            if (isPwd) {
                this.fPasswordText.setText(this.fConnection.getPassword());
            } else {
                this.fPassphraseText.setText(this.fConnection.getPassphrase());
                this.fFileWidget.setLocationPath(this.fConnection.getKeyFile());
            }
        } else {
            String file;
            String passphrase;
            String password;
            String isPwd;
            String timeout;
            String port;
            String username;
            this.fConnectionName.setText(this.fInitialName);
            String host = this.fInitialAttributes.get("JSCH_ADDRESS_ATTR");
            if (host != null) {
                this.fHostText.setText(host);
            }
            if ((username = this.fInitialAttributes.get("JSCH_USERNAME_ATTR")) != null) {
                this.fUserText.setText(username);
            }
            if ((port = this.fInitialAttributes.get("JSCH_PORT_ATTR")) != null) {
                this.fPortText.setText(port);
            }
            if ((timeout = this.fInitialAttributes.get("JSCH_TIMEOUT_ATTR")) != null) {
                this.fTimeoutText.setText(timeout);
            }
            if ((isPwd = this.fInitialAttributes.get("JSCH_IS_PASSWORD_ATTR")) != null) {
                this.fPasswordButton.setSelection(Boolean.parseBoolean(isPwd));
            }
            if ((password = this.fInitialAttributes.get("JSCH_PASSWORD_ATTR")) != null) {
                this.fPasswordText.setText(password);
            }
            if ((passphrase = this.fInitialAttributes.get("JSCH_PASSPHRASE_ATTR")) != null) {
                this.fPassphraseText.setText(passphrase);
            }
            if ((file = this.fInitialAttributes.get("JSCH_KEYFILE_ATTR")) != null) {
                this.fFileWidget.setLocationPath(file);
            }
        }
    }

    private void registerListeners() {
        this.fConnectionName.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fHostText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fUserText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fFileWidget.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fPasswordText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fPassphraseText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fPortText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fTimeoutText.addModifyListener((ModifyListener)this.fDataModifyListener);
    }

    public void setAddress(String address) {
        this.fInitialAttributes.put("JSCH_ADDRESS_ATTR", address);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.fInitialAttributes.putAll(attributes);
    }

    public void setConnection(JSchConnectionWorkingCopy connection) {
        this.fConnection = connection;
    }

    public void setConnectionName(String name) {
        this.fInitialName = name;
    }

    public void setInvalidConnectionNames(Set<String> names) {
        this.fInvalidConnectionNames = names;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (complete) {
            this.storeValues();
        }
    }

    public void setPort(int port) {
        this.fInitialAttributes.put("JSCH_PORT_ATTR", Integer.toString(port));
    }

    public void setUsername(String username) {
        this.fInitialAttributes.put("JSCH_USERNAME_ATTR", username);
    }

    private void storeValues() {
        if (this.fConnection == null) {
            try {
                JSchConnection conn = (JSchConnection)this.fConnectionManager.newConnection(this.fConnectionName.getText().trim());
                this.fConnection = (JSchConnectionWorkingCopy)conn.getWorkingCopy();
            }
            catch (RemoteConnectionException e) {
                Activator.log((Throwable)e);
            }
        }
        if (this.fConnection != null) {
            if (!this.fConnection.getName().equals(this.fConnectionName.getText().trim())) {
                this.fConnection.setName(this.fConnectionName.getText().trim());
            }
            if (!this.fConnection.getAddress().equals(this.fHostText.getText().trim())) {
                this.fConnection.setAddress(this.fHostText.getText().trim());
            }
            if (!this.fConnection.getUsername().equals(this.fUserText.getText().trim())) {
                this.fConnection.setUsername(this.fUserText.getText().trim());
            }
            if (!this.fConnection.getPassword().equals(this.fPasswordText.getText().trim())) {
                this.fConnection.setPassword(this.fPasswordText.getText().trim());
            }
            if (!this.fConnection.getPassphrase().equals(this.fPassphraseText.getText().trim())) {
                this.fConnection.setPassphrase(this.fPassphraseText.getText().trim());
            }
            if (!this.fConnection.getKeyFile().equals(this.fFileWidget.getLocationPath())) {
                this.fConnection.setKeyFile(this.fFileWidget.getLocationPath());
            }
            if (this.fConnection.isPasswordAuth() != this.fPasswordButton.getSelection()) {
                this.fConnection.setIsPasswordAuth(this.fPasswordButton.getSelection());
            }
            int timeout = Integer.parseInt(this.fTimeoutText.getText().trim());
            if (this.fConnection.getTimeout() != timeout) {
                this.fConnection.setTimeout(timeout);
            }
            int port = Integer.parseInt(this.fPortText.getText().trim());
            if (this.fConnection.getPort() != port) {
                this.fConnection.setPort(port);
            }
        }
    }

    private void updateEnablement() {
        boolean isPasswordAuth = this.fPasswordButton.getSelection();
        this.fPasswordText.setEnabled(isPasswordAuth);
        this.fPassphraseText.setEnabled(!isPasswordAuth);
        this.fFileWidget.setEnabled(!isPasswordAuth);
    }

    private String validateAdvanced() {
        try {
            Integer.parseInt(this.fPortText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Messages.JSchNewConnectionPage_Port_is_not_valid;
        }
        try {
            Integer.parseInt(this.fTimeoutText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Messages.JSchNewConnectionPage_Timeout_is_not_valid;
        }
        return null;
    }

    private void validateFields() {
        String message = null;
        if (this.fConnectionName.getText().trim().length() == 0) {
            message = Messages.JSchNewConnectionPage_Please_enter_a_connection_name;
        } else if (this.isInvalidName(this.fConnectionName.getText().trim())) {
            message = Messages.JSchConnectionPage_A_connection_with_that_name_already_exists;
        } else if (this.fHostText.getText().trim().length() == 0) {
            message = Messages.JSchNewConnectionPage_Host_name_cannot_be_empty;
        } else if (this.fUserText.getText().trim().length() == 0) {
            message = Messages.JSchNewConnectionPage_User_name_cannot_be_empty;
        }
        if (message == null) {
            message = this.validatePasskey();
        }
        if (message == null) {
            message = this.validateAdvanced();
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private String validatePasskey() {
        if (!this.fPasswordButton.getSelection()) {
            if (this.fFileWidget.getLocationPath().trim().length() == 0) {
                return Messages.JSchNewConnectionPage_Private_key_path_cannot_be_empty;
            }
            File path = new File(this.fFileWidget.getLocationPath().trim());
            if (!path.exists()) {
                return Messages.JSchNewConnectionPage_Private_key_file_does_not_exist;
            }
            if (!path.isFile()) {
                return Messages.JSchNewConnectionPage_Private_key_file_is_invalid;
            }
            if (!path.canRead()) {
                return Messages.JSchNewConnectionPage_Private_key_file_cannot_be_read;
            }
        }
        return null;
    }

    private void setTextFieldWidthInChars(Text text, int chars) {
        text.setTextLimit(chars);
        Object data = text.getLayoutData();
        if (data instanceof GridData) {
            GC gc = new GC((Drawable)text);
            FontMetrics fm = gc.getFontMetrics();
            int width = chars * fm.getAverageCharWidth();
            gc.dispose();
            ((GridData)data).widthHint = width;
        }
    }

    private class DataModifyListener
    implements ModifyListener {
        private DataModifyListener() {
        }

        public synchronized void modifyText(ModifyEvent e) {
            JSchConnectionPage.this.validateFields();
            JSchConnectionPage.this.getContainer().updateButtons();
        }
    }
}

