/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PreferencesAdapter;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.jobs.IJobListener;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.launch.PLaunch;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.RMLaunchUtils;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.launch.rulesengine.ISynchronizationRule;
import org.eclipse.ptp.launch.rulesengine.RuleActionFactory;
import org.eclipse.ptp.launch.rulesengine.RuleFactory;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public abstract class AbstractParallelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private final IJobListener fJobListener = new JobListener();
    protected Map<String, JobSubmission> jobSubmissions = Collections.synchronizedMap(new HashMap());

    public static IRemoteFileManager getLocalFileManager(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServices localServices = RemoteServices.getLocalServices();
        IRemoteConnectionManager lconnMgr = localServices.getConnectionManager();
        IRemoteConnection lconn = lconnMgr.getConnection("Local");
        return lconn.getFileManager();
    }

    public static IRemoteFileManager getRemoteFileManager(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IRemoteConnection conn = RMLaunchUtils.getRemoteConnection(configuration, (IProgressMonitor)progress.newChild(5));
        if (conn != null) {
            if (!conn.isOpen()) {
                conn.open((IProgressMonitor)progress.newChild(5));
                if (!progress.isCanceled() && !conn.isOpen()) {
                    throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Connection_is_not_open));
                }
            }
            return conn.getFileManager();
        }
        return null;
    }

    protected void copyExecutable(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        boolean copyExecutable = LaunchUtils.getCopyExecutable((ILaunchConfiguration)configuration);
        if (copyExecutable) {
            String remotePath = LaunchUtils.getExecutablePath((ILaunchConfiguration)configuration);
            String localPath = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", null);
            if (localPath == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_1));
            }
            this.copyFileToRemoteHost(localPath, remotePath, configuration, monitor);
        }
    }

    protected void copyFileFromRemoteHost(String remotePath, String localPath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        IRemoteFileManager localFileManager = AbstractParallelLaunchConfigurationDelegate.getLocalFileManager(configuration);
        IRemoteFileManager remoteFileManager = AbstractParallelLaunchConfigurationDelegate.getRemoteFileManager(configuration, (IProgressMonitor)progress.newChild(5));
        if (progress.isCanceled()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
        }
        if (remoteFileManager == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_0));
        }
        IFileStore rres = remoteFileManager.getResource(remotePath);
        if (!rres.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Remote_resource_does_not_exist));
        }
        IFileStore lres = localFileManager.getResource(localPath);
        rres.copy(lres, 2, (IProgressMonitor)progress.newChild(5));
    }

    protected void copyFileToRemoteHost(String localPath, String remotePath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        IRemoteFileManager localFileManager = AbstractParallelLaunchConfigurationDelegate.getLocalFileManager(configuration);
        IRemoteFileManager remoteFileManager = AbstractParallelLaunchConfigurationDelegate.getRemoteFileManager(configuration, (IProgressMonitor)progress.newChild(5));
        if (progress.isCanceled()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
        }
        if (remoteFileManager == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_0));
        }
        IFileStore lres = localFileManager.getResource(localPath);
        if (!lres.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Local_resource_does_not_exist));
        }
        IFileStore rres = remoteFileManager.getResource(remotePath);
        lres.copy(rres, 2, (IProgressMonitor)progress.newChild(5));
    }

    protected abstract void doCleanupLaunch(IPLaunch var1);

    protected abstract void doCompleteJobLaunch(IPLaunch var1, IPDebugger var2);

    protected void doPostLaunchSynchronization(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_AFTER", false)) {
            List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
            RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, (IProgressMonitor)new NullProgressMonitor());
            for (Object ruleObj : rulesList) {
                ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
                if (!syncRule.isDownloadRule()) continue;
                IRuleAction action = ruleActFactory.getAction(syncRule);
                action.run();
            }
        }
    }

    protected void doPreLaunchSynchronization(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_BEFORE", false)) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, (IProgressMonitor)progress.newChild(10));
            List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
            for (Object ruleObj : rulesList) {
                ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
                if (!syncRule.isUploadRule()) continue;
                IRuleAction action = ruleActFactory.getAction(syncRule);
                action.run();
            }
        }
    }

    protected IPDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        return PTPDebugCorePlugin.getDefault().getDebugConfiguration(LaunchUtils.getDebuggerID((ILaunchConfiguration)config));
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PLaunch(configuration, mode, null);
    }

    protected ISynchronizationRule[] getSynchronizeRules(ILaunchConfiguration configuration) throws CoreException {
        List ruleStrings = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
        ArrayList<ISynchronizationRule> result = new ArrayList<ISynchronizationRule>();
        for (Object ruleObj : ruleStrings) {
            String element = (String)ruleObj;
            try {
                ISynchronizationRule rule = RuleFactory.createRuleFromString(element);
                result.add(rule);
            }
            catch (RuntimeException runtimeException) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Error_converting_rules));
            }
        }
        return result.toArray(new ISynchronizationRule[result.size()]);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                sourceLocator = PTPDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration config) throws CoreException {
        this.setDefaultSourceLocator(launch, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitJob(String mode, IPLaunch launch, IPDebugger debugger, IProgressMonitor progress) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progress, (int)50);
        ILaunchController control = RMLaunchUtils.getLaunchController(launch.getLaunchConfiguration());
        if (control == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Specified_resource_manager_not_found));
        }
        control.start((IProgressMonitor)subMon.newChild(10));
        if (!mode.equals("debug") && LaunchUtils.getSystemType((ILaunchConfiguration)launch.getLaunchConfiguration()) != null) {
            IMonitorControl monitor = MonitorControlManager.getInstance().getMonitorControl(control.getControlId());
            if (monitor == null) {
                if (this.switchPerspective("org.eclipse.ptp.rm.lml.ui.SystemMonitoringPerspective", Messages.AbstractParallelLaunchConfigurationDelegate_launchType1, "org.eclipse.ptp.launch.switch_to_monitoring_perspective", true)) {
                    monitor = MonitorControlManager.getInstance().createMonitorControl(control);
                    monitor.start((IProgressMonitor)subMon.newChild(10));
                }
            } else if (!monitor.isActive()) {
                if (this.switchPerspective("org.eclipse.ptp.rm.lml.ui.SystemMonitoringPerspective", Messages.AbstractParallelLaunchConfigurationDelegate_launchType2, "org.eclipse.ptp.launch.switch_to_monitoring_perspective", true)) {
                    monitor.start((IProgressMonitor)subMon.newChild(10));
                }
            } else {
                this.switchPerspective("org.eclipse.ptp.rm.lml.ui.SystemMonitoringPerspective", Messages.AbstractParallelLaunchConfigurationDelegate_launchType3, "org.eclipse.ptp.launch.switch_to_monitoring_perspective", false);
            }
        }
        JobManager.getInstance().addListener(control.getControlId(), this.fJobListener);
        String jobId = control.submitJob(launch.getLaunchConfiguration(), mode, (IProgressMonitor)subMon.newChild(10));
        if (subMon.isCanceled()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Launch_was_cancelled));
        }
        if (control.getJobStatus(jobId, (IProgressMonitor)subMon.newChild(10)).equals("UNDETERMINED")) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_UnableToDetermineJobStatus));
        }
        launch.setJobControl((IJobControl)control);
        launch.setJobId(jobId);
        JobSubmission jobSub = new JobSubmission(launch, control, debugger);
        Map<String, JobSubmission> map = this.jobSubmissions;
        synchronized (map) {
            this.jobSubmissions.put(jobId, jobSub);
        }
        jobSub.schedule();
    }

    protected boolean switchPerspective(final String perspectiveId, final String message, final String preferenceKey, final boolean alwaysDisplayMessage) {
        Display display;
        final boolean[] result = new boolean[]{false};
        if (perspectiveId != null && (display = Display.getDefault()) != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        if (!alwaysDisplayMessage && page.getPerspective().getId().equals(perspectiveId)) {
                            result[0] = true;
                            return;
                        }
                        PreferencesAdapter store = new PreferencesAdapter(PTPLaunchPlugin.getUniqueIdentifier());
                        boolean bl = result[0] = !store.getString("org.eclipse.ptp.launch.switch_to_monitoring_perspective").equals("never");
                        if (store.getString("org.eclipse.ptp.launch.switch_to_monitoring_perspective").equals("prompt")) {
                            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)display.getActiveShell(), (String)Messages.AbstractParallelLaunchConfigurationDelegate_ConfirmActions, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)preferenceKey);
                            boolean bl2 = result[0] = dialog.getReturnCode() == 2;
                        }
                        if (result[0]) {
                            try {
                                PlatformUI.getWorkbench().showPerspective(perspectiveId, window);
                            }
                            catch (WorkbenchException workbenchException) {}
                        }
                    }
                }
            });
        }
        return result[0];
    }

    protected IPath verifyDebuggerPath(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String dbgPath = LaunchUtils.getDebuggerExePath((ILaunchConfiguration)configuration);
        if (dbgPath == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_debuggerPathNotSpecified));
        }
        try {
            return this.verifyResource(dbgPath, configuration, monitor);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Debugger_path_not_found, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    protected IPath verifyExecutablePath(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (LaunchUtils.getCopyExecutable((ILaunchConfiguration)configuration)) {
            return new Path(LaunchUtils.getExecutablePath((ILaunchConfiguration)configuration));
        }
        String exePath = LaunchUtils.getExecutablePath((ILaunchConfiguration)configuration);
        try {
            return this.verifyResource(exePath, configuration, monitor);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Application_file_does_not_exist, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    protected boolean verifyLaunchAttributes(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        IPath path = this.verifyExecutablePath(configuration, (IProgressMonitor)progress.newChild(10));
        if (progress.isCanceled() || path == null) {
            return false;
        }
        String workPath = LaunchUtils.getWorkingDirectory((ILaunchConfiguration)configuration);
        if (workPath != null) {
            path = this.verifyResource(workPath, configuration, (IProgressMonitor)progress.newChild(10));
            if (progress.isCanceled() || path == null) {
                return false;
            }
        }
        return true;
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        String proName = LaunchUtils.getProjectName((ILaunchConfiguration)configuration);
        if (proName == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Project_not_specified));
        }
        IProject project = LaunchUtils.getProject((String)proName);
        if (project == null || !project.exists() || !project.isOpen()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Project_does_not_exist_or_is_not_a_project));
        }
        return project;
    }

    protected IPath verifyResource(String path, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IRemoteFileManager fileManager = AbstractParallelLaunchConfigurationDelegate.getRemoteFileManager(configuration, (IProgressMonitor)progress.newChild(5));
        if (!monitor.isCanceled()) {
            if (fileManager == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_unableToObtainConnectionInfo));
            }
            boolean exists = fileManager.getResource(path).fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists();
            if (!progress.isCanceled()) {
                if (!exists) {
                    throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.AbstractParallelLaunchConfigurationDelegate_Path_not_found, (Object[])new Object[]{path})));
                }
                return new Path(path);
            }
        }
        return null;
    }

    protected IPath verifyWorkDirectory(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String workPath = LaunchUtils.getWorkingDirectory((ILaunchConfiguration)configuration);
        if (workPath == null) {
            return this.verifyExecutablePath(configuration, monitor).removeLastSegments(1);
        }
        return this.verifyResource(workPath, configuration, monitor);
    }

    private final class JobListener
    implements IJobListener {
        private JobListener() {
        }

        public void jobAdded(IJobStatus status) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobChanged(IJobStatus status) {
            JobSubmission jobSub;
            Map<String, JobSubmission> map = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions;
            synchronized (map) {
                jobSub = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.get(status.getJobId());
            }
            if (jobSub != null) {
                jobSub.statusChanged();
            }
        }
    }

    private class JobSubmission
    extends Job {
        private final IPLaunch fLaunch;
        private final IPDebugger fDebugger;
        private final ILaunchController fLaunchControl;
        private final ReentrantLock fSubLock;
        private final Condition fSubCondition;

        public JobSubmission(IPLaunch launch, ILaunchController control, IPDebugger debugger) {
            super(launch.getJobId());
            this.fSubLock = new ReentrantLock();
            this.fSubCondition = this.fSubLock.newCondition();
            this.fLaunch = launch;
            this.fLaunchControl = control;
            this.fDebugger = debugger;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            String jobId = this.fLaunch.getJobId();
            try {
                IJobStatus status = this.waitForStatusChange(jobId, "SUBMITTED", (IProgressMonitor)subMon.newChild(50));
                if (!subMon.isCanceled()) {
                    if (!status.getStateDetail().equals("CANCELED")) {
                        AbstractParallelLaunchConfigurationDelegate.this.doCompleteJobLaunch(this.fLaunch, this.fDebugger);
                    }
                    if (!status.getState().equals("COMPLETED")) {
                        status = this.waitForStatusChange(jobId, "RUNNING", (IProgressMonitor)subMon.newChild(50));
                    }
                    if (!subMon.isCanceled() && !status.getStateDetail().equals("CANCELED")) {
                        AbstractParallelLaunchConfigurationDelegate.this.doPostLaunchSynchronization(this.fLaunch.getLaunchConfiguration());
                    }
                }
            }
            catch (CoreException e) {
                PTPLaunchPlugin.log(e);
            }
            AbstractParallelLaunchConfigurationDelegate.this.doCleanupLaunch(this.fLaunch);
            Map<String, JobSubmission> map = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions;
            synchronized (map) {
                AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.remove(jobId);
                if (AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.size() == 0) {
                    JobManager.getInstance().removeListener(AbstractParallelLaunchConfigurationDelegate.this.fJobListener);
                }
            }
            return Status.OK_STATUS;
        }

        public void statusChanged() {
            this.fSubLock.lock();
            try {
                this.fSubCondition.signalAll();
            }
            finally {
                this.fSubLock.unlock();
            }
        }

        private IJobStatus waitForStatusChange(String jobId, String jobStatus, IProgressMonitor monitor) throws CoreException {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IJobStatus status = this.fLaunchControl.getJobStatus(jobId, (IProgressMonitor)subMon.newChild(10));
            while (status.getState().equals(jobStatus) && !subMon.isCanceled()) {
                block6: {
                    this.fSubLock.lock();
                    try {
                        try {
                            this.fSubCondition.await(1000L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            this.fSubLock.unlock();
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        this.fSubLock.unlock();
                        throw throwable;
                    }
                    this.fSubLock.unlock();
                }
                status = this.fLaunchControl.getJobStatus(jobId, (IProgressMonitor)subMon.newChild(10));
                subMon.setWorkRemaining(100);
            }
            subMon.worked(100);
            return status;
        }
    }
}

