/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ImageManager {
    private static ImageRegistry imageRegistry = null;

    public static ImageDescriptor createImageDescriptor(URL iconURL, String key, String name) {
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)ImageManager.getIconURL(iconURL, name));
            ImageManager.addImageDescriptor(key, imageDescriptor);
            return imageDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(String key) {
        return ImageManager.getImageRegistry().get(key);
    }

    private static void addImageDescriptor(String key, ImageDescriptor imageDescriptor) {
        ImageManager.getImageRegistry().put(key, imageDescriptor);
    }

    private static URL getIconURL(URL baseURL, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(baseURL, name);
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }
}

