/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.ptp.internal.rdt.core.model.FunctionDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.FunctionInfo;
import org.eclipse.ptp.internal.rdt.core.model.MethodInfo;
import org.eclipse.ptp.internal.rdt.core.model.Parent;

public class MethodDeclaration
extends FunctionDeclaration
implements IMethodDeclaration {
    private static final long serialVersionUID = 1L;
    protected ASTAccessVisibility fVisibility;
    protected boolean fIsConstructor;
    protected boolean fIsDestructor;
    protected boolean fIsPureVirtual;
    protected boolean fIsVirtual;
    private boolean fIsInline;
    private boolean fIsFriend;

    public MethodDeclaration(Parent parent, String functionName) {
        super(parent, 71, functionName);
    }

    protected MethodDeclaration(Parent parent, int kind, String name) {
        super(parent, kind, name);
    }

    public MethodDeclaration(Parent parent, IMethodDeclaration element) throws CModelException {
        super(parent, (IFunctionDeclaration)element);
        this.fIsConstructor = element.isConstructor();
        this.fIsDestructor = element.isDestructor();
        this.fIsPureVirtual = element.isPureVirtual();
        this.fIsVirtual = element.isVirtual();
        this.fIsInline = element.isInline();
        this.fIsFriend = element.isFriend();
    }

    protected MethodDeclaration(Parent parent, int type, ICPPMethod method) throws DOMException {
        super(parent, type, (IFunction)method);
        this.fVisibility = this.getVisibility((IBinding)method);
        this.fIsConstructor = method instanceof ICPPConstructor;
        if (!this.fIsConstructor) {
            this.fIsDestructor = method.isDestructor();
        }
        this.fIsVirtual = method.isVirtual();
        this.fIsInline = method.isInline();
    }

    public MethodDeclaration(Parent parent, ICPPMethod binding) throws DOMException {
        this(parent, 71, binding);
    }

    public boolean isConstructor() throws CModelException {
        return this.fIsConstructor;
    }

    public boolean isDestructor() throws CModelException {
        return this.fIsDestructor;
    }

    public boolean isFriend() throws CModelException {
        return this.fIsFriend;
    }

    public boolean isInline() throws CModelException {
        return this.fIsInline;
    }

    public boolean isOperator() throws CModelException {
        return false;
    }

    public boolean isPureVirtual() throws CModelException {
        return this.fIsPureVirtual;
    }

    public boolean isVirtual() throws CModelException {
        return this.fIsVirtual;
    }

    public ASTAccessVisibility getVisibility() throws CModelException {
        return this.fVisibility;
    }

    @Override
    public void setConst(boolean isConst) {
        this.fIsConst = isConst;
    }

    @Override
    public FunctionInfo getElementInfo() {
        if (this.fInfo == null) {
            this.fInfo = new MethodInfo(this);
        }
        return (FunctionInfo)this.fInfo;
    }

    public MethodInfo getMethodInfo() {
        return (MethodInfo)this.getElementInfo();
    }

    public void setConstructor(boolean isConstructor) {
        this.fIsConstructor = isConstructor;
    }

    public void setDestructor(boolean isDestructor) {
        this.fIsDestructor = isDestructor;
    }

    public void setVirtual(boolean virtual) {
        this.fIsVirtual = virtual;
    }

    public void setVisibility(ASTAccessVisibility visibility) {
        this.fVisibility = visibility;
    }

    public void setPureVirtual(boolean isPureVirtual) {
        this.fIsPureVirtual = isPureVirtual;
    }

    public void setInline(boolean isInline) {
        this.fIsInline = isInline;
    }

    public void setFriend(boolean isFriend) {
        this.fIsFriend = isFriend;
    }

    public void setVolatile(boolean isVolatile) {
        this.fIsVolatile = isVolatile;
    }
}

