/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.make.core.scannerconfig.offline;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.internal.rdt.make.core.scannerconfig.offline.OfflineBuildOutputParserUtility;
import org.eclipse.ptp.internal.rdt.make.core.scannerconfig.offline.OfflineTraceUtil;

public class OfflineXLCBuildOutputParser
implements IScannerInfoConsoleParser {
    List<String> fileExtensionList;
    protected static final String[] COMPILER_INVOCATION = new String[]{"xlc", "xlC"};
    protected static final String DASHIDASH = "-I-";
    protected static final String DASHI = "-I";
    protected static final String DASHD = "-D";
    protected IScannerInfoCollector fCollector;
    protected IPath fWorkingDir;
    protected OfflineBuildOutputParserUtility fUtility;
    protected boolean fBMultiline = false;
    protected String fSMultiline = "";
    protected String[] fCompilerCommands = new String[]{"xlc", "xlC"};

    protected IScannerInfoCollector getCollector() {
        return this.fCollector;
    }

    protected String[] computeCompilerCommands() {
        return COMPILER_INVOCATION;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        int lineBreakPos = line.length() - 1;
        char[] lineChars = line.toCharArray();
        while (lineBreakPos >= 0 && Character.isWhitespace(lineChars[lineBreakPos])) {
            --lineBreakPos;
        }
        if (lineBreakPos >= 0 && (lineChars[lineBreakPos] != '\\' || lineBreakPos > 0 && lineChars[lineBreakPos - 1] == '\\')) {
            lineBreakPos = -1;
        }
        if (lineBreakPos >= 0) {
            this.fSMultiline = String.valueOf(this.fSMultiline) + line.substring(0, lineBreakPos);
            this.fBMultiline = true;
            return rc;
        }
        if (this.fBMultiline) {
            line = String.valueOf(this.fSMultiline) + line;
            this.fBMultiline = false;
            this.fSMultiline = "";
        }
        line = line.trim();
        try {
            OfflineTraceUtil.outputTrace("XLCBuildOutputParser parsing line: [", line, "]");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        int firstColon = line.indexOf(58);
        String make = line.substring(0, firstColon + 1);
        if (firstColon != -1 && make.indexOf("make") != -1) {
            boolean enter = false;
            String msg = line.substring(firstColon + 1).trim();
            enter = msg.startsWith("Entering directory");
            if (enter || msg.startsWith("Leaving directory")) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    if (this.getUtility() != null) {
                        this.getUtility().changeMakeDirectory(dir, this.getDirectoryLevel(line), enter);
                    }
                    return rc;
                }
            }
        }
        return this.processSingleLine(line.trim());
    }

    protected synchronized OfflineBuildOutputParserUtility getUtility() {
        return this.fUtility;
    }

    protected int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return num;
    }

    protected String[][] tokenize(String line, boolean escapeInsideDoubleQuotes) {
        ArrayList<String[]> commands = new ArrayList<String[]>();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        char[] input = line.toCharArray();
        boolean nextEscaped = false;
        char currentQuote = '\u0000';
        int i = 0;
        while (i < input.length) {
            char c = input[i];
            boolean escaped = nextEscaped;
            nextEscaped = false;
            if (currentQuote != '\u0000') {
                if (c == currentQuote) {
                    if (escaped) {
                        token.append(c);
                    } else {
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = '\u0000';
                    }
                } else if (escapeInsideDoubleQuotes && currentQuote == '\"' && c == '\\') {
                    boolean bl = nextEscaped = !escaped;
                    if (escaped) {
                        token.append(c);
                    }
                } else {
                    if (escaped) {
                        token.append('\\');
                    }
                    token.append(c);
                }
            } else {
                switch (c) {
                    case '\\': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        nextEscaped = true;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '`': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = c;
                        break;
                    }
                    case ';': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    case '&': 
                    case '|': {
                        if (escaped || i + 1 >= input.length || input[i + 1] != c) {
                            token.append(c);
                            break;
                        }
                        ++i;
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    default: {
                        if (Character.isWhitespace(c)) {
                            if (escaped) {
                                token.append(c);
                                break;
                            }
                            this.endToken(token, tokens);
                            break;
                        }
                        if (escaped) {
                            token.append('\\');
                        }
                        token.append(c);
                    }
                }
            }
            ++i;
        }
        this.endCommand(token, tokens, commands);
        return (String[][])commands.toArray((T[])new String[commands.size()][]);
    }

    protected void endCommand(StringBuffer token, ArrayList<String> tokens, ArrayList<String[]> commands) {
        this.endToken(token, tokens);
        if (!tokens.isEmpty()) {
            commands.add(tokens.toArray(new String[tokens.size()]));
            tokens.clear();
        }
    }

    protected void endToken(StringBuffer token, ArrayList<String> tokens) {
        if (token.length() > 0) {
            tokens.add(token.toString());
            token.setLength(0);
        }
    }

    protected boolean processSingleLine(String line) {
        boolean rc = false;
        String[][] tokens = this.tokenize(line, true);
        int i = 0;
        while (i < tokens.length) {
            String[] command = tokens[i];
            if (this.processCommand(command)) {
                rc = true;
            } else {
                int j = 0;
                while (j < command.length) {
                    String[][] subtokens = this.tokenize(command[j], true);
                    int k = 0;
                    while (k < subtokens.length) {
                        String[] subcommand = subtokens[k];
                        if (subcommand.length > 1 && this.processCommand(subcommand)) {
                            rc = true;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return rc;
    }

    protected int findCompilerInvocation(String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].toLowerCase();
            int searchFromOffset = Math.max(token.lastIndexOf(47), token.lastIndexOf(92)) + 1;
            int j = 0;
            while (j < this.fCompilerCommands.length) {
                if (token.indexOf(this.fCompilerCommands[j], searchFromOffset) != -1) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public OfflineXLCBuildOutputParser(String baseDirectory, String buildDirectory, IScannerInfoCollector collector, List<String> fileExtensionList) {
        this.fUtility = buildDirectory != null && buildDirectory.length() > 0 ? new OfflineBuildOutputParserUtility(baseDirectory, buildDirectory) : new OfflineBuildOutputParserUtility(baseDirectory, null);
        this.fileExtensionList = fileExtensionList;
        this.fCollector = collector;
    }

    protected List<String> getFileExtensionsList() {
        return this.fileExtensionList;
    }

    protected String[] getFileExtensions() {
        return this.getFileExtensionsList().toArray(new String[0]);
    }

    protected boolean processCommand(String[] tokens) {
        String filePath;
        int extensionsIndex;
        int compilerInvocationIndex;
        block22: {
            block21: {
                int k;
                block20: {
                    compilerInvocationIndex = this.findCompilerInvocation(tokens);
                    if (compilerInvocationIndex >= 0) break block20;
                    return false;
                }
                extensionsIndex = -1;
                boolean found = false;
                filePath = null;
                int automakeSrcIndex = this.findAutoMakeSourceIndex(tokens);
                if (automakeSrcIndex != -1 && (k = (filePath = this.getAutoMakeSourcePath(tokens[automakeSrcIndex])).lastIndexOf(46)) != -1 && filePath.length() - k < 5) {
                    String fileExtension = filePath.substring(k + 1);
                    extensionsIndex = this.getFileExtensionsList().indexOf(fileExtension);
                    if (extensionsIndex != -1) {
                        found = true;
                    }
                }
                if (!found) {
                    int i = compilerInvocationIndex + 1;
                    while (i < tokens.length) {
                        String token = tokens[i];
                        int k2 = token.lastIndexOf(46);
                        if (k2 != -1 && token.length() - k2 < 5) {
                            String fileExtension = token.substring(k2 + 1);
                            extensionsIndex = this.getFileExtensionsList().indexOf(fileExtension);
                            if (extensionsIndex != -1) {
                                filePath = token;
                                found = true;
                                break;
                            }
                        }
                        ++i;
                    }
                }
                if (found) break block21;
                OfflineTraceUtil.outputTrace("Error identifying file name :1", tokens, OfflineTraceUtil.EOL);
                return false;
            }
            if (filePath.indexOf(this.getFileExtensions()[extensionsIndex]) != -1) break block22;
            OfflineTraceUtil.outputTrace("Error identifying file name :2", tokens, OfflineTraceUtil.EOL);
            return false;
        }
        try {
            if (this.getUtility() != null) {
                IPath pFilePath = this.fUtility.getAbsolutePath(filePath);
                String shortFileName = pFilePath.removeFileExtension().lastSegment();
                int i = compilerInvocationIndex + 1;
                while (i < tokens.length) {
                    String token = tokens[i];
                    if (token.equals("-include")) {
                        ++i;
                    } else if (token.equals("-imacros")) {
                        ++i;
                    } else if (token.equals(filePath)) {
                        tokens[i] = "LONG_NAME";
                    } else if (token.startsWith(shortFileName)) {
                        tokens[i] = token.replaceFirst(shortFileName, "SHORT_NAME");
                    }
                    ++i;
                }
                File file = new File(pFilePath.toOSString());
                CCommandDSC cmd = this.getUtility().getNewCCommandDSC(tokens, compilerInvocationIndex, extensionsIndex > 0);
                CopyOnWriteArrayList<CCommandDSC> cmdList = new CopyOnWriteArrayList<CCommandDSC>();
                cmdList.add(cmd);
                HashMap<ScannerInfoTypes, CopyOnWriteArrayList<CCommandDSC>> sc = new HashMap<ScannerInfoTypes, CopyOnWriteArrayList<CCommandDSC>>(1);
                sc.put(ScannerInfoTypes.COMPILER_COMMAND, cmdList);
                this.getCollector().contributeToScannerConfig((Object)file, sc);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String getAutoMakeSourcePath(String string) {
        int firstQuoteIndex = string.indexOf(39);
        int lastQuoteIndex = string.lastIndexOf(39);
        if (firstQuoteIndex != -1 && lastQuoteIndex != -1) {
            return string.substring(firstQuoteIndex, lastQuoteIndex);
        }
        int equalsIndex = string.indexOf(61);
        if (equalsIndex != -1 && equalsIndex < string.length()) {
            return string.substring(equalsIndex + 1);
        }
        return null;
    }

    protected int findAutoMakeSourceIndex(String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].toLowerCase();
            if (token.indexOf("source=") != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void shutdown() {
    }

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
    }
}

