/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.core.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.ISnapshotInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.DomainInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.TraceInfo;

public class SessionInfo
extends TraceInfo
implements ISessionInfo {
    private TraceSessionState fState = TraceSessionState.INACTIVE;
    private String fSessionPath = "";
    private final List<IDomainInfo> fDomains = new ArrayList<IDomainInfo>();
    private boolean fIsStreamedTrace = false;
    private boolean fIsSnapshot = false;
    private ISnapshotInfo fSnapshotInfo = null;
    private String fNetworkUrl = null;
    private String fControlUrl = null;
    private String fDataUrl = null;

    public SessionInfo(String name) {
        super(name);
    }

    public SessionInfo(SessionInfo other) {
        super(other);
        this.fState = other.fState;
        this.fSessionPath = other.fSessionPath;
        this.fIsStreamedTrace = other.fIsStreamedTrace;
        this.fIsSnapshot = other.fIsSnapshot;
        this.fSnapshotInfo = other.fSnapshotInfo;
        this.fNetworkUrl = other.fNetworkUrl;
        this.fControlUrl = other.fControlUrl;
        this.fDataUrl = other.fDataUrl;
        for (IDomainInfo domain : other.fDomains) {
            if (domain instanceof DomainInfo) {
                this.fDomains.add(new DomainInfo((DomainInfo)domain));
                continue;
            }
            this.fDomains.add(domain);
        }
    }

    @Override
    public TraceSessionState getSessionState() {
        return this.fState;
    }

    @Override
    public void setSessionState(TraceSessionState state) {
        this.fState = state;
    }

    @Override
    public void setSessionState(String stateName) {
        if (TraceSessionState.INACTIVE.getInName().equals(stateName)) {
            this.fState = TraceSessionState.INACTIVE;
        } else if (TraceSessionState.ACTIVE.getInName().equals(stateName)) {
            this.fState = TraceSessionState.ACTIVE;
        }
    }

    @Override
    public String getSessionPath() {
        if (this.isSnapshotSession() && this.fSnapshotInfo != null) {
            return this.fSnapshotInfo.getSnapshotPath();
        }
        return this.fSessionPath;
    }

    @Override
    public void setSessionPath(String path) {
        this.fSessionPath = path;
    }

    @Override
    public IDomainInfo[] getDomains() {
        return this.fDomains.toArray(new IDomainInfo[this.fDomains.size()]);
    }

    @Override
    public void setDomains(List<IDomainInfo> domains) {
        this.fDomains.clear();
        for (IDomainInfo domainInfo : domains) {
            this.fDomains.add(domainInfo);
        }
    }

    @Override
    public boolean isStreamedTrace() {
        return this.fIsStreamedTrace;
    }

    @Override
    public void setStreamedTrace(boolean isStreamedTrace) {
        this.fIsStreamedTrace = isStreamedTrace;
    }

    @Override
    public boolean isSnapshotSession() {
        return this.fIsSnapshot || this.fSnapshotInfo != null;
    }

    @Override
    public void setSnapshot(boolean isSnapshot) {
        this.fIsSnapshot = isSnapshot;
    }

    @Override
    public ISnapshotInfo getSnapshotInfo() {
        return this.fSnapshotInfo;
    }

    @Override
    public void setSnapshotInfo(ISnapshotInfo info) {
        this.fSnapshotInfo = info;
    }

    @Override
    public void addDomain(IDomainInfo domainInfo) {
        this.fDomains.add(domainInfo);
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[SessionInfo(");
        output.append(super.toString());
        output.append(",Path=");
        output.append(this.getSessionPath());
        output.append(",State=");
        output.append((Object)this.fState);
        output.append(",isStreamedTrace=");
        output.append(this.fIsStreamedTrace);
        output.append(",isSnapshot=");
        output.append(this.fIsSnapshot);
        if (this.fSnapshotInfo != null) {
            output.append(",snapshotInfo=");
            output.append(this.fSnapshotInfo.toString());
        }
        output.append(",Domains=");
        for (IDomainInfo domain : this.fDomains) {
            output.append(domain.toString());
        }
        output.append(",NetworkUrl=");
        output.append(this.getNetworkUrl());
        output.append(",ControlUrl=");
        output.append(this.getControlUrl());
        output.append(",DataUrl=");
        output.append(this.getDataUrl());
        output.append(")]");
        return output.toString();
    }

    @Override
    public String getNetworkUrl() {
        return this.fNetworkUrl;
    }

    @Override
    public void setNetworkUrl(String networkUrl) {
        this.fNetworkUrl = networkUrl;
    }

    @Override
    public String getControlUrl() {
        return this.fControlUrl;
    }

    @Override
    public void setControlUrl(String controlUrl) {
        this.fControlUrl = controlUrl;
    }

    @Override
    public void setDataUrl(String datalUrl) {
        this.fDataUrl = datalUrl;
    }

    @Override
    public String getDataUrl() {
        return this.fDataUrl;
    }
}

