/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.core.relayd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFStream;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInput;
import org.eclipse.linuxtools.ctf.core.trace.Metadata;
import org.eclipse.linuxtools.internal.lttng2.control.core.Activator;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.ILttngRelaydConnector;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.LttngRelaydConnectorFactory;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.AttachSessionResponse;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.SessionResponse;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.StreamResponse;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.TracePacketResponse;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

public class LttngRelaydConsumer {
    private final Job fConsumerJob;
    private final String fAddress;
    private final int fPort;
    private final int fSession;
    private final CtfTmfTrace fCtfTrace;
    private final Map<Long, File> fStreams = new TreeMap<Long, File>();

    public LttngRelaydConsumer(String address, int port, int session, final CtfTmfTrace ctfTrace) {
        this.fAddress = address;
        this.fPort = port;
        this.fSession = session;
        this.fCtfTrace = ctfTrace;
        for (CTFStream s : this.fCtfTrace.getCTFTrace().getStreams()) {
            for (CTFStreamInput si : s.getStreamInputs()) {
                this.fStreams.put(si.getStream().getId(), new File(String.valueOf(si.getStream().getTrace().getPath()) + si.getFilename()));
            }
        }
        this.fConsumerJob = new Job("RelayD consumer"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try {
                        Socket connection = new Socket(LttngRelaydConsumer.this.fAddress, LttngRelaydConsumer.this.fPort);
                        try {
                            try (ILttngRelaydConnector relayd = LttngRelaydConnectorFactory.getNewConnector(connection);){
                                List<SessionResponse> sessions = relayd.getSessions();
                                AttachSessionResponse attachedSession = relayd.attachToSession(sessions.get(LttngRelaydConsumer.this.fSession));
                                while (!monitor.isCanceled()) {
                                    List<StreamResponse> attachedStreams = attachedSession.getStreamList();
                                    for (StreamResponse stream : attachedStreams) {
                                        TracePacketResponse packet = relayd.getNextPacket(stream);
                                        if ((packet.getFlags() & 2) == 2) {
                                            Iterable<StreamResponse> newStreams = relayd.getNewStreams();
                                            for (StreamResponse streamToAdd : newStreams) {
                                                File f = new File(String.valueOf(LttngRelaydConsumer.this.fCtfTrace.getPath()) + File.separator + streamToAdd.getPathName() + streamToAdd.getChannelName());
                                                f.setLastModified(System.currentTimeMillis());
                                                LttngRelaydConsumer.this.fStreams.put(streamToAdd.getId(), f);
                                                LttngRelaydConsumer.this.fCtfTrace.getCTFTrace().addStream(streamToAdd.getId(), f);
                                            }
                                        }
                                        if ((packet.getFlags() & 1) == 1) {
                                            String metaData = relayd.getMetadata(attachedSession);
                                            new Metadata(ctfTrace.getCTFTrace()).parseTextFragment(metaData);
                                        }
                                        Throwable throwable2 = null;
                                        Object var13_18 = null;
                                        try (FileOutputStream fos = new FileOutputStream((File)LttngRelaydConsumer.this.fStreams.get(stream.getId()), true);){
                                            fos.write(packet.getData());
                                            monitor.worked(1);
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                                throw throwable2;
                                            } else {
                                                if (throwable2 == throwable3) throw throwable2;
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                }
                            }
                            if (connection == null) return null;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            if (connection == null) throw throwable;
                            connection.close();
                            throw throwable;
                        }
                        connection.close();
                        return null;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                            throw throwable;
                        } else {
                            if (throwable == throwable5) throw throwable;
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CTFReaderException e) {
                    Activator.getDefault().logError("Error during live trace reading", e);
                }
                return null;
            }
        };
        this.fConsumerJob.schedule();
    }
}

