/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class VirtualFile
extends VirtualResource
implements IVirtualFile {
    private IFile underlyingFile;

    public VirtualFile(IProject aComponentProject, IPath aRuntimePath) {
        super(aComponentProject, aRuntimePath);
    }

    public VirtualFile(IProject aComponentProject, IPath aRuntimePath, IFile underlyingFile) {
        super(aComponentProject, aRuntimePath);
        this.underlyingFile = underlyingFile;
    }

    public void createLink(IPath aProjectRelativeLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            IFile resource = this.getProject().getFile(aProjectRelativeLocation);
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            ResourceTreeRoot root = ResourceTreeRoot.getDeployResourceTreeRoot(component);
            ComponentResource[] resources = root.findModuleResources(this.getRuntimePath(), 0);
            if (resources.length == 0) {
                ComponentResource componentResource = moduleCore.createWorkbenchModuleResource((IResource)resource);
                componentResource.setRuntimePath(this.getRuntimePath());
                component.getResources().add((Object)componentResource);
            } else {
                boolean foundMapping = false;
                int resourceIndx = 0;
                while (resourceIndx < resources.length && !foundMapping) {
                    if (aProjectRelativeLocation.equals((Object)resources[resourceIndx].getSourcePath())) {
                        foundMapping = true;
                    }
                    ++resourceIndx;
                }
                if (!foundMapping) {
                    ComponentResource componentResource = moduleCore.createWorkbenchModuleResource((IResource)resource);
                    componentResource.setRuntimePath(this.getRuntimePath());
                    component.getResources().add((Object)componentResource);
                }
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(monitor);
                moduleCore.dispose();
            }
        }
    }

    public int getType() {
        return 16;
    }

    public IResource getUnderlyingResource() {
        return this.getUnderlyingFile();
    }

    public IResource[] getUnderlyingResources() {
        return this.getUnderlyingFiles();
    }

    public IFile getUnderlyingFile() {
        if (this.underlyingFile == null) {
            this.underlyingFile = this.getProject().getFile(this.getProjectRelativePath());
        }
        return this.underlyingFile;
    }

    public IFile[] getUnderlyingFiles() {
        IPath[] paths = this.getProjectRelativePaths();
        ArrayList<IFile> result = new ArrayList<IFile>();
        int i = 0;
        while (i < paths.length) {
            IFile file = this.getProject().getFile(paths[i]);
            if (file != null && file.exists() && !result.contains(file)) {
                result.add(file);
            }
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    protected void doDeleteMetaModel(int updateFlags, IProgressMonitor monitor) {
    }

    protected void doDeleteRealResources(int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public Object getAdapter(Class adapter) {
        if (File.class.equals((Object)adapter)) {
            IFile file = this.getUnderlyingFile();
            return file.getLocation().toFile();
        }
        if (IFile.class.equals((Object)adapter)) {
            return this.getUnderlyingFile();
        }
        if (IVirtualFile.class.equals((Object)adapter)) {
            return this;
        }
        if (IVirtualResource.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }
}

