/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.eclipse.mylyn.wikitext.ui.editor.AbstractWikiTextSourceEditorOutline;
import org.eclipse.mylyn.wikitext.ui.editor.DefaultWikiTextSourceEditorOutline;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewer;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.ui.editor.WikiTextDocumentProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class WikiTextSourceEditor
extends TextEditor
implements IShowInSource,
IShowInTarget {
    private static final String EDITOR_SOURCE_VIEWER = "org.eclipse.mylyn.wikitext.ui.editor.sourceViewer";
    public static final String CONTEXT = "org.eclipse.mylyn.wikitext.ui.editor.markupSourceContext";
    public static final int PROP_OUTLINE = 0x10000001;
    public static final int PROP_OUTLINE_LOCATION = 0x10000002;
    private MarkupLanguage markupLanguage;
    private MarkupSourceViewer viewer;
    private MarkupSourceViewerConfiguration sourceViewerConfiguration;
    private boolean outlineDirty = true;
    private int documentGeneration = 0;
    private IDocument document;
    private IDocumentListener documentListener;
    private IDocumentPartitioningListener documentPartitioningListener;
    private boolean updateJobScheduled = false;
    private UIJob updateOutlineJob;
    private OutlineItem outlineModel;
    private OutlineItem outlineLocation;
    private OutlineParser outlineParser;
    private AbstractWikiTextSourceEditorOutline outlinePage;

    public void setDocumentProvider(IDocumentProvider provider) {
        if (provider instanceof WikiTextDocumentProvider) {
            ((WikiTextDocumentProvider)provider).setMarkupLanguage(this.getMarkupLanguage());
        }
        super.setDocumentProvider(provider);
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        this.sourceViewerConfiguration = (MarkupSourceViewerConfiguration)configuration;
        super.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        if (this.getMarkupLanguage() == null) {
            this.setMarkupLanguage(ServiceLocator.getInstance().getMarkupLanguage("Textile"));
        }
        this.viewer = this.createMarkupSourceViewer(parent, ruler, styles);
        IFocusService focusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        if (focusService != null) {
            focusService.addFocusTracker((Control)this.viewer.getTextWidget(), EDITOR_SOURCE_VIEWER);
        }
        this.viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.getMarkupLanguage());
        this.viewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)this.viewer);
        this.viewer.getTextWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WikiTextSourceEditor.this.detectOutlineLocationChanged();
            }
        });
        this.viewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (this.isRelevantKeyCode(e.keyCode)) {
                    WikiTextSourceEditor.this.detectOutlineLocationChanged();
                }
            }

            private boolean isRelevantKeyCode(int keyCode) {
                switch (keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.viewer.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                WikiTextSourceEditor.this.detectOutlineLocationChanged();
            }
        });
        this.getSourceViewerDecorationSupport((ISourceViewer)this.viewer);
        this.updateDocument();
        return this.viewer;
    }

    protected MarkupSourceViewer createMarkupSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new MarkupSourceViewer(parent, ruler, styles | 0x40, this.getMarkupLanguage());
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        IDocument document;
        IDocumentPartitioner partitioner;
        this.markupLanguage = markupLanguage;
        if (this.markupLanguage instanceof AbstractMarkupLanguage) {
            ((AbstractMarkupLanguage)this.markupLanguage).setEnableMacros(false);
        }
        this.sourceViewerConfiguration.setMarkupLanguage(markupLanguage);
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof WikiTextDocumentProvider) {
            ((WikiTextDocumentProvider)documentProvider).setMarkupLanguage(markupLanguage);
        }
        if (this.getEditorInput() != null && (partitioner = (document = documentProvider.getDocument((Object)this.getEditorInput())).getDocumentPartitioner()) instanceof FastMarkupPartitioner) {
            FastMarkupPartitioner fastMarkupPartitioner = (FastMarkupPartitioner)partitioner;
            fastMarkupPartitioner.setMarkupLanguage(markupLanguage);
        }
        if (this.viewer != null) {
            this.viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.getMarkupLanguage());
        }
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().invalidateTextPresentation();
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setHelpContextId(CONTEXT);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new MarkupSourceViewerConfiguration(this.getPreferenceStore()));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext(CONTEXT);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null || this.outlinePage.getControl() == null || this.outlinePage.getControl().isDisposed()) {
                this.outlinePage = this.createContentOutline();
                this.outlinePage.setEditor((IEditorPart)this);
                return this.outlinePage;
            }
            return this.outlinePage;
        }
        if (adapter == OutlineItem.class) {
            return this.getOutlineModel();
        }
        if (adapter == IShowInSource.class) {
            return this;
        }
        if (adapter == IShowInTarget.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected AbstractWikiTextSourceEditorOutline createContentOutline() {
        return new DefaultWikiTextSourceEditorOutline();
    }

    public void updatePartControl(IEditorInput input) {
        super.updatePartControl(input);
        this.updateDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDocument() {
        if (this.getSourceViewer() != null) {
            IDocument previousDocument = this.document;
            this.document = this.getSourceViewer().getDocument();
            if (previousDocument == this.document) {
                return;
            }
            if (previousDocument != null && this.documentListener != null) {
                previousDocument.removeDocumentListener(this.documentListener);
            }
            if (previousDocument != null && this.documentPartitioningListener != null) {
                previousDocument.removeDocumentPartitioningListener(this.documentPartitioningListener);
            }
            if (this.document != null) {
                if (this.documentListener == null) {
                    this.documentListener = new IDocumentListener(){

                        public void documentAboutToBeChanged(DocumentEvent event) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void documentChanged(DocumentEvent event) {
                            WikiTextSourceEditor.this.outlineDirty = true;
                            WikiTextSourceEditor wikiTextSourceEditor = WikiTextSourceEditor.this;
                            synchronized (wikiTextSourceEditor) {
                                WikiTextSourceEditor wikiTextSourceEditor2 = WikiTextSourceEditor.this;
                                wikiTextSourceEditor2.documentGeneration = wikiTextSourceEditor2.documentGeneration + 1;
                            }
                            WikiTextSourceEditor.this.scheduleOutlineUpdate();
                        }
                    };
                }
                this.document.addDocumentListener(this.documentListener);
                if (this.documentPartitioningListener == null) {
                    this.documentPartitioningListener = new IDocumentPartitioningListener(){

                        public void documentPartitioningChanged(IDocument document) {
                            WikiTextSourceEditor.this.scheduleOutlineUpdate();
                        }
                    };
                }
                this.document.addDocumentPartitioningListener(this.documentPartitioningListener);
            }
            WikiTextSourceEditor wikiTextSourceEditor = this;
            synchronized (wikiTextSourceEditor) {
                this.outlineDirty = true;
            }
            this.updateOutline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OutlineItem getOutlineModel() {
        WikiTextSourceEditor wikiTextSourceEditor = this;
        synchronized (wikiTextSourceEditor) {
            if (this.outlineDirty || this.outlineModel == null) {
                this.updateOutlineNow();
            }
            return this.outlineModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleOutlineUpdate() {
        WikiTextSourceEditor wikiTextSourceEditor = this;
        synchronized (wikiTextSourceEditor) {
            if (this.updateJobScheduled || this.outlineModel == null) {
                return;
            }
        }
        this.updateOutlineJob = new UIJob("WikiText - Outline Job"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                WikiTextSourceEditor wikiTextSourceEditor = WikiTextSourceEditor.this;
                synchronized (wikiTextSourceEditor) {
                    WikiTextSourceEditor.this.updateJobScheduled = false;
                }
                if (!WikiTextSourceEditor.this.outlineDirty) {
                    return Status.CANCEL_STATUS;
                }
                WikiTextSourceEditor.this.updateOutline();
                return Status.OK_STATUS;
            }
        };
        this.updateOutlineJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void scheduled(IJobChangeEvent event) {
                WikiTextSourceEditor wikiTextSourceEditor = WikiTextSourceEditor.this;
                synchronized (wikiTextSourceEditor) {
                    WikiTextSourceEditor.this.updateJobScheduled = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                WikiTextSourceEditor wikiTextSourceEditor = WikiTextSourceEditor.this;
                synchronized (wikiTextSourceEditor) {
                    WikiTextSourceEditor.this.updateJobScheduled = false;
                    WikiTextSourceEditor.this.updateOutlineJob = null;
                }
            }
        });
        this.updateOutlineJob.setUser(false);
        this.updateOutlineJob.setSystem(true);
        this.updateOutlineJob.setPriority(10);
        this.updateOutlineJob.schedule(600L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutline() {
        int contentGeneration;
        if (!this.outlineDirty) {
            return;
        }
        if (this.getSourceViewer().getTextWidget().isDisposed()) {
            return;
        }
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (markupLanguage == null) {
            return;
        }
        final MarkupLanguage language = markupLanguage.clone();
        final Display display = this.getSourceViewer().getTextWidget().getDisplay();
        final String content = this.document.get();
        WikiTextSourceEditor wikiTextSourceEditor = this;
        synchronized (wikiTextSourceEditor) {
            contentGeneration = this.documentGeneration;
            this.initializeOutlineParser();
        }
        Job parseOutlineJob = new Job(String.valueOf(WikiTextSourceEditor.class.getSimpleName()) + "#updateOutline"){

            protected IStatus run(IProgressMonitor monitor) {
                WikiTextSourceEditor.this.outlineParser.setMarkupLanguage(language);
                if (this.shouldCancel()) {
                    return Status.CANCEL_STATUS;
                }
                final OutlineItem rootItem = WikiTextSourceEditor.this.outlineParser.parse(content);
                if (this.shouldCancel()) {
                    return Status.CANCEL_STATUS;
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WikiTextSourceEditor.this.updateOutline(contentGeneration, rootItem);
                    }
                });
                return Status.OK_STATUS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean shouldCancel() {
                WikiTextSourceEditor wikiTextSourceEditor = WikiTextSourceEditor.this;
                synchronized (wikiTextSourceEditor) {
                    block4: {
                        if (contentGeneration == WikiTextSourceEditor.this.documentGeneration) break block4;
                        return true;
                    }
                }
                return false;
            }
        };
        parseOutlineJob.setPriority(10);
        parseOutlineJob.setSystem(true);
        parseOutlineJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutlineNow() {
        int contentGeneration;
        if (!this.outlineDirty) {
            return;
        }
        if (this.getSourceViewer().getTextWidget().isDisposed()) {
            return;
        }
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (markupLanguage == null) {
            return;
        }
        MarkupLanguage language = markupLanguage.clone();
        String content = this.document.get();
        WikiTextSourceEditor wikiTextSourceEditor = this;
        synchronized (wikiTextSourceEditor) {
            contentGeneration = this.documentGeneration;
            this.initializeOutlineParser();
        }
        this.outlineParser.setMarkupLanguage(language);
        OutlineItem rootItem = this.outlineParser.parse(content);
        this.updateOutline(contentGeneration, rootItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOutlineParser() {
        WikiTextSourceEditor wikiTextSourceEditor = this;
        synchronized (wikiTextSourceEditor) {
            if (this.outlineParser == null) {
                this.outlineParser = new OutlineParser();
                this.outlineParser.setLabelMaxLength(48);
                this.outlineModel = this.outlineParser.createRootItem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutline(int contentGeneration, OutlineItem rootItem) {
        if (this.getSourceViewer().getTextWidget().isDisposed()) {
            return;
        }
        WikiTextSourceEditor wikiTextSourceEditor = this;
        synchronized (wikiTextSourceEditor) {
            if (contentGeneration != this.documentGeneration) {
                return;
            }
        }
        this.outlineDirty = false;
        this.outlineModel.clear();
        this.outlineModel.moveChildren(rootItem);
        IFile file = (IFile)this.getAdapter(IFile.class);
        this.outlineModel.setResourcePath(file == null ? null : file.getFullPath().toString());
        this.firePropertyChange(0x10000001);
    }

    private void detectOutlineLocationChanged() {
        OutlineItem nearestItem = this.getNearestMatchingOutlineItem();
        if (!(nearestItem == this.outlineLocation || nearestItem != null && nearestItem.equals((Object)this.outlineLocation))) {
            this.outlineLocation = nearestItem;
            this.firePropertyChange(0x10000002);
        }
    }

    public ShowInContext getShowInContext() {
        OutlineItem item = this.getNearestMatchingOutlineItem();
        return new ShowInContext((Object)this.getEditorInput(), (ISelection)(item == null ? new StructuredSelection() : new StructuredSelection((Object)item)));
    }

    private OutlineItem getNearestMatchingOutlineItem() {
        Point selectedRange = this.getSourceViewer().getSelectedRange();
        if (selectedRange != null) {
            return this.getOutlineModel().findNearestMatchingOffset(selectedRange.x);
        }
        return null;
    }

    protected boolean isLineNumberRulerVisible() {
        return false;
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof OutlineItem) {
                    OutlineItem item = (OutlineItem)element;
                    this.selectAndReveal(item);
                    if (this.outlinePage != null && this.outlinePage.getControl() != null && !this.outlinePage.getControl().isDisposed()) {
                        this.outlinePage.setSelection(selection);
                    }
                    return true;
                }
                ++n2;
            }
        } else if (selection instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)selection;
            this.selectAndReveal(textSel.getOffset(), textSel.getLength());
            return true;
        }
        return false;
    }

    public void selectAndReveal(OutlineItem item) {
        this.selectAndReveal(item.getOffset(), item.getLength());
    }
}

