/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.ui.module;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.analysis.xml.ui.module.TmfAnalysisModuleHelperXml;
import org.eclipse.linuxtools.tmf.analysis.xml.ui.module.TmfXmlAnalysisOutputSource;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleSource;
import org.eclipse.linuxtools.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisManager;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlAnalysisModuleSource
implements IAnalysisModuleSource {
    private static final String TMF_XML_BUILTIN_ID = "org.eclipse.linuxtools.tmf.analysis.xml.core.files";
    private static final String XML_FILE_ELEMENT = "xmlfile";
    private static final String XML_FILE_ATTRIB = "file";
    private static List<IAnalysisModuleHelper> fModules = null;

    public XmlAnalysisModuleSource() {
        TmfAnalysisManager.addNewModuleListener((ITmfNewAnalysisModuleListener)new TmfXmlAnalysisOutputSource());
    }

    public synchronized Iterable<IAnalysisModuleHelper> getAnalysisModules() {
        if (fModules == null) {
            fModules = new ArrayList<IAnalysisModuleHelper>();
            XmlAnalysisModuleSource.populateBuiltinModules();
            XmlAnalysisModuleSource.populateAnalysisModules();
        }
        return fModules;
    }

    private static void processFile(File xmlFile) {
        if (!XmlUtils.xmlValidate((File)xmlFile).isOK()) {
            return;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
            int i = 0;
            while (i < stateproviderNodes.getLength()) {
                Element node = (Element)stateproviderNodes.item(i);
                TmfAnalysisModuleHelperXml helper = new TmfAnalysisModuleHelperXml(xmlFile, node, TmfAnalysisModuleHelperXml.XmlAnalysisModuleType.STATE_SYSTEM);
                fModules.add(helper);
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError("Error opening XML file", e);
        }
    }

    private static void populateBuiltinModules() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_XML_BUILTIN_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(XML_FILE_ELEMENT)) {
                Bundle bundle;
                String filename = element.getAttribute(XML_FILE_ATTRIB);
                String name = element.getContributor().getName();
                if (name != null && (bundle = Platform.getBundle((String)name)) != null) {
                    try {
                        URL xmlUrl = bundle.getResource(filename);
                        URL locatedURL = FileLocator.toFileURL((URL)xmlUrl);
                        XmlAnalysisModuleSource.processFile(new File(locatedURL.getFile()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
    }

    private static void populateAnalysisModules() {
        IPath pathToFiles = XmlUtils.getXmlFilesPath();
        File fFolder = pathToFiles.toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            XmlAnalysisModuleSource.processFile(xmlFile);
            ++n2;
        }
    }

    public static void notifyModuleChange() {
        fModules = null;
        TmfAnalysisManager.refreshModules();
    }
}

