/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.browser.BrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserDescriptorWorkingCopy;

public class BrowserDescriptor
implements IBrowserDescriptor {
    private static final String MEMENTO_NAME = "name";
    private static final String MEMENTO_LOCATION = "location";
    private static final String MEMENTO_PARAMETERS = "parameters";
    protected String name;
    protected String location;
    protected String parameters;

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void delete() {
        BrowserManager.getInstance().removeWebBrowser(this);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public IBrowserDescriptorWorkingCopy getWorkingCopy() {
        return new BrowserDescriptorWorkingCopy(this);
    }

    protected void setInternal(IBrowserDescriptor browser) {
        this.name = browser.getName();
        this.location = browser.getLocation();
        this.parameters = browser.getParameters();
    }

    protected void save(IMemento memento) {
        memento.putString(MEMENTO_NAME, this.name);
        memento.putString(MEMENTO_LOCATION, this.location);
        memento.putString(MEMENTO_PARAMETERS, this.parameters);
    }

    protected void load(IMemento memento) {
        this.name = memento.getString(MEMENTO_NAME);
        this.location = memento.getString(MEMENTO_LOCATION);
        this.parameters = memento.getString(MEMENTO_PARAMETERS);
    }

    public String toString() {
        return "External Web browser: " + this.getName() + " / " + this.getLocation() + " / " + this.getParameters();
    }
}

