/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.gprof.launch.GprofLaunchMessages;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class GprofNoGmonDialog
extends MessageDialog {
    private final IProject project;
    private String gmonPath = null;

    private static String[] buildButtons() {
        return new String[]{GprofLaunchMessages.GprofNoGmonDialog_Cancel, GprofLaunchMessages.GprofNoGmonDialog_Browse, GprofLaunchMessages.GprofNoGmonDialog_Workspace};
    }

    protected GprofNoGmonDialog(Shell parentShell, IProject project) {
        super(parentShell, GprofLaunchMessages.GprofCompilerOptions_msg, null, GprofLaunchMessages.GprofCompileAgain_msg, 4, GprofNoGmonDialog.buildButtons(), 0);
        this.project = project;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            String s;
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText(GprofLaunchMessages.GprofNoGmonDialog_OpenGmon);
            if (this.project != null) {
                dialog.setFilterPath(this.project.getLocation().toOSString());
            }
            if ((s = dialog.open()) != null) {
                this.gmonPath = s;
            }
        } else if (buttonId == 2) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(GprofLaunchMessages.GprofNoGmonDialog_OpenGmon);
            dialog.setMessage(GprofLaunchMessages.GprofNoGmonDialog_OpenGmon);
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            dialog.setAllowMultiple(false);
            dialog.setInitialSelection((Object)this.project);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length != 1) {
                        return new Status(4, "org.eclipse.linuxtools.gprof.launch", 0, "", null);
                    }
                    if (!(selection[0] instanceof IFile)) {
                        return new Status(4, "org.eclipse.linuxtools.gprof.launch", 0, "", null);
                    }
                    return new Status(0, "org.eclipse.linuxtools.gprof.launch", 0, "", null);
                }
            });
            if (dialog.open() == 0) {
                IResource resource = (IResource)dialog.getFirstResult();
                this.gmonPath = resource.getLocation().toOSString();
            }
        }
        if (this.gmonPath == null) {
            this.setReturnCode(0);
        } else {
            this.setReturnCode(buttonId);
        }
        this.close();
    }

    public String getPathToGmon() {
        return this.gmonPath;
    }
}

